/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.c14n.implementations;

import com.sun.org.apache.xml.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.security.c14n.CanonicalizerSpi;
import com.sun.org.apache.xml.security.c14n.helper.C14nHelper;
import com.sun.org.apache.xml.security.utils.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    boolean _includeComments = false;
    Set _xpathNodeSet = null;
    Document _doc = null;
    Element _documentElement = null;
    Node _rootNodeOfC14n = null;
    Node _excludeNode = null;
    Writer _writer = null;
    Set _inclusiveNSSet = null;
    static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    protected Attr nullNode;

    public CanonicalizerBase(boolean bl) {
        this._includeComments = bl;
    }

    public byte[] engineCanonicalizeSubTree(Node node) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(node, (Node)null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] engineCanonicalizeSubTree(Node node, Node node2) throws CanonicalizationException {
        this._excludeNode = node2;
        this._rootNodeOfC14n = node;
        this._doc = XMLUtils.getOwnerDocument(this._rootNodeOfC14n);
        this._documentElement = this._doc.getDocumentElement();
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
                if (this._rootNodeOfC14n instanceof Element) {
                    this.getParentNameSpaces((Element)this._rootNodeOfC14n, nameSpaceSymbTable);
                }
                this.canonicalizeSubTree(this._rootNodeOfC14n, nameSpaceSymbTable);
                this._writer.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Object var7_8 = null;
                this._rootNodeOfC14n = null;
                this._excludeNode = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this._rootNodeOfC14n = null;
            this._excludeNode = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeSubTree(Node node, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException, IOException {
        short s = node.getNodeType();
        switch (s) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.canonicalizeSubTree(node2, nameSpaceSymbTable);
                }
                break;
            }
            case 8: {
                if (!this._includeComments) break;
                this.outputCommentToWriter((Comment)node);
                break;
            }
            case 7: {
                this.outputPItoWriter((ProcessingInstruction)node);
                break;
            }
            case 3: 
            case 4: {
                this.outputTextToWriter(node.getNodeValue());
                break;
            }
            case 1: {
                if (node == this._excludeNode) {
                    return;
                }
                Element element = (Element)node;
                nameSpaceSymbTable.outputNodePush();
                this._writer.write("<");
                this._writer.write(element.getTagName());
                Object[] objectArray = this.handleAttributesSubtree(element, nameSpaceSymbTable);
                for (int i = 0; i < objectArray.length; ++i) {
                    Attr attr = (Attr)objectArray[i];
                    this.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue());
                }
                this._writer.write(">");
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    this.canonicalizeSubTree(node3, nameSpaceSymbTable);
                }
                this._writer.write("</");
                this._writer.write(element.getTagName());
                this._writer.write(">");
                nameSpaceSymbTable.outputNodePop();
            }
        }
    }

    static int getPositionRelativeToDocumentElement(Node node) {
        if (node == null) {
            return 0;
        }
        Document document = node.getOwnerDocument();
        if (node.getParentNode() != document) {
            return 0;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return 0;
        }
        if (element == node) {
            return 0;
        }
        for (Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (node2 != element) continue;
            return -1;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] engineCanonicalizeXPathNodeSet(Set set, String string) throws CanonicalizationException {
        this._xpathNodeSet = set;
        if (this._xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        Object object = (Node)this._xpathNodeSet.iterator().next();
        this._doc = XMLUtils.getOwnerDocument((Node)object);
        this._documentElement = this._doc.getDocumentElement();
        this.nullNode = this._doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        this.nullNode.setValue("");
        try {
            try {
                object = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)object, "UTF8");
                this.canonicalizeXPathNodeSet(this._doc, new NameSpaceSymbTable());
                this._writer.close();
                byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                Object var6_7 = null;
                this._xpathNodeSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this._xpathNodeSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] engineCanonicalizeXPathNodeSet(Set set) throws CanonicalizationException {
        this._xpathNodeSet = set;
        if (this._xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        if (this._doc == null) {
            this._doc = XMLUtils.getOwnerDocument(this._xpathNodeSet);
            this._documentElement = this._doc.getDocumentElement();
            this._rootNodeOfC14n = this._doc;
            this.nullNode = this._doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
            this.nullNode.setValue("");
        }
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                this.canonicalizeXPathNodeSet(this._rootNodeOfC14n, new NameSpaceSymbTable());
                this._writer.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Object var5_6 = null;
                this._xpathNodeSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this._xpathNodeSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeXPathNodeSet(Node node, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException, IOException {
        short s = node.getNodeType();
        boolean bl = this._xpathNodeSet.contains(node);
        switch (s) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(node2, nameSpaceSymbTable);
                }
                break;
            }
            case 8: {
                if (!this._includeComments || !this._xpathNodeSet.contains(node)) break;
                this.outputCommentToWriter((Comment)node);
                break;
            }
            case 7: {
                if (!this._xpathNodeSet.contains(node)) break;
                this.outputPItoWriter((ProcessingInstruction)node);
                break;
            }
            case 3: 
            case 4: {
                if (!this._xpathNodeSet.contains(node)) break;
                this.outputTextToWriter(node.getNodeValue());
                for (Node node3 = node.getNextSibling(); node3 != null && (node3.getNodeType() == 3 || node3.getNodeType() == 4); node3 = node3.getNextSibling()) {
                    this.outputTextToWriter(node3.getNodeValue());
                }
                break;
            }
            case 1: {
                Element element = (Element)node;
                if (bl) {
                    nameSpaceSymbTable.outputNodePush();
                    this._writer.write("<");
                    this._writer.write(element.getTagName());
                } else {
                    nameSpaceSymbTable.push();
                }
                Object[] objectArray = this.handleAttributes(element, nameSpaceSymbTable);
                objectArray = C14nHelper.sortAttributes(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    Attr attr = (Attr)objectArray[i];
                    this.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue());
                }
                if (bl) {
                    this._writer.write(">");
                }
                for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(node4, nameSpaceSymbTable);
                }
                if (bl) {
                    this._writer.write("</");
                    this._writer.write(element.getTagName());
                    this._writer.write(">");
                    nameSpaceSymbTable.outputNodePop();
                    break;
                }
                nameSpaceSymbTable.pop();
            }
        }
    }

    void getParentNameSpaces(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        Object object;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Node node = element.getParentNode();
        if (!(node instanceof Element)) {
            return;
        }
        Element element2 = (Element)element.getParentNode();
        while (element2 != null) {
            arrayList.add(element2);
            object = element2.getParentNode();
            if (!(object instanceof Element)) break;
            element2 = (Element)object;
        }
        object = arrayList.listIterator(arrayList.size());
        while (object.hasPrevious()) {
            Element element3 = (Element)object.previous();
            NamedNodeMap namedNodeMap = element3.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                if (C14nHelper.namespaceIsRelative(attr)) {
                    Object[] objectArray = new Object[]{element3.getTagName(), attr.getName(), attr.getNodeValue()};
                    throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
                }
                if ("xml".equals(attr.getLocalName()) && "http://www.w3.org/XML/1998/namespace".equals(attr.getNodeValue())) continue;
                nameSpaceSymbTable.addMapping(attr.getName(), attr.getValue(), attr);
            }
        }
    }

    void outputAttrToWriter(String string, String string2) throws IOException {
        this._writer.write(" ");
        this._writer.write(string);
        this._writer.write("=\"");
        int n = string2.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    continue block8;
                }
                case '<': {
                    this._writer.write("&lt;");
                    continue block8;
                }
                case '\"': {
                    this._writer.write("&quot;");
                    continue block8;
                }
                case '\t': {
                    this._writer.write("&#x9;");
                    continue block8;
                }
                case '\n': {
                    this._writer.write("&#xA;");
                    continue block8;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    continue block8;
                }
                default: {
                    this._writer.write(c);
                }
            }
        }
        this._writer.write("\"");
    }

    void outputPItoWriter(ProcessingInstruction processingInstruction) throws IOException {
        int n = CanonicalizerBase.getPositionRelativeToDocumentElement(processingInstruction);
        if (n == 1) {
            this._writer.write(10);
        }
        this._writer.write("<?");
        String string = processingInstruction.getTarget();
        char[] cArray = string.toCharArray();
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\r': {
                    this._writer.write("&#xD;");
                    continue block6;
                }
                default: {
                    this._writer.write(cArray[i]);
                }
            }
        }
        String string2 = processingInstruction.getData();
        cArray = string2.toCharArray();
        if (string2 != null && cArray.length > 0) {
            this._writer.write(32);
            block7: for (int i = 0; i < cArray.length; ++i) {
                switch (cArray[i]) {
                    case '\r': {
                        this._writer.write("&#xD;");
                        continue block7;
                    }
                    default: {
                        this._writer.write(cArray[i]);
                    }
                }
            }
        }
        this._writer.write("?>");
        if (n == -1) {
            this._writer.write(10);
        }
    }

    void outputCommentToWriter(Comment comment) throws IOException {
        int n = CanonicalizerBase.getPositionRelativeToDocumentElement(comment);
        if (n == 1) {
            this._writer.write(10);
        }
        this._writer.write("<!--");
        String string = comment.getData();
        char[] cArray = string.toCharArray();
        block3: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\r': {
                    this._writer.write("&#xD;");
                    continue block3;
                }
                default: {
                    this._writer.write(cArray[i]);
                }
            }
        }
        this._writer.write("-->");
        if (n == -1) {
            this._writer.write(10);
        }
    }

    void outputTextToWriter(String string) throws IOException {
        char[] cArray = string.toCharArray();
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '&': {
                    this._writer.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this._writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this._writer.write("&gt;");
                    continue block6;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    continue block6;
                }
                default: {
                    this._writer.write(cArray[i]);
                }
            }
        }
    }

    abstract Object[] handleAttributes(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    abstract Object[] handleAttributesSubtree(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    public boolean is_includeComments() {
        return this._includeComments;
    }

    public void set_includeComments(boolean bl) {
        this._includeComments = bl;
    }

    protected static final class NameSpaceSymbTable {
        Map symb = new HashMap();
        int nameSpaces = 0;
        List level = new ArrayList();
        int current = 0;

        public NameSpaceSymbTable() {
            NameSpaceSymbEntry nameSpaceSymbEntry = new NameSpaceSymbEntry("", null, true);
            nameSpaceSymbEntry.lastrendered = "";
            this.symb.put("xmlns", nameSpaceSymbEntry);
        }

        public List getUnrenderedNodes() {
            ArrayList<Attr> arrayList = new ArrayList<Attr>();
            Iterator iterator = this.symb.entrySet().iterator();
            while (iterator.hasNext()) {
                NameSpaceSymbEntry nameSpaceSymbEntry = (NameSpaceSymbEntry)iterator.next().getValue();
                if (nameSpaceSymbEntry.rendered || nameSpaceSymbEntry.n == null) continue;
                arrayList.add(nameSpaceSymbEntry.n);
                nameSpaceSymbEntry.rendered = true;
            }
            return arrayList;
        }

        public void outputNodePush() {
            ++this.nameSpaces;
            this.push();
        }

        public void outputNodePop() {
            --this.nameSpaces;
            this.pop();
        }

        public void push() {
            this.level.add(new Integer(this.current));
            this.current = 0;
        }

        public void pop() {
            int n = this.level.size() - 1;
            int n2 = 0;
            if (this.current != 0) {
                for (n2 = 0; n2 < this.current; ++n2) {
                    Object e = this.level.remove(n - n2);
                    if (e instanceof Object[]) {
                        Object[] objectArray = (Object[])e;
                        this.symb.put(objectArray[0], objectArray[1]);
                        continue;
                    }
                    this.symb.remove(e);
                }
            }
            this.current = (Integer)this.level.remove(n - n2);
        }

        public Attr getMapping(String string) {
            NameSpaceSymbEntry nameSpaceSymbEntry = (NameSpaceSymbEntry)this.symb.get(string);
            if (nameSpaceSymbEntry == null) {
                return null;
            }
            if (nameSpaceSymbEntry.rendered) {
                return null;
            }
            Object[] objectArray = new Object[]{string, nameSpaceSymbEntry.clone()};
            this.level.add(objectArray);
            nameSpaceSymbEntry.rendered = true;
            nameSpaceSymbEntry.level = this.nameSpaces;
            nameSpaceSymbEntry.lastrendered = nameSpaceSymbEntry.uri;
            ++this.current;
            return nameSpaceSymbEntry.n;
        }

        public Attr getMappingWithoutRendered(String string) {
            NameSpaceSymbEntry nameSpaceSymbEntry = (NameSpaceSymbEntry)this.symb.get(string);
            if (nameSpaceSymbEntry == null) {
                return null;
            }
            if (nameSpaceSymbEntry.rendered) {
                return null;
            }
            return nameSpaceSymbEntry.n;
        }

        public void addMapping(String string, String string2, Attr attr) {
            NameSpaceSymbEntry nameSpaceSymbEntry = (NameSpaceSymbEntry)this.symb.get(string);
            if (nameSpaceSymbEntry != null && string2.equals(nameSpaceSymbEntry.uri)) {
                return;
            }
            NameSpaceSymbEntry nameSpaceSymbEntry2 = new NameSpaceSymbEntry(string2, attr, false);
            this.symb.put(string, nameSpaceSymbEntry2);
            if (nameSpaceSymbEntry != null) {
                Object[] objectArray = new Object[]{string, nameSpaceSymbEntry};
                this.level.add(objectArray);
                nameSpaceSymbEntry2.lastrendered = nameSpaceSymbEntry.lastrendered;
                if (nameSpaceSymbEntry.lastrendered != null && nameSpaceSymbEntry.lastrendered.equals(string2)) {
                    nameSpaceSymbEntry2.rendered = true;
                }
            } else {
                this.level.add(string);
            }
            ++this.current;
        }

        public Node addMappingAndRender(String string, String string2, Attr attr) {
            NameSpaceSymbEntry nameSpaceSymbEntry = (NameSpaceSymbEntry)this.symb.get(string);
            if (nameSpaceSymbEntry != null && string2.equals(nameSpaceSymbEntry.uri)) {
                if (!nameSpaceSymbEntry.rendered) {
                    Object[] objectArray = new Object[]{string, nameSpaceSymbEntry.clone()};
                    this.level.add(objectArray);
                    ++this.current;
                    nameSpaceSymbEntry.rendered = true;
                    return nameSpaceSymbEntry.n;
                }
                return null;
            }
            NameSpaceSymbEntry nameSpaceSymbEntry2 = new NameSpaceSymbEntry(string2, attr, true);
            this.symb.put(string, nameSpaceSymbEntry2);
            if (nameSpaceSymbEntry != null) {
                Object[] objectArray = new Object[]{string, nameSpaceSymbEntry};
                nameSpaceSymbEntry2.lastrendered = nameSpaceSymbEntry.lastrendered;
                if (nameSpaceSymbEntry.lastrendered != null && nameSpaceSymbEntry.lastrendered.equals(string2)) {
                    nameSpaceSymbEntry2.rendered = true;
                }
                this.level.add(objectArray);
            } else {
                this.level.add(string);
            }
            ++this.current;
            return nameSpaceSymbEntry2.n;
        }

        public Node addMappingAndRenderXNodeSet(String string, String string2, Attr attr, boolean bl) {
            NameSpaceSymbEntry nameSpaceSymbEntry = (NameSpaceSymbEntry)this.symb.get(string);
            int n = this.nameSpaces;
            if (nameSpaceSymbEntry != null && string2.equals(nameSpaceSymbEntry.uri)) {
                if (!nameSpaceSymbEntry.rendered) {
                    Object[] objectArray = new Object[]{string, nameSpaceSymbEntry.clone()};
                    this.level.add(objectArray);
                    ++this.current;
                    nameSpaceSymbEntry.rendered = true;
                    nameSpaceSymbEntry.level = n;
                    return nameSpaceSymbEntry.n;
                }
                Object[] objectArray = new Object[]{string, nameSpaceSymbEntry.clone()};
                ++this.current;
                this.level.add(objectArray);
                if (bl && (n - nameSpaceSymbEntry.level < 2 || "xmlns".equals(string))) {
                    nameSpaceSymbEntry.level = n;
                    return null;
                }
                nameSpaceSymbEntry.level = n;
                return nameSpaceSymbEntry.n;
            }
            NameSpaceSymbEntry nameSpaceSymbEntry2 = new NameSpaceSymbEntry(string2, attr, true);
            nameSpaceSymbEntry2.level = this.nameSpaces;
            nameSpaceSymbEntry2.rendered = true;
            this.symb.put(string, nameSpaceSymbEntry2);
            if (nameSpaceSymbEntry != null) {
                Object[] objectArray = new Object[]{string, nameSpaceSymbEntry};
                nameSpaceSymbEntry2.lastrendered = nameSpaceSymbEntry.lastrendered;
                if (nameSpaceSymbEntry.lastrendered != null && nameSpaceSymbEntry.lastrendered.equals(string2)) {
                    nameSpaceSymbEntry2.rendered = true;
                }
                this.level.add(objectArray);
            } else {
                this.level.add(string);
            }
            ++this.current;
            return nameSpaceSymbEntry2.n;
        }

        final class NameSpaceSymbEntry {
            int level = 0;
            String uri;
            String lastrendered = null;
            boolean rendered = false;
            Attr n;

            public NameSpaceSymbEntry(String string, Attr attr, boolean bl) {
                this.uri = string;
                this.rendered = bl;
                this.n = attr;
            }

            public Object clone() {
                NameSpaceSymbEntry nameSpaceSymbEntry = new NameSpaceSymbEntry(this.uri, this.n, this.rendered);
                nameSpaceSymbEntry.level = this.level;
                return nameSpaceSymbEntry;
            }
        }
    }
}

