/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.j2se.MOAgents;

import com.sun.management.j2se.MOAgents.EmmaNotificationBroadcaster;
import com.sun.management.j2se.MOAgents.EmmaNotificationInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class EmmaBeanUtil {
    public static Object getAttribute(String attribute_name, Object emmaBean, String srcClassName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method m;
        if (attribute_name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null, Cannot invoke a getter of " + srcClassName + " with null attribute name"));
        }
        StringBuffer getAttr = new StringBuffer("get" + attribute_name.trim());
        StringBuffer isAttr = new StringBuffer("is" + attribute_name.trim());
        Class<?> clazz = emmaBean.getClass().getSuperclass();
        Class[] args = new Class[]{};
        Object[] argsObj = new Object[]{};
        try {
            m = clazz.getMethod(getAttr.toString(), args);
            Class<?> ret_clazz = m.getReturnType();
        }
        catch (Exception e) {
            try {
                m = clazz.getMethod(isAttr.toString(), args);
            }
            catch (Exception e1) {
                throw new AttributeNotFoundException("Cannot find " + attribute_name + " attribute in " + srcClassName);
            }
        }
        try {
            return m.invoke(emmaBean, argsObj);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t == null || !(t instanceof Exception)) {
                throw new ReflectionException(ite);
            }
            throw new ReflectionException((Exception)t);
        }
        catch (Exception e) {
            throw new AttributeNotFoundException("Cannot invoke " + attribute_name + " attribute in " + srcClassName);
        }
    }

    public static AttributeList getAttributes(String[] attributeNames, Object emmaBean, String srcClassName) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + srcClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        int i = 0;
        while (i < attributeNames.length) {
            try {
                Object value = EmmaBeanUtil.getAttribute(attributeNames[i], emmaBean, srcClassName);
                resultList.add(new Attribute(attributeNames[i], value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return resultList;
    }

    public static void setAttribute(Attribute attribute, Object emmaBean, String srcClassName, Hashtable notificationInfo) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        EmmaNotificationInfo eni;
        Class value_clazz;
        boolean isNotifier;
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke setter of " + srcClassName + " with a null attribute");
        }
        String name = attribute.getName().trim();
        Object value = attribute.getValue();
        Object previousValue = null;
        boolean bl = isNotifier = notificationInfo != null;
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke set of " + srcClassName + " with null attr name");
        }
        StringBuffer setAttr = new StringBuffer("set" + name);
        Class<?> clazz = emmaBean.getClass().getSuperclass();
        Class[] args = new Class[1];
        Object[] argsObj = new Object[]{value};
        Method m = null;
        args[0] = value_clazz = EmmaBeanUtil.getAttributeReturnType(name, emmaBean);
        try {
            m = clazz.getMethod(setAttr.toString(), args);
            if (isNotifier && (eni = (EmmaNotificationInfo)notificationInfo.get(m)) != null) {
                previousValue = EmmaBeanUtil.getAttribute(name, emmaBean, srcClassName);
            }
            m.invoke(emmaBean, argsObj);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t == null || !(t instanceof Exception)) {
                throw new ReflectionException(ite);
            }
            throw new ReflectionException((Exception)t);
        }
        catch (Exception x) {
            System.out.println(x);
            System.out.println(" Method = " + m);
            System.out.println(" arg class = " + value_clazz.getName());
            throw new AttributeNotFoundException("Cannot find or invoke " + name + " attribute in " + srcClassName);
        }
        if (isNotifier && m != null) {
            eni = (EmmaNotificationInfo)notificationInfo.get(m);
            if (eni == null) {
                return;
            }
            AttributeChangeNotification n = new AttributeChangeNotification(emmaBean, -1L, System.currentTimeMillis(), AttributeChangeNotification.ATTRIBUTE_CHANGE, name, value_clazz.getName(), previousValue, value);
            ((EmmaNotificationBroadcaster)emmaBean).sendNotification(n);
        }
    }

    public static AttributeList setAttributes(AttributeList attributes, Object emmaBean, String srcClassName, Hashtable notificationInfo) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeList cannot be null"), "Cannot invoke a setter of " + srcClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            try {
                EmmaBeanUtil.setAttribute(attr, emmaBean, srcClassName, notificationInfo);
                String name = attr.getName();
                Object value = EmmaBeanUtil.getAttribute(name, emmaBean, srcClassName);
                resultList.add(new Attribute(name, value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public static Object invoke(String opName, Object[] params, String[] signature, Object emmaBean, String srcClassName, Hashtable notificationInfo) throws MBeanException, ReflectionException {
        boolean isNotifier;
        boolean bl = isNotifier = notificationInfo != null;
        if (opName == null || signature == null || params == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name, signature, params cannot be null"), "Cannot invoke a null operation in " + srcClassName);
        }
        StringBuffer invokee = new StringBuffer(opName.trim());
        Class<?> clazz = emmaBean.getClass().getSuperclass();
        EmmaNotificationInfo eni = null;
        try {
            Notification n;
            int i;
            Class[] args = EmmaBeanUtil.buildInvocationSignature(signature);
            Method m = clazz.getMethod(invokee.toString(), args);
            if (isNotifier && (eni = (EmmaNotificationInfo)notificationInfo.get(m)) != null && eni.isPreNotifier()) {
                i = 0;
                while (i < eni.getPreNotificationName().length) {
                    n = new Notification(eni.getPreNotificationName()[i], emmaBean, -1L);
                    ((EmmaNotificationBroadcaster)emmaBean).sendNotification(n);
                    ++i;
                }
            }
            Object ret = m.invoke(emmaBean, params);
            if (isNotifier && eni != null && eni.isNotifier()) {
                i = 0;
                while (i < eni.getNotificationName().length) {
                    n = new Notification(eni.getNotificationName()[i], emmaBean, -1L);
                    ((EmmaNotificationBroadcaster)emmaBean).sendNotification(n);
                    ++i;
                }
            }
            return ret;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t == null || !(t instanceof Exception)) {
                throw new ReflectionException(ite);
            }
            t.printStackTrace();
            throw new ReflectionException((Exception)t);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new ReflectionException(e);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ReflectionException(new NoSuchMethodException(opName), "Cannot find the operation " + opName + " in " + srcClassName);
        }
    }

    private static Class getAttributeReturnType(String attribute_name, Object emmaBean) {
        StringBuffer getAttr = new StringBuffer("get" + attribute_name);
        Class<?> clazz = emmaBean.getClass().getSuperclass();
        Class<?> ret_clazz = null;
        Class[] args = new Class[]{};
        Object[] argsObj = new Object[]{};
        try {
            Method m = clazz.getMethod(getAttr.toString(), args);
            ret_clazz = m.getReturnType();
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret_clazz;
    }

    private static Class[] buildInvocationSignature(String[] signature) throws ClassNotFoundException {
        Class[] clazzes = new Class[signature.length];
        int i = 0;
        while (i < signature.length) {
            clazzes[i] = signature[i].equals("int") ? Integer.TYPE : (signature[i].equals("short") ? Short.TYPE : (signature[i].equals("float") ? Float.TYPE : (signature[i].equals("boolean") ? Boolean.TYPE : (signature[i].equals("long") ? Long.TYPE : (signature[i].equals("char") ? Character.TYPE : (signature[i].equals("byte") ? Byte.TYPE : (signature[i].equals("double") ? Double.TYPE : Class.forName(signature[i]))))))));
            ++i;
        }
        return clazzes;
    }
}

