/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.ProxyChecker;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.otsidl.ResourceStatus;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.Vote;

class RegisteredResources {
    private ArrayList resourceObjects = null;
    private ArrayList resourceStates = null;
    private CoordinatorLog logRecord = null;
    private java.lang.Object logSection = null;
    private java.lang.Object heuristicLogSection = null;
    private Resource laoResource = null;
    private CoordinatorImpl coord = null;
    private static boolean lastXAResCommit = false;
    private int nRes = 0;
    private static final String LOG_SECTION_NAME = "RR";
    private static final String HEURISTIC_LOG_SECTION_NAME = "RRH";
    static Logger _logger;

    RegisteredResources(CoordinatorLog log, CoordinatorImpl coord) {
        this.resourceObjects = new ArrayList();
        this.resourceStates = new ArrayList();
        this.logRecord = log;
        if (log != null) {
            // empty if block
        }
        this.coord = coord;
    }

    RegisteredResources(CoordinatorImpl coord) {
        this.coord = coord;
    }

    public void finalize() {
        if (this.resourceObjects != null) {
            this.empty();
        }
        this.resourceObjects = null;
        this.resourceStates = null;
        this.logRecord = null;
        this.logSection = null;
        this.heuristicLogSection = null;
    }

    void reconstruct(CoordinatorLog log) {
        Resource res;
        int commitRetriesLeft;
        boolean exceptionThrown;
        int i;
        this.resourceObjects = new ArrayList();
        this.resourceStates = new ArrayList();
        boolean infiniteRetry = true;
        int commitRetries = Configuration.getRetries();
        if (commitRetries >= 0) {
            infiniteRetry = false;
        }
        this.heuristicLogSection = log.createSection(HEURISTIC_LOG_SECTION_NAME);
        java.lang.Object[] resources = log.getObjects(this.heuristicLogSection);
        for (i = 0; i < resources.length; ++i) {
            exceptionThrown = true;
            commitRetriesLeft = commitRetries;
            while (exceptionThrown) {
                try {
                    res = ResourceHelper.narrow((Object)resources[i]);
                    if (res != null) {
                        this.resourceObjects.add(res);
                        ++this.nRes;
                        this.resourceStates.add(ResourceStatus.Heuristic);
                    }
                    exceptionThrown = false;
                }
                catch (Throwable exc) {
                    if (exc instanceof TRANSIENT || exc instanceof COMM_FAILURE) {
                        _logger.log(Level.WARNING, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "reconstruct"});
                        if (commitRetriesLeft > 0 || infiniteRetry) {
                            if (!infiniteRetry) {
                                --commitRetriesLeft;
                            }
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (Throwable e) {}
                            continue;
                        }
                        _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                        String msg = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                        throw new INTERNAL(msg);
                    }
                    exceptionThrown = false;
                }
            }
        }
        this.logSection = log.createSection(LOG_SECTION_NAME);
        resources = log.getObjects(this.logSection);
        for (i = 0; i < resources.length; ++i) {
            exceptionThrown = true;
            commitRetriesLeft = commitRetries;
            while (exceptionThrown) {
                try {
                    res = ResourceHelper.narrow((Object)resources[i]);
                    if (res != null) {
                        this.resourceObjects.add(res);
                        ++this.nRes;
                        this.resourceStates.add(ResourceStatus.Registered);
                    }
                    exceptionThrown = false;
                }
                catch (Throwable exc) {
                    if (exc instanceof TRANSIENT || exc instanceof COMM_FAILURE) {
                        _logger.log(Level.WARNING, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "reconstruct"});
                        if (commitRetriesLeft > 0 || infiniteRetry) {
                            if (!infiniteRetry) {
                                --commitRetriesLeft;
                            }
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (Throwable e) {}
                            continue;
                        }
                        _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                        String msg = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                        throw new INTERNAL(msg);
                    }
                    exceptionThrown = false;
                }
            }
        }
        this.logRecord = log;
    }

    int addRes(Resource obj) {
        this.resourceObjects.add(obj);
        ++this.nRes;
        this.resourceStates.add(ResourceStatus.Registered);
        return this.nRes;
    }

    void empty() {
        this.resourceObjects.clear();
        this.nRes = 0;
        this.resourceStates.clear();
    }

    boolean involved() {
        boolean result = this.nRes != 0;
        return result;
    }

    int numRegistered() {
        return this.nRes;
    }

    Vote distributePrepare() throws HeuristicMixed, HeuristicHazard {
        boolean isProxy = false;
        Vote result = Vote.VoteReadOnly;
        int laoIndex = -1;
        boolean rmErr = false;
        for (int i = 0; i < this.nRes && result != Vote.VoteRollback; ++i) {
            Resource currResource = (Resource)this.resourceObjects.get(i);
            if (i == this.nRes - 1 && lastXAResCommit && this.laoResource == null && result == Vote.VoteCommit) {
                try {
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "distributePrepare()", "Before invoking commit on LA resource = " + currResource);
                    }
                    currResource.commit_one_phase();
                    this.resourceStates.set(i, ResourceStatus.Completed);
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "distributePrepare()", "After invoking commit on LA resource = " + currResource);
                    }
                }
                catch (Throwable exc) {
                    result = Vote.VoteRollback;
                    this.resourceStates.set(i, ResourceStatus.Completed);
                }
                return result;
            }
            if (!(currResource instanceof OTSResourceImpl)) {
                ProxyChecker checkProxy = Configuration.getProxyChecker();
                isProxy = checkProxy.isProxy(currResource);
            }
            Vote currResult = Vote.VoteRollback;
            try {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.logp(Level.FINER, "RegisteredResources", "prepare()", "Before invoking prepare() on resource:" + currResource);
                }
                if ((currResult = currResource.prepare()) == null) {
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "prepare()", "Marking the current resource as LAO:" + currResource);
                    }
                    this.laoResource = currResource;
                    laoIndex = i;
                    continue;
                }
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.logp(Level.FINER, "RegisteredResources", "prepare()", "After invoking prepare() on resource:" + currResource + ";This resource voted : " + currResult);
                }
            }
            catch (Throwable exc) {
                boolean hazard = exc instanceof HeuristicHazard;
                if (exc instanceof HeuristicMixed || hazard) {
                    block28: {
                        this.resourceStates.set(i, ResourceStatus.Heuristic);
                        try {
                            this.distributeRollback(true);
                        }
                        catch (Throwable ex2) {
                            if (!(ex2 instanceof HeuristicMixed) || !hazard) break block28;
                            hazard = false;
                        }
                    }
                    if (hazard) {
                        HeuristicHazard ex2 = new HeuristicHazard();
                        throw ex2;
                    }
                    HeuristicMixed ex2 = new HeuristicMixed();
                    throw ex2;
                }
                if (exc instanceof RuntimeException) {
                    rmErr = true;
                }
                _logger.log(Level.WARNING, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "prepare"});
            }
            if (currResult == Vote.VoteCommit) {
                if (this.logRecord != null && !(currResource instanceof OTSResourceImpl)) {
                    if (this.logSection == null) {
                        this.logSection = this.logRecord.createSection(LOG_SECTION_NAME);
                    }
                    this.logRecord.addObject(this.logSection, currResource);
                }
                if (result != Vote.VoteReadOnly) continue;
                result = Vote.VoteCommit;
                continue;
            }
            if (!rmErr) {
                this.resourceStates.set(i, ResourceStatus.Completed);
            }
            if (isProxy) {
                currResource._release();
            }
            if (currResult != Vote.VoteRollback) continue;
            result = currResult;
        }
        if (result == Vote.VoteCommit && this.laoResource != null) {
            try {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.logp(Level.FINER, "RegisteredResources", "distributePrepare()", "Before invoking commit on LA resource = " + this.laoResource);
                }
                this.laoResource.commit();
                this.resourceStates.set(laoIndex, ResourceStatus.Completed);
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.logp(Level.FINER, "RegisteredResources", "distributePrepare()", "After invoking commit on LA resource = " + this.laoResource);
                }
            }
            catch (Throwable exc) {
                result = Vote.VoteRollback;
                this.resourceStates.set(laoIndex, ResourceStatus.Completed);
            }
        }
        return result;
    }

    void distributeCommit() throws HeuristicMixed, HeuristicHazard, NotPrepared {
        boolean infiniteRetry = true;
        boolean isProxy = false;
        boolean heuristicException = false;
        boolean heuristicMixed = false;
        int commitRetries = Configuration.getRetries();
        if (commitRetries >= 0) {
            infiniteRetry = false;
        }
        boolean transactionCompleted = true;
        String msg = null;
        for (int i = 0; i < this.nRes; ++i) {
            Resource currResource = (Resource)this.resourceObjects.get(i);
            if ((ResourceStatus)this.resourceStates.get(i) != ResourceStatus.Registered) continue;
            boolean heuristicRaised = false;
            if (!(currResource instanceof OTSResourceImpl)) {
                ProxyChecker checkProxy = Configuration.getProxyChecker();
                isProxy = checkProxy.isProxy(currResource);
            }
            this.resourceStates.set(i, ResourceStatus.Completing);
            int commitRetriesLeft = commitRetries;
            boolean exceptionThrown = true;
            while (exceptionThrown) {
                try {
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "distributeCommit()", "Before invoking commit on resource = " + currResource);
                    }
                    currResource.commit();
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "distributeCommit()", "After invoking commit on resource = " + currResource);
                    }
                    exceptionThrown = false;
                }
                catch (Throwable exc) {
                    if (exc instanceof HeuristicCommit) {
                        heuristicException = true;
                        heuristicRaised = true;
                        exceptionThrown = false;
                        continue;
                    }
                    if (exc instanceof HeuristicRollback || exc instanceof HeuristicHazard || exc instanceof HeuristicMixed) {
                        heuristicException = true;
                        heuristicMixed = !(exc instanceof HeuristicHazard);
                        heuristicRaised = true;
                        exceptionThrown = false;
                        continue;
                    }
                    if (exc instanceof INV_OBJREF || exc instanceof OBJECT_NOT_EXIST) {
                        exceptionThrown = false;
                        continue;
                    }
                    if (exc instanceof NotPrepared) {
                        _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "commit"});
                        throw (NotPrepared)((java.lang.Object)exc);
                    }
                    if (!(exc instanceof TRANSIENT) && !(exc instanceof COMM_FAILURE)) {
                        _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "commit"});
                        exceptionThrown = false;
                        transactionCompleted = false;
                        msg = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "commit"});
                        continue;
                    }
                    if (commitRetriesLeft > 0 || infiniteRetry) {
                        if (!infiniteRetry) {
                            --commitRetriesLeft;
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Throwable e) {}
                        continue;
                    }
                    _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                    exceptionThrown = false;
                    transactionCompleted = false;
                    msg = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commit"});
                }
            }
            if (heuristicRaised) {
                this.resourceStates.set(i, ResourceStatus.Heuristic);
                if (this.logRecord == null || currResource instanceof OTSResourceImpl) continue;
                if (this.heuristicLogSection == null) {
                    this.heuristicLogSection = this.logRecord.createSection(HEURISTIC_LOG_SECTION_NAME);
                }
                this.logRecord.addObject(this.heuristicLogSection, currResource);
                continue;
            }
            this.resourceStates.set(i, ResourceStatus.Completed);
            if (!isProxy) continue;
            currResource._release();
        }
        if (heuristicException) {
            this.distributeForget(commitRetries, infiniteRetry, heuristicMixed);
        }
        if (!transactionCompleted) {
            if (this.coord != null) {
                RecoveryManager.addToIncompleTx(this.coord, true);
            }
            if (msg != null) {
                throw new INTERNAL(msg);
            }
            throw new INTERNAL();
        }
    }

    void distributeRollback(boolean heuristicException) throws HeuristicMixed, HeuristicHazard {
        boolean infiniteRetry = true;
        boolean heuristicMixed = false;
        boolean isProxy = false;
        int commitRetries = Configuration.getRetries();
        if (commitRetries >= 0) {
            infiniteRetry = false;
        }
        boolean transactionCompleted = true;
        String msg = null;
        for (int i = 0; i < this.nRes; ++i) {
            Resource currResource = (Resource)this.resourceObjects.get(i);
            if (!this.resourceStates.get(i).equals(ResourceStatus.Registered)) continue;
            boolean heuristicRaised = false;
            if (!(currResource instanceof OTSResourceImpl)) {
                ProxyChecker checkProxy = Configuration.getProxyChecker();
                isProxy = checkProxy.isProxy(currResource);
            }
            this.resourceStates.set(i, ResourceStatus.Completing);
            int rollbackRetriesLeft = commitRetries;
            boolean exceptionThrown = true;
            while (exceptionThrown) {
                try {
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "distributeRollback()", "Before invoking rollback on resource = " + currResource);
                    }
                    currResource.rollback();
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.logp(Level.FINER, "RegisteredResources", "distributeRollback()", "After invoking rollback on resource = " + currResource);
                    }
                    exceptionThrown = false;
                }
                catch (Throwable exc) {
                    if (exc instanceof TRANSACTION_ROLLEDBACK) {
                        exceptionThrown = false;
                    }
                    if (exc instanceof HeuristicRollback) {
                        heuristicException = true;
                        heuristicRaised = true;
                        exceptionThrown = false;
                        continue;
                    }
                    if (exc instanceof HeuristicCommit || exc instanceof HeuristicHazard || exc instanceof HeuristicMixed) {
                        heuristicException = true;
                        heuristicMixed = !(exc instanceof HeuristicHazard);
                        heuristicRaised = true;
                        exceptionThrown = false;
                        continue;
                    }
                    if (exc instanceof INV_OBJREF || exc instanceof OBJECT_NOT_EXIST) {
                        exceptionThrown = false;
                        continue;
                    }
                    if (!(exc instanceof TRANSIENT) && !(exc instanceof COMM_FAILURE)) {
                        _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "rollback"});
                        msg = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "rollback"});
                        exceptionThrown = false;
                        transactionCompleted = false;
                        continue;
                    }
                    if (rollbackRetriesLeft > 0 || infiniteRetry) {
                        if (!infiniteRetry) {
                            --rollbackRetriesLeft;
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Throwable e) {}
                        continue;
                    }
                    _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "rollback"});
                    msg = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "rollback"});
                    exceptionThrown = false;
                    transactionCompleted = false;
                }
            }
            if (heuristicRaised) {
                this.resourceStates.set(i, ResourceStatus.Heuristic);
                if (this.logRecord == null || currResource instanceof OTSResourceImpl) continue;
                if (this.heuristicLogSection == null) {
                    this.heuristicLogSection = this.logRecord.createSection(HEURISTIC_LOG_SECTION_NAME);
                }
                this.logRecord.addObject(this.heuristicLogSection, currResource);
                continue;
            }
            this.resourceStates.set(i, ResourceStatus.Completed);
            if (!isProxy) continue;
            currResource._release();
        }
        if (heuristicException) {
            this.distributeForget(commitRetries, infiniteRetry, heuristicMixed);
        }
        if (!transactionCompleted) {
            if (this.coord != null) {
                RecoveryManager.addToIncompleTx(this.coord, false);
            }
            if (msg != null) {
                throw new INTERNAL(msg);
            }
            throw new INTERNAL();
        }
    }

    private void distributeForget(int retries, boolean infinite, boolean heuristicMixed) throws HeuristicMixed, HeuristicHazard {
        boolean isProxy = false;
        if (this.logRecord != null) {
            this.logRecord.write(true);
        }
        for (int i = 0; i < this.nRes; ++i) {
            if ((ResourceStatus)this.resourceStates.get(i) != ResourceStatus.Heuristic) continue;
            Resource currResource = (Resource)this.resourceObjects.get(i);
            if (!(currResource instanceof OTSResourceImpl)) {
                ProxyChecker checkProxy = Configuration.getProxyChecker();
                isProxy = checkProxy.isProxy(currResource);
            }
            int retriesLeft = retries;
            boolean exceptionThrown = true;
            while (exceptionThrown) {
                try {
                    currResource.forget();
                    exceptionThrown = false;
                }
                catch (Throwable exc) {
                    if (exc instanceof INV_OBJREF || exc instanceof OBJECT_NOT_EXIST) {
                        exceptionThrown = false;
                        continue;
                    }
                    if (!(exc instanceof COMM_FAILURE) && !(exc instanceof TRANSIENT)) {
                        exceptionThrown = false;
                        continue;
                    }
                    if (retriesLeft > 0 || infinite) {
                        if (!infinite) {
                            --retriesLeft;
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Throwable e) {}
                        continue;
                    }
                    _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(retries), "forget"});
                    String msg = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(retries), "forget"});
                    throw new INTERNAL(msg);
                }
            }
            this.resourceStates.set(i, ResourceStatus.Completed);
            if (!isProxy) continue;
            currResource._release();
        }
        if (heuristicMixed) {
            HeuristicMixed exc = new HeuristicMixed();
            throw exc;
        }
        HeuristicHazard exc = new HeuristicHazard();
        throw exc;
    }

    void distributeSubcommit(Coordinator parent) throws TRANSACTION_ROLLEDBACK {
        boolean exceptionRaised = false;
        boolean isProxy = false;
        for (int i = 0; i < this.nRes; ++i) {
            SubtransactionAwareResource currResource;
            block5: {
                currResource = (SubtransactionAwareResource)this.resourceObjects.get(i);
                if (!(currResource instanceof OTSResourceImpl)) {
                    ProxyChecker checkProxy = Configuration.getProxyChecker();
                    isProxy = checkProxy.isProxy(currResource);
                }
                try {
                    currResource.commit_subtransaction(parent);
                }
                catch (Throwable exc) {
                    if (!(exc instanceof TRANSACTION_ROLLEDBACK)) break block5;
                    exceptionRaised = true;
                }
            }
            this.resourceStates.set(i, ResourceStatus.Completed);
            if (!isProxy) continue;
            currResource._release();
        }
        if (exceptionRaised) {
            throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
        }
    }

    void distributeSubrollback() {
        boolean isProxy = false;
        for (int i = 0; i < this.nRes; ++i) {
            SubtransactionAwareResource currResource = (SubtransactionAwareResource)this.resourceObjects.get(i);
            if (!(currResource instanceof OTSResourceImpl)) {
                ProxyChecker checkProxy = Configuration.getProxyChecker();
                isProxy = checkProxy.isProxy(currResource);
            }
            try {
                currResource.rollback_subtransaction();
            }
            catch (Throwable exc) {
                // empty catch block
            }
            this.resourceStates.set(i, ResourceStatus.Completed);
            if (!isProxy) continue;
            currResource._release();
        }
    }

    void commitOnePhase() throws HeuristicMixed, HeuristicHazard {
        boolean infiniteRetry = true;
        boolean heuristicRaisedSetStatus = false;
        boolean heuristicExceptionFlowForget = false;
        boolean isProxy = false;
        boolean heuristicMixed = false;
        boolean heuristicHazard = false;
        boolean rollback_occurred = false;
        boolean outstanding_resources = true;
        int commitRetries = Configuration.getRetries();
        if (commitRetries >= 0) {
            infiniteRetry = false;
        }
        if (this.nRes > 1) {
            _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{"commitOnePhase", ">1 Resource"});
            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{"commitOnePhase", ">1 Resource"});
            throw new INTERNAL(msg);
        }
        Resource currResource = (Resource)this.resourceObjects.get(0);
        if ((ResourceStatus)this.resourceStates.get(0) != ResourceStatus.Registered) {
            return;
        }
        if (!(currResource instanceof OTSResourceImpl)) {
            ProxyChecker checkProxy = Configuration.getProxyChecker();
            isProxy = checkProxy.isProxy(currResource);
        }
        this.resourceStates.set(0, ResourceStatus.Completing);
        int commitRetriesLeft = commitRetries;
        boolean exceptionThrownTryAgain = true;
        while (exceptionThrownTryAgain) {
            try {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.logp(Level.FINEST, "RegisteredResources", "commitOnePhase()", "Before invoking commit_one_phase() on resource:" + currResource);
                }
                currResource.commit_one_phase();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.logp(Level.FINEST, "RegisteredResources", "commitOnePhase()", "After invoking commit_one_phase() on resource:" + currResource);
                }
                this.resourceStates.set(0, ResourceStatus.Completed);
                exceptionThrownTryAgain = false;
            }
            catch (Throwable exc) {
                String msg;
                if (exc instanceof TRANSACTION_ROLLEDBACK) {
                    rollback_occurred = true;
                    this.resourceStates.set(0, ResourceStatus.Completed);
                    exceptionThrownTryAgain = false;
                    continue;
                }
                if (exc instanceof HeuristicHazard) {
                    XAException e = (XAException)exc.getCause();
                    if (e != null && e.errorCode >= 100 && e.errorCode <= 107) {
                        rollback_occurred = true;
                        this.resourceStates.set(0, ResourceStatus.Completed);
                        exceptionThrownTryAgain = false;
                        continue;
                    }
                    heuristicExceptionFlowForget = true;
                    heuristicRaisedSetStatus = true;
                    exceptionThrownTryAgain = false;
                    heuristicMixed = false;
                    continue;
                }
                if (exc instanceof INV_OBJREF || exc instanceof OBJECT_NOT_EXIST) {
                    this.resourceStates.set(0, ResourceStatus.Completed);
                    exceptionThrownTryAgain = false;
                    continue;
                }
                if (exc instanceof NotPrepared) {
                    _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "commit one phase"});
                    msg = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "commit one phase"});
                    throw new INTERNAL(msg);
                }
                if (!(exc instanceof TRANSIENT) && !(exc instanceof COMM_FAILURE)) {
                    _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "commit one phase"});
                    msg = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{exc.toString(), "commit one phase"});
                    throw new INTERNAL(msg);
                }
                if (commitRetriesLeft > 0 || infiniteRetry) {
                    if (!infiniteRetry) {
                        --commitRetriesLeft;
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Throwable e) {}
                    continue;
                }
                _logger.log(Level.SEVERE, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commitOnePhase"});
                msg = LogFormatter.getLocalizedMessage(_logger, "jts.retry_limit_exceeded", new java.lang.Object[]{new Integer(commitRetries), "commitOnePhase"});
                throw new INTERNAL(msg);
            }
        }
        if (heuristicRaisedSetStatus) {
            this.resourceStates.set(0, ResourceStatus.Heuristic);
            if (this.logRecord != null && !(currResource instanceof OTSResourceImpl)) {
                if (this.heuristicLogSection == null) {
                    this.heuristicLogSection = this.logRecord.createSection(HEURISTIC_LOG_SECTION_NAME);
                }
                this.logRecord.addObject(this.heuristicLogSection, currResource);
            }
        } else {
            this.resourceStates.set(0, ResourceStatus.Completed);
            if (isProxy) {
                currResource._release();
            }
        }
        if (heuristicExceptionFlowForget) {
            this.distributeForget(commitRetries, infiniteRetry, heuristicMixed);
        }
        if (rollback_occurred) {
            throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
        }
    }

    static {
        String lastXAResCommitProp = System.getProperty("com.sun.jts.lastagentcommit");
        if (lastXAResCommitProp != null && "true".equals(lastXAResCommitProp.toLowerCase())) {
            lastXAResCommit = true;
        }
        _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    }
}

