/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.VirtualServerInfo;
import com.sun.enterprise.deployment.util.WebServerInfo;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.model.Model;
import com.sun.xml.rpc.spi.model.Port;
import com.sun.xml.rpc.spi.model.Service;
import com.sun.xml.rpc.spi.runtime.ClientTransportFactory;
import com.sun.xml.rpc.spi.runtime.SOAPConstants;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import com.sun.xml.rpc.spi.runtime.StubBase;
import com.sun.xml.rpc.spi.runtime.Tie;
import com.sun.xml.rpc.spi.tools.Import;
import com.sun.xml.rpc.spi.tools.WSDLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class WsUtil {
    public static final String CLIENT_TRANSPORT_LOG_PROPERTY = "com.sun.enterprise.webservice.client.transport.log";
    public static final String ENDPOINT_ADDRESS_PARAM_NAME = "endpointAddressParam";
    public final String WSDL_IMPORT_NAMESPACE_PARAM_NAME = "wsdlImportNamespaceParam";
    public static final String WSDL_IMPORT_LOCATION_PARAM_NAME = "wsdlImportLocationParam";
    public final String SCHEMA_IMPORT_NAMESPACE_PARAM_NAME = "schemaImportNamespaceParam";
    public static final String SCHEMA_IMPORT_LOCATION_PARAM_NAME = "schemaImportLocationParam";
    private static final String ONE_WAY_OPERATION = "com.sun.xml.rpc.server.OneWayOperation";
    private static final String CLIENT_BAD_REQUEST = "com.sun.xml.rpc.server.http.ClientBadRequest";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static Logger deploymentLogger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private JaxRpcObjectFactory rpcFactory = JaxRpcObjectFactory.newInstance();
    private static Logger _logger = null;
    static /* synthetic */ Class class$javax$xml$rpc$Service;
    static /* synthetic */ Class class$java$rmi$Remote;

    public boolean handleGet(HttpServletRequest request, HttpServletResponse response, WebServiceEndpoint endpoint) throws IOException {
        MimeHeaders headers = this.getHeaders(request);
        if (this.hasSomeTextXmlContent(headers)) {
            String message = "Received HTTP GET containing text/xml  content for endpoint " + endpoint.getEndpointName() + " at " + endpoint.getEndpointAddressUri() + " . HTTP POST should be used instead.";
            this.writeInvalidMethodType(response, message);
            logger.info(message);
            return false;
        }
        URL wsdlUrl = null;
        String requestUriRaw = request.getRequestURI();
        String requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
        String queryString = request.getQueryString();
        WebService webService = endpoint.getWebService();
        if (queryString == null) {
            String wsdlPath = endpoint.getWsdlContentPath(requestUri);
            if (wsdlPath != null) {
                ModuleDescriptor module = webService.getBundleDescriptor().getModuleDescriptor();
                if (wsdlPath.equals(webService.getWsdlFileUri())) {
                    wsdlUrl = webService.getWsdlFileUrl();
                } else if (this.isWsdlContent(wsdlPath, webService.getBundleDescriptor())) {
                    URL finalWsdlUrl = webService.getWsdlFileUrl();
                    String finalWsdlPath = finalWsdlUrl.getPath();
                    String wsdlDirPath = finalWsdlPath.substring(0, finalWsdlPath.length() - webService.getWsdlFileUri().length());
                    File wsdlDir = new File(wsdlDirPath);
                    File wsdlFile = new File(wsdlDir, wsdlPath.replace('/', File.separatorChar));
                    try {
                        wsdlUrl = wsdlFile.toURL();
                    }
                    catch (MalformedURLException mue) {
                        logger.log(Level.INFO, "Failure serving WSDL for " + webService.getWebServiceName(), mue);
                    }
                }
            }
        } else if (queryString.equalsIgnoreCase("WSDL")) {
            wsdlUrl = webService.getWsdlFileUrl();
        }
        boolean success = false;
        if (wsdlUrl != null) {
            try {
                response.setContentType("text/xml");
                response.setStatus(200);
                if (wsdlUrl.equals(webService.getWsdlFileUrl())) {
                    try {
                        String moduleID = endpoint.getBundleDescriptor().getApplication().getRegistrationName();
                        WebServerInfo wsi = this.getWebServerInfo(moduleID, request);
                        URL url = webService.getWsdlFileUrl();
                        File originalWsdlFile = new File(url.getPath() + "__orig");
                        this.generateFinalWsdl(originalWsdlFile.toURL(), webService, wsi, (OutputStream)response.getOutputStream());
                    }
                    catch (Exception e) {
                        URLConnection urlCon = wsdlUrl.openConnection();
                        urlCon.setUseCaches(false);
                        InputStream is = urlCon.getInputStream();
                        Archivist.copy(is, (OutputStream)response.getOutputStream());
                    }
                } else {
                    URLConnection urlCon = wsdlUrl.openConnection();
                    urlCon.setUseCaches(false);
                    InputStream is = urlCon.getInputStream();
                    Archivist.copy(is, (OutputStream)response.getOutputStream());
                }
                success = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Serving up final wsdl " + wsdlUrl + " for " + request.getRequestURL() + (queryString != null ? "?" + queryString : ""));
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Failure serving WSDL for web service " + webService.getWebServiceName(), e);
            }
        }
        if (!success) {
            String message = "Invalid wsdl request " + request.getRequestURL() + (queryString != null ? "?" + queryString : "") + " for web service " + webService.getWebServiceName();
            logger.info(message);
            this.writeInvalidMethodType(response, message);
        }
        return success;
    }

    public boolean isWsdlContent(String uri, BundleDescriptor bundle) {
        String wsdlDir = this.getWsdlDir(bundle);
        return uri != null && uri.startsWith(wsdlDir);
    }

    public String getWsdlDir(BundleDescriptor bundle) {
        boolean isWar = bundle instanceof WebBundleDescriptor;
        return isWar ? "WEB-INF/wsdl" : "META-INF/wsdl";
    }

    public void setClientTransportLog(ServiceReferenceDescriptor serviceRef, Stub stub, String transportLogUrlStr) {
        try {
            final String logUrlString = transportLogUrlStr;
            OutputStream os = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    URL transportLogUrl = new URL(logUrlString);
                    File transportFile = new File(transportLogUrl.getFile());
                    return new FileOutputStream(transportFile, true);
                }
            });
            ClientTransportFactory transportFactory = this.rpcFactory.createClientTransportFactory(0, os);
            if (stub instanceof StubBase) {
                ((StubBase)stub)._setTransportFactory(transportFactory);
                logger.info("Logging client transport for service-ref " + serviceRef.getName() + " to file " + transportLogUrlStr);
            }
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.INFO, "", pae.getCause());
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "", t);
        }
    }

    private void parseRelativeImports(URL wsdlFileUrl, WebService webService, Collection wsdlRelativeImports, Collection schemaRelativeImports) throws Exception {
        WSDLUtil util = this.rpcFactory.createWSDLUtil();
        util.getRelativeImports(wsdlFileUrl, wsdlRelativeImports, schemaRelativeImports);
    }

    public void generateFinalWsdl(URL wsdlFileUrl, WebService webService, WebServerInfo wsi, File finalWsdlFile) throws Exception {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(finalWsdlFile));
        this.generateFinalWsdl(wsdlFileUrl, webService, wsi, outputStream);
    }

    public void generateFinalWsdl(URL wsdlFileUrl, WebService webService, WebServerInfo wsi, OutputStream outputStream) throws Exception {
        Switch theSwitch = Switch.getSwitch();
        String webServiceName = webService.getWebServiceName();
        HashSet wsdlRelativeImports = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        if (webService.hasUrlPublishing()) {
            this.parseRelativeImports(wsdlFileUrl, webService, wsdlRelativeImports, schemaRelativeImports);
        }
        Collection endpoints = webService.getEndpoints();
        ArrayList endpointsCopy = new ArrayList();
        endpointsCopy.addAll(endpoints);
        BundleDescriptor bundle = webService.getBundleDescriptor();
        WebServicesDescriptor wsd = bundle.getWebServices();
        Collection webServices = wsd.getWebServices();
        if (webServices.size() > 1) {
            Iterator wsIter = webServices.iterator();
            while (wsIter.hasNext()) {
                WebService aWS = (WebService)wsIter.next();
                if (webService.getWebServiceName().equals(aWS.getWebServiceName()) || !webService.getWsdlFileUri().equals(aWS.getWsdlFileUri())) continue;
                endpointsCopy.addAll(aWS.getEndpoints());
            }
        }
        BufferedInputStream wsdlInputStream = new BufferedInputStream(wsdlFileUrl.openStream());
        StreamSource XsltWsdlDocument = new StreamSource(wsdlInputStream);
        Templates templates = this.createTemplatesFor(endpointsCopy, wsdlRelativeImports, schemaRelativeImports);
        Transformer transformer = templates.newTransformer();
        WebServiceEndpoint endpointForImport = webService.pickEndpointForRelativeImports();
        URL root = wsi.getWebServerRootURL(endpointForImport.isSecure());
        URL finalWsdlUrl = endpointForImport.composeFinalWsdlUrl(root);
        int wsdlImportNum = 0;
        Iterator iter = wsdlRelativeImports.iterator();
        while (iter.hasNext()) {
            Import next = (Import)iter.next();
            transformer.setParameter("wsdlImportNamespaceParam" + wsdlImportNum, next.getNamespace());
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(WSDL_IMPORT_LOCATION_PARAM_NAME + wsdlImportNum, relativeUrl);
            ++wsdlImportNum;
        }
        int schemaImportNum = 0;
        Iterator iter2 = schemaRelativeImports.iterator();
        while (iter2.hasNext()) {
            Import next = (Import)iter2.next();
            transformer.setParameter("schemaImportNamespaceParam" + schemaImportNum, next.getNamespace());
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(SCHEMA_IMPORT_LOCATION_PARAM_NAME + schemaImportNum, relativeUrl);
            ++schemaImportNum;
        }
        int endpointNum = 0;
        Iterator iter3 = endpointsCopy.iterator();
        while (iter3.hasNext()) {
            WebServiceEndpoint next = (WebServiceEndpoint)iter3.next();
            if (!next.hasEndpointAddressUri()) {
                throw new Exception("Endpoint address uri not set for " + webServiceName + " endpoint " + next.getEndpointName());
            }
            URL rootURL = wsi.getWebServerRootURL(next.isSecure());
            URL actualAddress = next.composeEndpointAddress(rootURL);
            transformer.setParameter(ENDPOINT_ADDRESS_PARAM_NAME + endpointNum, actualAddress.toExternalForm());
            String endpointType = next.implementedByEjbComponent() ? "EJB" : "Servlet";
            deploymentLogger.log(Level.INFO, "enterprise.deployment.endpoint.registration", new Object[]{endpointType, next.getEndpointName(), actualAddress});
            ++endpointNum;
        }
        transformer.transform(XsltWsdlDocument, new StreamResult(outputStream));
        ((InputStream)wsdlInputStream).close();
        outputStream.close();
    }

    public HandlerInfo createHandlerInfo(WebServiceHandler handler, ClassLoader loader) throws Exception {
        QName[] headers = new QName[handler.getSoapHeaders().size()];
        int i = 0;
        Iterator iter = handler.getSoapHeaders().iterator();
        while (iter.hasNext()) {
            headers[i] = (QName)iter.next();
            ++i;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        Iterator iter2 = handler.getInitParams().iterator();
        while (iter2.hasNext()) {
            NameValuePairDescriptor next = (NameValuePairDescriptor)iter2.next();
            properties.put(next.getName(), next.getValue());
        }
        Class<?> handlerClass = loader.loadClass(handler.getHandlerClass());
        return new HandlerInfo(handlerClass, properties, headers);
    }

    public URL privilegedGetServiceRefWsdl(ServiceReferenceDescriptor desc) throws Exception {
        URL wsdlFileURL;
        try {
            final ServiceReferenceDescriptor serviceRef = desc;
            wsdlFileURL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return serviceRef.hasWsdlOverride() ? serviceRef.getWsdlOverride() : serviceRef.getWsdlFileUrl();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.WARNING, "", pae);
            Exception e = new Exception();
            e.initCause(pae.getCause());
            throw e;
        }
        return wsdlFileURL;
    }

    public javax.xml.rpc.Service createConfiguredService(ServiceReferenceDescriptor desc) throws Exception {
        ServiceReferenceDescriptor serviceRef = desc;
        javax.xml.rpc.Service service = null;
        try {
            final URL wsdlFileURL = this.privilegedGetServiceRefWsdl(serviceRef);
            final QName serviceName = serviceRef.getServiceName();
            final ServiceFactory serviceFactory = ServiceFactory.newInstance();
            service = (javax.xml.rpc.Service)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return serviceFactory.createService(wsdlFileURL, serviceName);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.WARNING, "", pae);
            Exception e = new Exception();
            e.initCause(pae.getCause());
            throw e;
        }
        return service;
    }

    public void configureHandlerChain(ServiceReferenceDescriptor serviceRef, javax.xml.rpc.Service service, Iterator ports, ClassLoader loader) throws Exception {
        if (!serviceRef.hasHandlers()) {
            return;
        }
        HandlerRegistry registry = service.getHandlerRegistry();
        while (ports.hasNext()) {
            QName nextPort = (QName)ports.next();
            List handlerChain = registry.getHandlerChain(nextPort);
            HashSet soapRoles = new HashSet();
            Iterator iter = serviceRef.getHandlerChain().iterator();
            while (iter.hasNext()) {
                WebServiceHandler nextHandler = (WebServiceHandler)iter.next();
                Collection portNames = nextHandler.getPortNames();
                if (!portNames.isEmpty() && !portNames.contains(nextPort.getLocalPart())) continue;
                soapRoles.addAll(nextHandler.getSoapRoles());
                HandlerInfo handlerInfo = this.createHandlerInfo(nextHandler, loader);
                handlerChain.add(handlerInfo);
            }
        }
    }

    private Templates createTemplatesFor(Collection endpoints, Collection wsdlRelativeImports, Collection schemaRelativeImports) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        writer.write("<xsl:transform version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\">\n");
        int wsdlImportNum = 0;
        Iterator iter = wsdlRelativeImports.iterator();
        while (iter.hasNext()) {
            Import next = (Import)iter.next();
            String importNamespaceParam = "wsdlImportNamespaceParam" + wsdlImportNum;
            String importLocationParam = WSDL_IMPORT_LOCATION_PARAM_NAME + wsdlImportNum;
            writer.write("<xsl:param name=\"" + importNamespaceParam + "\"/>\n");
            writer.write("<xsl:param name=\"" + importLocationParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:import[@location='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<wsdl:import>");
            writer.write("<xsl:attribute name=\"namespace\"><xsl:value-of select=\"$" + importNamespaceParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("<xsl:attribute name=\"location\"><xsl:value-of select=\"$" + importLocationParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</wsdl:import></xsl:template>");
            ++wsdlImportNum;
        }
        int schemaImportNum = 0;
        Iterator iter2 = schemaRelativeImports.iterator();
        while (iter2.hasNext()) {
            Import next = (Import)iter2.next();
            String importNamespaceParam = "schemaImportNamespaceParam" + schemaImportNum;
            String importLocationParam = SCHEMA_IMPORT_LOCATION_PARAM_NAME + schemaImportNum;
            writer.write("<xsl:param name=\"" + importNamespaceParam + "\"/>\n");
            writer.write("<xsl:param name=\"" + importLocationParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:types/xsd:schema/xsd:import[@schemaLocation='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<xsd:import>");
            writer.write("<xsl:attribute name=\"namespace\"><xsl:value-of select=\"$" + importNamespaceParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("<xsl:attribute name=\"schemaLocation\"><xsl:value-of select=\"$" + importLocationParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</xsd:import></xsl:template>");
            ++schemaImportNum;
        }
        int endpointNum = 0;
        Iterator iter3 = endpoints.iterator();
        while (iter3.hasNext()) {
            WebServiceEndpoint endpoint = (WebServiceEndpoint)iter3.next();
            if (!endpoint.hasWsdlPort()) {
                throw new Exception("No WSDL port specified for endpoint " + endpoint.getEndpointName());
            }
            if (!endpoint.hasServiceName()) {
                throw new Exception("Runtime settings error.  Cannot find service name for endpoint " + endpoint.getEndpointName());
            }
            String actualAddressParam = ENDPOINT_ADDRESS_PARAM_NAME + endpointNum;
            writer.write("<xsl:param name=\"" + actualAddressParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions[@targetNamespace='");
            writer.write(endpoint.getServiceName().getNamespaceURI());
            writer.write("']/wsdl:service[@name='");
            writer.write(endpoint.getServiceName().getLocalPart());
            writer.write("']/wsdl:port[@name='");
            writer.write(endpoint.getWsdlPort().getLocalPart());
            writer.write("']/soap:address\" mode=\"copy\">");
            writer.write("<soap:address><xsl:attribute name=\"location\"><xsl:value-of select=\"$" + actualAddressParam + "\"/>");
            writer.write("</xsl:attribute></soap:address></xsl:template>");
            ++endpointNum;
        }
        writer.write("<xsl:template match=\"@*|node()\" mode=\"copy\"><xsl:copy><xsl:apply-templates select=\"@*\" mode=\"copy\"/><xsl:apply-templates mode=\"copy\"/></xsl:copy></xsl:template>\n");
        writer.write("</xsl:transform>\n");
        writer.close();
        byte[] stylesheet = bos.toByteArray();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(new String(stylesheet));
        }
        StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(stylesheet));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(stylesheetSource);
        return templates;
    }

    public Collection getSEIsFromGeneratedService(Class generatedServiceInterface) throws Exception {
        HashSet<String> seis = new HashSet<String>();
        Method[] declaredMethods = generatedServiceInterface.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method next = declaredMethods[i];
            Class<?> returnType = next.getReturnType();
            if (!next.getName().startsWith("get") || next.getDeclaringClass() == (class$javax$xml$rpc$Service == null ? WsUtil.class$("javax.xml.rpc.Service") : class$javax$xml$rpc$Service) || !(class$java$rmi$Remote == null ? WsUtil.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(returnType)) continue;
            seis.add(returnType.getName());
        }
        return seis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File publishFinalWsdl(URL clientPublishUrl, String finalWsdlUri, byte[] finalWsdlBytes) throws Exception {
        File finalWsdlFile = null;
        FileOutputStream fos = null;
        try {
            boolean madeDirs;
            finalWsdlFile = new File(clientPublishUrl.getFile(), finalWsdlUri.replace('/', File.separatorChar));
            File parent = finalWsdlFile.getParentFile();
            if (!parent.exists() && !(madeDirs = parent.mkdirs())) {
                throw new IOException("Error creating " + parent);
            }
            fos = new FileOutputStream(finalWsdlFile);
            fos.write(finalWsdlBytes, 0, finalWsdlBytes.length);
            Object var9_8 = null;
            if (fos == null) return finalWsdlFile;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioe) {
                logger.log(Level.INFO, "", ioe);
            }
            throw throwable;
        }
        try {
            fos.close();
            return finalWsdlFile;
        }
        catch (IOException ioe) {
            logger.log(Level.INFO, "", ioe);
        }
        return finalWsdlFile;
    }

    public Port getPortFromModel(Model model, QName portName) {
        Iterator serviceIter = model.getServices();
        while (serviceIter.hasNext()) {
            Service next = (Service)serviceIter.next();
            Iterator portIter = next.getPorts();
            while (portIter.hasNext()) {
                Port nextPort = (Port)portIter.next();
                if (!this.portsEqual(nextPort, portName)) continue;
                return nextPort;
            }
        }
        return null;
    }

    public Service getServiceForPort(Model model, QName thePortName) {
        Iterator serviceIter = model.getServices();
        while (serviceIter.hasNext()) {
            Service nextService = (Service)serviceIter.next();
            Iterator portIter = nextService.getPorts();
            while (portIter.hasNext()) {
                Port nextPort = (Port)portIter.next();
                if (!this.portsEqual(nextPort, thePortName)) continue;
                return nextService;
            }
        }
        return null;
    }

    public boolean portsEqual(Port port, QName candidatePortName) {
        boolean equal = false;
        QName portPropertyName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
        equal = portPropertyName != null ? candidatePortName.equals(portPropertyName) : candidatePortName.equals(port.getName());
        return equal;
    }

    public Collection getAllPorts(Model model) {
        HashSet ports = new HashSet();
        Iterator serviceIter = model.getServices();
        while (serviceIter.hasNext()) {
            Service next = (Service)serviceIter.next();
            ports.addAll(next.getPortsList());
        }
        return ports;
    }

    public Method getInvMethod(Tie webServiceTie, MessageContext context) throws Exception {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)context;
        SOAPMessage message = soapMsgContext.getMessage();
        StreamingHandler streamingHandler = (StreamingHandler)webServiceTie;
        int opcode = streamingHandler.getOpcodeForRequestMessage(message);
        return streamingHandler.getMethodForOpcode(opcode);
    }

    public void throwSOAPFaultException(String faultString, MessageContext msgContext) throws SOAPFaultException {
        SOAPFaultException sfe = null;
        try {
            SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
            SOAPPart sp = soapMessage.getSOAPPart();
            SOAPEnvelope se = sp.getEnvelope();
            SOAPBody sb = se.getBody();
            Iterator iter = sb.getChildElements();
            if (iter.hasNext()) {
                SOAPBodyElement requestBody = (SOAPBodyElement)iter.next();
                requestBody.detachNode();
            }
            SOAPFault soapFault = sb.addFault();
            se.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            String faultActor = "http://schemas.xmlsoap.org/soap/actor/next";
            QName faultCode = SOAPConstants.FAULT_CODE_SERVER;
            soapFault.setFaultCode("env:" + faultCode.getLocalPart());
            soapFault.setFaultString(faultString);
            soapFault.setFaultActor(faultActor);
            sfe = new SOAPFaultException(faultCode, faultActor, faultString, null);
        }
        catch (SOAPException se) {
            logger.log(Level.FINE, "", se);
        }
        if (sfe != null) {
            throw sfe;
        }
    }

    void writeReply(HttpServletResponse response, com.sun.xml.rpc.spi.runtime.SOAPMessageContext messageContext) throws IOException, SOAPException {
        if (this.isMessageContextPropertySet(messageContext, ONE_WAY_OPERATION)) {
            return;
        }
        SOAPMessage reply = messageContext.getMessage();
        boolean statusCode = false;
        if (messageContext.isFailure()) {
            if (this.isMessageContextPropertySet(messageContext, CLIENT_BAD_REQUEST)) {
                response.setStatus(400);
                this.setContentTypeAndFlush(response);
                return;
            }
            response.setStatus(500);
        } else {
            response.setStatus(200);
        }
        ServletOutputStream os = response.getOutputStream();
        String[] headers = reply.getMimeHeaders().getHeader("Content-Type");
        if (headers != null && headers.length > 0) {
            response.setContentType(headers[0]);
        } else {
            response.setContentType("text/xml");
        }
        WsUtil.putHeaders(reply.getMimeHeaders(), response);
        reply.writeTo((OutputStream)os);
        os.flush();
    }

    private static void putHeaders(MimeHeaders headers, HttpServletResponse response) {
        headers.removeHeader("Content-Type");
        headers.removeHeader("Content-Length");
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            response.setHeader(header.getName(), header.getValue());
        }
    }

    void writeInvalidContentType(HttpServletResponse response) throws SOAPException, IOException {
        response.setStatus(415);
        this.setContentTypeAndFlush(response);
    }

    void writeInvalidMethodType(HttpServletResponse response, String message) throws IOException {
        response.setStatus(405);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println("Invalid Method Type");
        out.println("</title></head>");
        out.println("<body>");
        out.println(message);
        out.println("</body>");
        out.println("</html>");
    }

    private void writeNotFoundErrorPage(HttpServletResponse response, String message) throws IOException {
        response.setStatus(404);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println("J2EE Web Services");
        out.println("</title></head>");
        out.println("<body>");
        out.println("<h1>404 Not Found: " + message + "</h1>");
        out.println("</body>");
        out.println("</html>");
    }

    private void setContentTypeAndFlush(HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        response.flushBuffer();
        response.getWriter().close();
    }

    boolean hasSomeTextXmlContent(MimeHeaders headers) {
        return this.hasTextXmlContentType(headers) && this.getContentLength(headers) > 0;
    }

    private int getContentLength(MimeHeaders headers) {
        String[] contentLength = headers.getHeader("Content-Length");
        int length = 0;
        if (contentLength != null && contentLength.length > 0) {
            length = new Integer(contentLength[0]);
        }
        return length;
    }

    boolean hasTextXmlContentType(MimeHeaders headers) {
        String[] contentTypes = headers.getHeader("Content-Type");
        return contentTypes != null && contentTypes.length >= 1 && contentTypes[0].indexOf("text/xml") != -1;
    }

    boolean isMessageContextPropertySet(com.sun.xml.rpc.spi.runtime.SOAPMessageContext messageContext, String property) {
        Object prop = messageContext.getProperty(property);
        return prop != null && prop instanceof String && ((String)prop).equalsIgnoreCase("true");
    }

    MimeHeaders getHeaders(HttpServletRequest request) {
        Enumeration enumeration = request.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (enumeration.hasMoreElements()) {
            String headerName = (String)enumeration.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.addHeader(headerName, headerValue);
        }
        return headers;
    }

    public WebServerInfo getWebServerInfo(DeploymentRequest request) throws ConfigException {
        String serverTarget = (String)request.getOptionalArguments().get("wsdlTargetHint");
        if (serverTarget == null) {
            return this.getWebServerInfoForDAS(request);
        }
        ConfigContext cc = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        if (cc == null) {
            return this.getWebServerInfoForDAS(request);
        }
        Config config = ServerHelper.getConfigForServer(cc, serverTarget);
        JMXConnectorConfig info = ServerHelper.getJMXConnectorInfo(cc, serverTarget);
        if (config == null || info == null) {
            return this.getWebServerInfoForDAS(request);
        }
        String host = info.getHost();
        return this.getWebServerInfo(cc, config, null, serverTarget, host);
    }

    private WebServerInfo getWebServerInfoForDAS(DeploymentRequest request) {
        WebServerInfo wsi = new WebServerInfo();
        wsi.setHttpVS(new VirtualServerInfo("http", request.getHttpHostName(), request.getHttpPort()));
        wsi.setHttpsVS(new VirtualServerInfo("https", request.getHttpsHostName(), request.getHttpsPort()));
        return wsi;
    }

    public WebServerInfo getWebServerInfo(String moduleID, HttpServletRequest request) throws ConfigException {
        ConfigContext cc = ApplicationServer.getServerContext().getConfigContext();
        Server server = ServerBeansFactory.getServerBean(cc);
        Config config = ServerBeansFactory.getConfigBean(cc);
        ApplicationRef ref = server.getApplicationRefByRef(moduleID);
        return this.getWebServerInfo(cc, config, ref.getVirtualServers(), null, null);
    }

    private WebServerInfo getWebServerInfo(ConfigContext cc, Config config, String virtualServers, String targetName, String targetHostName) throws ConfigException {
        HttpService httpService = config.getHttpService();
        VirtualServer[] vServers = null;
        ArrayList<HttpListener> httpListeners = new ArrayList<HttpListener>();
        if (virtualServers == null) {
            vServers = httpService.getVirtualServer();
            if (vServers != null) {
                for (int i = 0; i < vServers.length; ++i) {
                    String[] httpListenerIDs;
                    String httpListenersString;
                    VirtualServer vs = vServers[i];
                    if (vs.getId().equals("__asadmin") || (httpListenersString = vs.getHttpListeners()) == null || (httpListenerIDs = httpListenersString.split(",")) == null) continue;
                    for (int j = 0; j < httpListenerIDs.length; ++j) {
                        httpListeners.add(httpService.getHttpListenerById(httpListenerIDs[j]));
                    }
                }
            }
        } else {
            String[] virtualServerNames = virtualServers.split(",");
            if (virtualServerNames != null) {
                for (int i = 0; i < virtualServerNames.length; ++i) {
                    String[] httpListenerIDs;
                    VirtualServer vs = httpService.getVirtualServerById(virtualServerNames[i]);
                    String httpListenersString = vs.getHttpListeners();
                    if (httpListenersString == null || (httpListenerIDs = httpListenersString.split(",")) == null) continue;
                    for (int j = 0; j < httpListenerIDs.length; ++j) {
                        httpListeners.add(httpService.getHttpListenerById(httpListenerIDs[i]));
                    }
                }
            }
        }
        WebServerInfo wsi = new WebServerInfo();
        for (int i = 0; i < httpListeners.size(); ++i) {
            HttpListener hl = (HttpListener)httpListeners.get(i);
            if (!hl.isEnabled()) continue;
            if (targetHostName == null && ((targetHostName = hl.getServerName()) == null || targetHostName.length() == 0)) {
                targetHostName = this.getDefaultHostName();
            }
            try {
                targetHostName = InetAddress.getByName(targetHostName).getCanonicalHostName();
            }
            catch (UnknownHostException unex) {
                throw new ConfigException(unex.getMessage(), unex);
            }
            String redirectPortNb = hl.getRedirectPort();
            String portNb = redirectPortNb != null ? redirectPortNb : hl.getPort();
            if (targetName == null) {
                targetName = ApplicationServer.getServerContext().getInstanceName();
            }
            PropertyResolver pr = new PropertyResolver(cc, targetName);
            String resolvedPort = pr.resolve(portNb);
            int port = Integer.parseInt(resolvedPort);
            if (hl.isSecurityEnabled()) {
                wsi.setHttpsVS(new VirtualServerInfo("https", targetHostName, port));
            } else {
                wsi.setHttpVS(new VirtualServerInfo("http", targetHostName, port));
            }
            if (wsi.getHttpVS() != null && wsi.getHttpsVS() != null) break;
        }
        return wsi;
    }

    private String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            _logger.log(Level.FINEST, "mbean.get_local_host_error", uhe);
            _logger.log(Level.INFO, "mbean.use_default_host");
        }
        return defaultHostName;
    }

    public static Logger getDefaultLogger() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
        }
        return _logger;
    }
}

