/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class WebServiceEjbEndpointRegistry {
    private static WebServiceEjbEndpointRegistry registry = null;
    private Hashtable webServiceEjbEndpoints = new Hashtable();
    private Set ejbContextRoots = new HashSet();

    private WebServiceEjbEndpointRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServiceEjbEndpointRegistry getRegistry() {
        if (registry == null) {
            Class clazz = WebServiceEjbEndpointRegistry.class;
            synchronized (clazz) {
                if (registry == null) {
                    registry = new WebServiceEjbEndpointRegistry();
                }
            }
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEjbWebServiceEndpoint(EjbRuntimeEndpointInfo endpoint) {
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            String uriRaw = endpoint.getEndpointAddressUri();
            String uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
            this.webServiceEjbEndpoints.put(uri, endpoint);
            this.regenerateEjbContextRoots();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEjbWebServiceEndpoint(String endpointAddressUri) {
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            String uriRaw = endpointAddressUri;
            String uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
            this.webServiceEjbEndpoints.remove(uri);
            this.regenerateEjbContextRoots();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EjbRuntimeEndpointInfo getEjbWebServiceEndpoint(String uriRaw, String method, String query) {
        EjbRuntimeEndpointInfo endpoint = null;
        if (uriRaw == null || uriRaw.length() == 0) {
            return null;
        }
        String uri = uriRaw.charAt(0) == '/' ? uriRaw.substring(1) : uriRaw;
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            if (method.equals("GET")) {
                String contextRoot = this.getContextRootForUri(uri);
                if (this.ejbContextRoots.contains(contextRoot)) {
                    Collection values = this.webServiceEjbEndpoints.values();
                    Iterator iter = values.iterator();
                    while (iter.hasNext()) {
                        EjbRuntimeEndpointInfo next = (EjbRuntimeEndpointInfo)iter.next();
                        if (!next.getEndpoint().matchesEjbPublishRequest(uri, query)) continue;
                        endpoint = next;
                        break;
                    }
                }
            } else {
                endpoint = (EjbRuntimeEndpointInfo)this.webServiceEjbEndpoints.get(uri);
            }
        }
        return endpoint;
    }

    public Collection getEjbWebServiceEndpoints() {
        return this.webServiceEjbEndpoints.entrySet();
    }

    private String getContextRootForUri(String uri) {
        StringTokenizer tokenizer = new StringTokenizer(uri, "/");
        if (tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regenerateEjbContextRoots() {
        Hashtable hashtable = this.webServiceEjbEndpoints;
        synchronized (hashtable) {
            HashSet<String> contextRoots = new HashSet<String>();
            Iterator iter = this.webServiceEjbEndpoints.keySet().iterator();
            while (iter.hasNext()) {
                String uri = (String)iter.next();
                String contextRoot = this.getContextRootForUri(uri);
                if (contextRoot == null || contextRoot.equals("")) continue;
                contextRoots.add(contextRoot);
            }
            this.ejbContextRoots = contextRoots;
        }
    }
}

