/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ServerAuthConfig;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.enterprise.security.wss.WebServiceSecurity;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.runtime.Implementor;
import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPMessage;

public class ServletSystemHandlerDelegate
implements SystemHandlerDelegate {
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static final String IMPLEMENTOR = "com.sun.xml.rpc.server.http.Implementor";
    private static final String SERVER_AUTH_CONTEXT = "com.sun.enterprise.security.jauth.ServerAuthContext";
    ServerAuthConfig config_;

    public ServletSystemHandlerDelegate(ServerAuthConfig config) {
        this.config_ = config;
    }

    public boolean processRequest(SOAPMessageContext messageContext) {
        SOAPMessage request;
        Implementor implementor;
        StreamingHandler handler;
        ServerAuthContext sAC;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Container-Auth: ServletSystemHandlerDelegate: processRequest");
        }
        if ((sAC = this.config_.getAuthContext(handler = (StreamingHandler)(implementor = (Implementor)messageContext.getProperty(IMPLEMENTOR)).getTie(), request = messageContext.getMessage())) == null) {
            return true;
        }
        boolean rvalue = false;
        try {
            rvalue = WebServiceSecurity.validateRequest((javax.xml.rpc.handler.soap.SOAPMessageContext)messageContext, sAC);
        }
        catch (AuthException ae) {
            _logger.log(Level.SEVERE, "Container-auth: wss: Error validating request  ", ae);
            throw new RuntimeException(ae);
        }
        if (rvalue) {
            messageContext.setProperty(SERVER_AUTH_CONTEXT, (Object)sAC);
        }
        return rvalue;
    }

    public void processResponse(SOAPMessageContext messageContext) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Container-Auth: ServletSystemHandlerDelegate: processResponse");
        }
        Implementor implementor = (Implementor)messageContext.getProperty(IMPLEMENTOR);
        StreamingHandler handler = (StreamingHandler)implementor.getTie();
        SOAPMessage message = messageContext.getMessage();
        ServerAuthContext sAC = (ServerAuthContext)messageContext.getProperty(SERVER_AUTH_CONTEXT);
        if (sAC == null) {
            return;
        }
        try {
            WebServiceSecurity.secureResponse((javax.xml.rpc.handler.soap.SOAPMessageContext)messageContext, sAC);
        }
        catch (AuthException ae) {
            _logger.log(Level.SEVERE, "Container-auth: wss: Error securing response  ", ae);
            throw new RuntimeException(ae);
        }
    }
}

