/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.jauth.callback.SecretKeyCallback;
import com.sun.enterprise.webservice.Processor;
import com.sun.logging.LogDomains;
import java.security.Key;
import java.security.KeyStore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;

public class SecretKeyProcessor
implements Processor {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    SecretKeyCallback skc = null;
    KeyStore ks = null;

    SecretKeyProcessor(Callback callback) {
        this.skc = (SecretKeyCallback)callback;
        this.ks = SecurityUtil.getSecuritySupport().getKeyStores()[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        String alias;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "container-auth: wss : In SecretKeyCallback Processor");
        }
        if (this.ks == null) {
            this.skc.setKey(null);
        }
        if ((alias = ((SecretKeyCallback.AliasRequest)this.skc.getRequest()).getAlias()) != null) {
            String pass = SSLUtils.getKeyStorePass();
            try {
                Key key = this.ks.getKey(alias, pass.toCharArray());
                if (key instanceof SecretKey) {
                    this.skc.setKey((SecretKey)key);
                }
                this.skc.setKey(null);
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "container-auth: wss : In SecretKeyCallback Processor:  Error reading key ! for alias " + alias, e);
                }
                this.skc.setKey(null);
            }
            finally {
                pass = null;
            }
        } else {
            this.skc.setKey(null);
            _logger.log(Level.WARNING, "container-auth: wss : No support to read Principals in SecretKeyCallback");
        }
    }
}

