/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.jauth.callback.PrivateKeyCallback;
import com.sun.enterprise.webservice.Processor;
import com.sun.logging.LogDomains;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerValue;

public class PrivateKeyProcessor
implements Processor {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static String SUBJECT_KEY_IDENTIFIER_OID = "2.5.29.14";
    PrivateKeyCallback pkc;
    KeyStore[] kstores;

    PrivateKeyProcessor(Callback callback) {
        this.pkc = (PrivateKeyCallback)callback;
        this.kstores = SecurityUtil.getSecuritySupport().getKeyStores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "container-auth: wss : In PrivateKeyCallback Processor");
        }
        if (this.kstores == null || this.kstores.length == 0) {
            this.pkc.setKey(null, null);
            return;
        }
        String[] passwords = SecurityUtil.getSecuritySupport().getKeyStorePasswords();
        PrivateKeyCallback.Request req = this.pkc.getRequest();
        if (req == null) {
            this.setDefaultKey(this.pkc, passwords);
            passwords = null;
            return;
        }
        PrivateKey privKey = null;
        Certificate[] certs = null;
        try {
            if (req instanceof PrivateKeyCallback.AliasRequest) {
                PrivateKeyCallback.AliasRequest aReq = (PrivateKeyCallback.AliasRequest)req;
                String alias = aReq.getAlias();
                SSLUtils.PrivateKeyEntry privKeyEntry = null;
                if (alias == null) {
                    this.setDefaultKey(this.pkc, passwords);
                    passwords = null;
                    this.pkc.setKey(privKey, certs);
                    passwords = null;
                    return;
                }
                privKeyEntry = SSLUtils.getPrivateKeyEntryFromTokenAlias(alias);
                if (privKeyEntry != null) {
                    privKey = privKeyEntry.getPrivateKey();
                    certs = privKeyEntry.getCertificateChain();
                }
            } else if (req instanceof PrivateKeyCallback.IssuerSerialNumRequest) {
                PrivateKeyCallback.IssuerSerialNumRequest isReq = (PrivateKeyCallback.IssuerSerialNumRequest)req;
                X500Principal issuer = isReq.getIssuer();
                BigInteger serialNum = isReq.getSerialNum();
                if (issuer != null && serialNum != null) {
                    boolean found = false;
                    for (int i = 0; i < this.kstores.length && !found; ++i) {
                        Enumeration<String> aliases = this.kstores[i].aliases();
                        while (aliases.hasMoreElements() && !found) {
                            Certificate[] certificates;
                            X509Certificate eeCert;
                            String nextAlias = aliases.nextElement();
                            Key key = this.kstores[i].getKey(nextAlias, passwords[i].toCharArray());
                            if (key == null || !(key instanceof PrivateKey) || !(eeCert = (X509Certificate)(certificates = this.kstores[i].getCertificateChain(nextAlias))[0]).getIssuerX500Principal().equals(issuer) || !eeCert.getSerialNumber().equals(serialNum)) continue;
                            privKey = (PrivateKey)key;
                            certs = certificates;
                            found = true;
                        }
                    }
                }
            } else if (req instanceof PrivateKeyCallback.SubjectKeyIDRequest) {
                PrivateKeyCallback.SubjectKeyIDRequest skReq = (PrivateKeyCallback.SubjectKeyIDRequest)req;
                byte[] subjectKeyID = skReq.getSubjectKeyID();
                if (subjectKeyID != null) {
                    boolean found = false;
                    DerValue derValue1 = new DerValue(4, subjectKeyID);
                    DerValue derValue2 = new DerValue(4, derValue1.toByteArray());
                    byte[] derSubjectKeyID = derValue2.toByteArray();
                    for (int i = 0; i < this.kstores.length && !found; ++i) {
                        Enumeration<String> aliases = this.kstores[i].aliases();
                        while (aliases.hasMoreElements() && !found) {
                            Certificate[] certificates;
                            X509Certificate eeCert;
                            byte[] derSubKeyID;
                            String nextAlias = aliases.nextElement();
                            Key key = this.kstores[i].getKey(nextAlias, passwords[i].toCharArray());
                            if (key == null || !(key instanceof PrivateKey) || (derSubKeyID = (eeCert = (X509Certificate)(certificates = this.kstores[i].getCertificateChain(nextAlias))[0]).getExtensionValue(SUBJECT_KEY_IDENTIFIER_OID)) == null || !Arrays.equals(derSubKeyID, derSubjectKeyID)) continue;
                            privKey = (PrivateKey)key;
                            certs = certificates;
                            found = true;
                        }
                    }
                }
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "invalid request type: " + req.getClass().getName());
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "container-auth: wss : In PrivateKeyCallback Processor:  Error reading key !", e);
            }
        }
        finally {
            this.pkc.setKey(privKey, certs);
            passwords = null;
        }
    }

    private void setDefaultKey(PrivateKeyCallback pkc, String[] passwords) {
        PrivateKey privKey = null;
        Certificate[] certs = null;
        try {
            for (int i = 0; i < this.kstores.length && privKey == null; ++i) {
                Enumeration<String> aliases = this.kstores[i].aliases();
                while (aliases.hasMoreElements() && privKey == null) {
                    String nextAlias = aliases.nextElement();
                    privKey = null;
                    certs = null;
                    Key key = this.kstores[i].getKey(nextAlias, passwords[i].toCharArray());
                    if (key == null || !(key instanceof PrivateKey)) continue;
                    privKey = (PrivateKey)key;
                    certs = this.kstores[i].getCertificateChain(nextAlias);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        pkc.setKey(privKey, certs);
    }
}

