/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.Switch;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.jauth.callback.PasswordValidationCallback;
import com.sun.enterprise.webservice.Processor;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;

public class PasswordValidationProcessor
implements Processor {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    PasswordValidationCallback pvc = null;

    PasswordValidationProcessor(Callback callback) {
        this.pvc = (PasswordValidationCallback)callback;
    }

    public void process() {
        if (Switch.getSwitch().getContainerType() == 1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "container-auth: wss : In PasswordValidationCallback Processorfor appclient - will do nothing");
            }
            this.pvc.setResult(true);
            return;
        }
        String username = this.pvc.getUsername();
        String password = new String(this.pvc.getPassword());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "container-auth: wss : In PasswordValidationCallback Processor");
        }
        try {
            String defaultRealm = Realm.getDefaultRealm();
            LoginContextDriver.wssLoginUsernamePassword(username, password, defaultRealm);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "container-auth wss: authentication succeeded for user = ", username);
            }
            password = null;
            this.pvc.setResult(true);
        }
        catch (LoginException le) {
            _logger.log(Level.INFO, "container-auth: wss : Login failed for user :", username);
            this.pvc.setResult(false);
        }
    }
}

