/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.ejb.Container;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.EjbWebServiceDispatcher;
import com.sun.enterprise.webservice.WebServiceEjbEndpointRegistry;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import com.sun.web.security.WebPrincipal;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.Base64;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;

public final class EjbWebServiceValve
extends ValveBase
implements Lifecycle {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private EjbWebServiceDispatcher webServiceDispatcher;
    private static final Base64 base64Helper = new Base64();
    protected static final String info = "com.sun.enterprise.webservice.EjbWebServiceValve";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private boolean started = false;

    public EjbWebServiceValve() {
        this.webServiceDispatcher = new EjbWebServiceDispatcher();
    }

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        ServletRequest req = request.getRequest();
        HttpServletRequest hreq = null;
        if (req instanceof HttpServletRequest) {
            hreq = (HttpServletRequest)req;
        }
        boolean forward = true;
        if (hreq != null) {
            String requestUriRaw = hreq.getRequestURI();
            String requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
            String method = hreq.getMethod();
            String query = hreq.getQueryString();
            Switch theSwitch = Switch.getSwitch();
            EjbRuntimeEndpointInfo ejbEndpoint = WebServiceEjbEndpointRegistry.getRegistry().getEjbWebServiceEndpoint(requestUri, method, query);
            if (ejbEndpoint != null) {
                forward = false;
                this.dispatchToEjbEndpoint(request, response, ejbEndpoint);
            }
        }
        if (forward) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchToEjbEndpoint(Request request, Response response, EjbRuntimeEndpointInfo ejbEndpoint) {
        String expectedScheme;
        HttpServletRequest hreq = (HttpServletRequest)request;
        String scheme = hreq.getScheme();
        String string = expectedScheme = ejbEndpoint.getEndpoint().isSecure() ? "https" : "http";
        if (!expectedScheme.equalsIgnoreCase(scheme)) {
            logger.log(Level.WARNING, "Invalid request scheme for Endpoint " + ejbEndpoint.getEndpoint().getEndpointName() + ". " + "Expected " + expectedScheme + " . Received " + scheme);
            return;
        }
        Switch theSwitch = Switch.getSwitch();
        Container container = ejbEndpoint.getContainer();
        boolean authenticated = false;
        try {
            container.externalPreInvoke();
            try {
                authenticated = this.doSecurity(request, ejbEndpoint.getEndpoint());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "authentication failed for " + ejbEndpoint.getEndpoint().getEndpointName(), e);
            }
            HttpServletResponse hresp = (HttpServletResponse)response.getResponse();
            if (!authenticated) {
                hresp.sendError(401);
                return;
            }
            this.webServiceDispatcher.invoke(hreq, hresp, ejbEndpoint);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "", t);
        }
        finally {
            if (authenticated) {
                SecurityContext.setCurrent(null);
            }
            container.externalPostInvoke();
        }
    }

    private boolean doSecurity(Request request, WebServiceEndpoint endpoint) throws Exception {
        boolean authenticated = false;
        HttpServletRequest hreq = (HttpServletRequest)request;
        String method = hreq.getMethod();
        if (method.equals("GET") || !endpoint.hasAuthMethod()) {
            return true;
        }
        WebPrincipal webPrincipal = null;
        String endpointName = endpoint.getEndpointName();
        if (endpoint.hasBasicAuth()) {
            String rawAuthInfo = request.getAuthorization();
            if (rawAuthInfo == null) {
                return false;
            }
            String[] usernamePassword = this.parseUsernameAndPassword(rawAuthInfo);
            if (usernamePassword != null) {
                webPrincipal = new WebPrincipal(usernamePassword[0], usernamePassword[1], SecurityContext.init());
            } else {
                logger.log(Level.WARNING, "BASIC AUTH username/password http header parsing error for " + endpointName);
            }
        } else {
            X509Certificate[] certs = request.getConnector().getCertificates(request);
            if (certs != null) {
                webPrincipal = new WebPrincipal(certs, SecurityContext.init());
            } else {
                logger.log(Level.WARNING, "CLIENT CERT authentication error for " + endpointName);
            }
        }
        if (webPrincipal == null) {
            return authenticated;
        }
        RealmAdapter ra = new RealmAdapter();
        authenticated = ra.authenticate(webPrincipal);
        if (!authenticated) {
            logger.fine("authentication failed for " + endpointName);
        }
        return authenticated;
    }

    private String[] parseUsernameAndPassword(String rawAuthInfo) {
        String[] usernamePassword = null;
        if (rawAuthInfo != null && rawAuthInfo.startsWith("Basic ")) {
            String authString = rawAuthInfo.substring(6).trim();
            String unencoded = new String(Base64.decode(authString.getBytes()));
            int colon = unencoded.indexOf(58);
            if (colon > 0) {
                usernamePassword = new String[]{unencoded.substring(0, colon).trim(), unencoded.substring(colon + 1).trim()};
            }
        }
        return usernamePassword;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("EjbWebServiceValve.alreadyStarted");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("EjbWebServiceValve.notStarted");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }
}

