/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.ServletStats;
import com.sun.enterprise.web.monitor.PwcServletStats;
import com.sun.enterprise.web.stats.ServletTimeStatisticImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;

public class ServletStatsImpl
implements ServletStats {
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.ServletStats";
    private static Logger _logger = null;
    private GenericStatsImpl baseStatsImpl;
    private MutableCountStatistic maxTime;
    private MutableCountStatistic processingTime;
    private TimeStatistic serviceTime;
    private MutableCountStatistic requestCount;
    private MutableCountStatistic errorCount;
    private PwcServletStats pwcServletStats;

    public ServletStatsImpl(PwcServletStats pwcServletStats) {
        this.pwcServletStats = pwcServletStats;
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (ClassNotFoundException e) {
            _logger.log(Level.WARNING, "Error creating instance of GenericStatsImpl", e);
        }
        this.initializeStatistics();
    }

    public CountStatistic getMaxTime() {
        this.maxTime.setCount(this.pwcServletStats.getMaxTime());
        return (CountStatistic)this.maxTime.unmodifiableView();
    }

    public CountStatistic getProcessingTime() {
        this.processingTime.setCount(this.pwcServletStats.getProcessingTime());
        return (CountStatistic)this.processingTime.unmodifiableView();
    }

    public TimeStatistic getServiceTime() {
        return this.serviceTime;
    }

    public CountStatistic getRequestCount() {
        this.requestCount.setCount((long)this.pwcServletStats.getRequestCount());
        return (CountStatistic)this.requestCount.unmodifiableView();
    }

    public CountStatistic getErrorCount() {
        this.errorCount.setCount((long)this.pwcServletStats.getErrorCount());
        return (CountStatistic)this.errorCount.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl("ErrorCount");
        this.errorCount = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxTime", "milliseconds");
        this.maxTime = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("ProcessingTime", "milliseconds");
        this.processingTime = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("RequestCount");
        this.requestCount = new MutableCountStatisticImpl((CountStatistic)c);
        this.serviceTime = new ServletTimeStatisticImpl("ServiceTime", "milliseconds", this.pwcServletStats);
    }
}

