/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.HTTPListenerStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class HTTPListenerStatsImpl
implements HTTPListenerStats {
    private GenericStatsImpl baseStatsImpl;
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.HTTPListenerStats";
    private MBeanServer server;
    private ObjectName tpName;
    private ObjectName grpName;
    private MutableCountStatistic bytesReceived;
    private MutableCountStatistic bytesSent;
    private MutableCountStatistic errorCount;
    private MutableCountStatistic maxTime;
    private MutableCountStatistic processingTime;
    private MutableCountStatistic requestCount;
    private MutableCountStatistic curThreadCount;
    private MutableCountStatistic curThreadsBusy;
    private MutableCountStatistic maxThreads;
    private MutableCountStatistic maxSpareThreads;
    private MutableCountStatistic minSpareThreads;
    private static Logger _logger = null;

    public HTTPListenerStatsImpl(String domain, int port) {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (ClassNotFoundException cnfe) {
            _logger.info("Error creating instance of GenericStatsImpl " + cnfe.getMessage());
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        Hashtable<String, String> propList = new Hashtable<String, String>();
        propList.put("type", "ThreadPool");
        propList.put("name", "http" + port);
        try {
            this.tpName = new ObjectName(domain, propList);
        }
        catch (MalformedObjectNameException mone) {
            _logger.info("Error creating the ThreadPool ObjectName " + mone.getMessage());
        }
        catch (NullPointerException npe) {
            _logger.info("Error creating the ThreadPool ObjectName ");
        }
        propList.clear();
        propList.put("type", "GlobalRequestProcessor");
        propList.put("name", "http" + port);
        try {
            this.grpName = new ObjectName(domain, propList);
        }
        catch (MalformedObjectNameException mone) {
            _logger.info("Error creating the GlobalRequestProcessor ObjectName " + mone.getMessage());
        }
        catch (NullPointerException npe) {
            _logger.info("Error creating the GlobalRequestProcessor ObjectName ");
        }
        this.initializeStatistics();
    }

    public CountStatistic getBytesReceived() {
        Object countObj = this.queryStatistic(this.grpName, "bytesReceived");
        this.bytesReceived.setCount(this.getLongValue(countObj));
        return (CountStatistic)this.bytesReceived.unmodifiableView();
    }

    public CountStatistic getBytesSent() {
        Object countObj = this.queryStatistic(this.grpName, "bytesSent");
        this.bytesSent.setCount(this.getLongValue(countObj));
        return (CountStatistic)this.bytesSent.unmodifiableView();
    }

    public CountStatistic getProcessingTime() {
        Object countObj = this.queryStatistic(this.grpName, "processingTime");
        this.processingTime.setCount(this.getLongValue(countObj));
        return (CountStatistic)this.processingTime.unmodifiableView();
    }

    public CountStatistic getRequestCount() {
        Object countObj = this.queryStatistic(this.grpName, "requestCount");
        this.requestCount.setCount(this.getIntValue(countObj));
        return (CountStatistic)this.requestCount.unmodifiableView();
    }

    public CountStatistic getErrorCount() {
        Object countObj = this.queryStatistic(this.grpName, "errorCount");
        this.errorCount.setCount(this.getIntValue(countObj));
        return (CountStatistic)this.errorCount.unmodifiableView();
    }

    public CountStatistic getMaxTime() {
        Object countObj = this.queryStatistic(this.grpName, "maxTime");
        this.maxTime.setCount(this.getLongValue(countObj));
        return (CountStatistic)this.maxTime.unmodifiableView();
    }

    public CountStatistic getCurrentThreadCount() {
        Object countObj = this.queryStatistic(this.tpName, "currentThreadCount");
        this.curThreadCount.setCount(this.getIntValue(countObj));
        return (CountStatistic)this.curThreadCount.unmodifiableView();
    }

    public CountStatistic getCurrentThreadsBusy() {
        Object countObj = this.queryStatistic(this.tpName, "currentThreadsBusy");
        this.curThreadsBusy.setCount(this.getIntValue(countObj));
        return (CountStatistic)this.curThreadsBusy.unmodifiableView();
    }

    public CountStatistic getMaxSpareThreads() {
        Object countObj = this.queryStatistic(this.tpName, "maxSpareThreads");
        this.maxSpareThreads.setCount(this.getIntValue(countObj));
        return (CountStatistic)this.maxSpareThreads.unmodifiableView();
    }

    public CountStatistic getMaxThreads() {
        Object countObj = this.queryStatistic(this.tpName, "maxThreads");
        this.maxThreads.setCount(this.getIntValue(countObj));
        return (CountStatistic)this.maxThreads.unmodifiableView();
    }

    public CountStatistic getMinSpareThreads() {
        Object countObj = this.queryStatistic(this.tpName, "minSpareThreads");
        this.minSpareThreads.setCount(this.getIntValue(countObj));
        return (CountStatistic)this.minSpareThreads.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private Object queryStatistic(ObjectName on, String attrName) {
        Object resultObj = null;
        try {
            resultObj = this.server.getAttribute(on, attrName);
        }
        catch (MBeanException mbe) {
            _logger.info("MBeanException in queryStatistic " + mbe.getMessage());
        }
        catch (AttributeNotFoundException anfe) {
            _logger.info("Attribute being queried does not exist: " + attrName);
        }
        catch (InstanceNotFoundException infe) {
            _logger.info("MBean being queried is not registered: " + on.toString());
        }
        catch (ReflectionException re) {
            _logger.info("ReflectionException in queryStatistic " + re.getMessage());
        }
        catch (Exception e) {
            _logger.info("Exception in queryStatistic " + e.getMessage());
        }
        return resultObj;
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl("BytesReceived");
        this.bytesReceived = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("BytesSent");
        this.bytesSent = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("ErrorCount");
        this.errorCount = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxTime", "milliseconds");
        this.maxTime = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("ProcessingTime", "milliseconds");
        this.processingTime = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("RequestCount");
        this.requestCount = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CurrentThreadCount");
        this.curThreadCount = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CurrentThreadsBusy");
        this.curThreadsBusy = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxThreads");
        this.maxThreads = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxSpareThreads");
        this.maxSpareThreads = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MinSpareThreads");
        this.minSpareThreads = new MutableCountStatisticImpl((CountStatistic)c);
    }

    private long getLongValue(Object resultObj) {
        long result = 0L;
        if (resultObj != null) {
            Long countObj = (Long)resultObj;
            result = countObj;
        }
        return result;
    }

    private long getIntValue(Object resultObj) {
        int result = 0;
        if (resultObj != null) {
            Integer countObj = (Integer)resultObj;
            result = countObj;
        }
        return result;
    }
}

