/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.monitor.impl;

import com.sun.enterprise.web.monitor.PwcWebModuleStats;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class PwcWebModuleStatsImpl
implements PwcWebModuleStats {
    private static final String WEB_MODULE_PREFIX = "//";
    private static final Integer ZERO_INTEGER = new Integer(0);
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private ObjectName jspMonitorObjName;
    private ObjectName sessionManagerObjName;
    private ObjectName ctxObjName;
    private transient MBeanServer server;

    public PwcWebModuleStatsImpl(String ctxObjNameStr, String ctxPath, String domain, String vsId, String appName, String serverName) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = servers != null && !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        if ("".equals(ctxPath)) {
            ctxPath = "/";
        }
        try {
            this.ctxObjName = new ObjectName(ctxObjNameStr);
        }
        catch (MalformedObjectNameException mone) {
            _logger.log(Level.SEVERE, "Error creating ObjectName for web module", mone);
        }
        String objNameStr = domain + ":type=JspMonitor" + ",WebModule=" + WEB_MODULE_PREFIX + vsId + ctxPath + ",J2EEApplication=" + appName + ",J2EEServer=" + serverName + ",*";
        try {
            this.jspMonitorObjName = new ObjectName(objNameStr);
        }
        catch (MalformedObjectNameException mone) {
            _logger.log(Level.SEVERE, "Error creating ObjectName for JspMonitor", mone);
        }
        objNameStr = domain + ":type=Manager,path=" + ctxPath + ",host=" + vsId;
        try {
            this.sessionManagerObjName = new ObjectName(objNameStr);
        }
        catch (MalformedObjectNameException mone) {
            _logger.log(Level.SEVERE, "Error creating ObjectName for session manager", mone);
        }
    }

    public int getJspCount() {
        return this.queryStatistic(this.jspMonitorObjName, "jspCount");
    }

    public int getJspReloadCount() {
        return this.queryStatistic(this.jspMonitorObjName, "jspReloadCount");
    }

    public int getSessionsTotal() {
        return this.queryStatistic(this.sessionManagerObjName, "sessionCounter");
    }

    public int getActiveSessionsCurrent() {
        return this.queryStatistic(this.sessionManagerObjName, "activeSessions");
    }

    public int getActiveSessionsHigh() {
        return this.queryStatistic(this.sessionManagerObjName, "maxActive");
    }

    public int getRejectedSessionsTotal() {
        return this.queryStatistic(this.sessionManagerObjName, "rejectedSessions");
    }

    public int getExpiredSessionsTotal() {
        return this.queryStatistic(this.sessionManagerObjName, "expiredSessions");
    }

    public int getSessionMaxAliveTime() {
        return this.queryStatistic(this.sessionManagerObjName, "sessionMaxAliveTime");
    }

    public int getSessionAverageAliveTime() {
        return this.queryStatistic(this.sessionManagerObjName, "sessionAverageAliveTime");
    }

    public long getStartTime() {
        return this.queryStatistic(this.ctxObjName, "startTime");
    }

    public void reset() {
        this.resetStatistic(this.jspMonitorObjName, "jspReloadCount");
    }

    private int queryStatistic(ObjectName on, String attrName) {
        int result = 0;
        Set<ObjectName> jspMonitorONs = this.server.queryNames(on, null);
        Iterator<ObjectName> iter = jspMonitorONs.iterator();
        while (iter.hasNext()) {
            ObjectName jspMonitorON = iter.next();
            Object obj = null;
            try {
                obj = this.server.getAttribute(jspMonitorON, attrName);
            }
            catch (MBeanException mbe) {
                _logger.info("MBeanException in queryStatistic " + mbe.getMessage());
            }
            catch (AttributeNotFoundException anfe) {
                _logger.info("Attribute being queried does not exist: " + attrName);
            }
            catch (InstanceNotFoundException infe) {
                _logger.info("MBean being queried is not registered: " + on.toString());
            }
            catch (ReflectionException re) {
                _logger.info("ReflectionException in queryStatistic " + re.getMessage());
            }
            catch (Exception e) {
                _logger.info("Exception in queryStatistic " + e.getMessage());
            }
            if (obj == null) continue;
            result += ((Integer)obj).intValue();
        }
        return result;
    }

    private void resetStatistic(ObjectName on, String attrName) {
        Attribute attr = new Attribute(attrName, ZERO_INTEGER);
        try {
            this.server.setAttribute(on, attr);
        }
        catch (Exception ex) {
            _logger.info("Failed to reset attribute " + attrName + " on MBean " + on + ": " + ex.getMessage());
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = servers != null && !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
    }
}

