/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.tomcat.util.buf.ByteChunk;

public class SocketChannelOutputBuffer
extends InternalOutputBuffer {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private ByteBuffer byteBufferCache;
    private ByteBuffer byteBuffer;
    protected SocketChannel socketChannel;

    public SocketChannelOutputBuffer(Response response, int headerBufferSize) {
        super(response, headerBufferSize);
        this.outputStreamOutputBuffer = new OutputStreamOutputBuffer();
        this.byteBufferCache = ByteBuffer.allocateDirect(8192);
    }

    public void setChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public SocketChannel getChannel() {
        return this.socketChannel;
    }

    public void flush() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
    }

    public void recycle() {
        super.recycle();
        this.socketChannel = null;
        if (this.byteBuffer != null) {
            this.byteBuffer.clear();
        }
    }

    public void sendAck() throws IOException {
        if (!this.committed) {
            this.byteBuffer = this.allocateByteBuffer(Constants.ACK_BYTES.length);
            this.byteBuffer.put(Constants.ACK_BYTES);
            this.byteBuffer.flip();
            this.flushChannel();
        }
    }

    public void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.byteBuffer = this.allocateByteBuffer(this.pos);
            this.byteBuffer.put(this.buf, 0, this.pos);
            this.byteBuffer.flip();
            this.flushChannel();
        }
    }

    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            this.byteBuffer = this.allocateByteBuffer(len);
            this.byteBuffer.put(cbuf, off, len);
            this.byteBuffer.flip();
            this.flushChannel();
        }
    }

    private ByteBuffer allocateByteBuffer(int size) {
        if (size > this.byteBufferCache.capacity()) {
            this.byteBufferCache = ByteBuffer.allocateDirect(size);
        }
        return this.byteBufferCache;
    }

    private void flushChannel() throws IOException {
        try {
            while (this.byteBuffer.hasRemaining()) {
                int len;
                if (!this.socketChannel.isOpen() || (len = this.socketChannel.write(this.byteBuffer)) >= 0) continue;
                throw new IOException("End of File Exception");
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.byteBuffer.clear();
        }
    }

    protected class OutputStreamOutputBuffer
    implements OutputBuffer {
        protected OutputStreamOutputBuffer() {
        }

        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            SocketChannelOutputBuffer.this.byteBuffer = SocketChannelOutputBuffer.this.allocateByteBuffer(chunk.getLength());
            SocketChannelOutputBuffer.this.byteBuffer.put(chunk.getBuffer(), chunk.getStart(), chunk.getLength());
            SocketChannelOutputBuffer.this.byteBuffer.flip();
            SocketChannelOutputBuffer.this.flushChannel();
            return chunk.getLength();
        }
    }
}

