/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.connector.grizzly.AcceptTask;
import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.ReadBlockingTask;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.TaskContext;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.Adapter;
import org.apache.coyote.RequestGroupInfo;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;

public class SelectorThread
extends Thread
implements MBeanRegistration,
MonitoringLevelListener {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static final int BACKLOG = 500;
    private static final int TIMEOUT = 1000;
    private int backlog = 500;
    private int serverTimeout = 1000;
    private InetAddress inet;
    private int port;
    private ServerSocketFactory factory;
    private ServerSocket serverSocket;
    protected SSLImplementation sslImplementation = null;
    private volatile boolean running = false;
    private volatile boolean paused = false;
    private boolean initialized = false;
    private boolean reinitializing = false;
    protected String domain;
    protected ObjectName oname;
    protected ObjectName processorPipelineName;
    protected ObjectName globalRequestProcessorName;
    protected MBeanServer mserver;
    protected ObjectName processorWorkerThreadName;
    protected boolean tcpNoDelay = false;
    protected int linger = 100;
    protected int socketTimeout = -1;
    private int maxKeepAliveRequests = -1;
    protected static int maxHttpHeaderSize = 4096;
    private int acceptPoolNumber = 5;
    private int readPoolNumber = 50;
    private int processorPoolNumber = 50;
    private Selector selector;
    protected Adapter adapter = null;
    private boolean secure = false;
    private Pipeline acceptPipeline;
    private Pipeline readPipeline;
    private Pipeline processorPipeline;
    private int maxProcessorWorkerThread = 50;
    private int maxAcceptWorkerThread = 0;
    private int maxReadWorkerThread = 10;
    private int minWorkerThreads = 10;
    private int minSpareThreads = 5;
    private List listOfOps = new ArrayList();
    private List listOfOpsToDeregister = new ArrayList();
    private List listOfChannels = new ArrayList();
    private boolean useNioNonBlocking = false;
    private ServerSocketChannel serverSocketChannel;
    private LinkedList acceptTasks = new LinkedList();
    private LinkedList processorTasks = new LinkedList();
    private LinkedList readTasks = new LinkedList();
    private LinkedList readBlockingTasks = new LinkedList();
    private static int selectorTimeout = 60000;
    private static final String SELECTOR_TIMEOUT = "com.sun.enterprise.web.connector.grizzly.selector.timeout";
    private static final String THREAD_MODE = "com.sun.enterprise.web.connector.grizzly.singlethread";
    private static final String MAX_ACCEPTOR_THREAD = "com.sun.enterprise.web.connector.grizzly.maxAcceptWorkerThread";
    private static final String MIN_THREAD = "com.sun.enterprise.web.connector.grizzly.minWorkerThreads";
    private static final String MAX_READ_THREAD = "com.sun.enterprise.web.connector.grizzly.maxReadWorkerThread";
    private static final String TASK_POOL = "com.sun.enterprise.web.connector.grizzly.pools.size";
    private static final String NON_BLOCKING_MODE = "com.sun.enterprise.web.connector.grizzly.useNioNonBlocking";
    private static final String DISPLAY_CONFIGURATION = "com.sun.enterprise.web.connector.grizzly.displayConfiguration";
    private static final String USE_MONITORING = "com.sun.enterprise.web.connector.grizzly.monitoring";
    private static final String MAX_KEEP_ALIVE_REQUEST = "com.sun.enterprise.web.connector.grizzly.maxKeepAliveRequests";
    private static final String MAX_SIMUL_CONNECTION = "com.sun.enterprise.web.connector.grizzly.maxConnections";
    protected RequestGroupInfo globalRequestProcessor = new RequestGroupInfo();
    protected boolean displayConfiguration = false;
    protected static boolean isMonitoringEnabled = false;
    protected int maxConnections = 1000;
    protected int currentConnectionNumber;
    protected volatile boolean isWaiting = false;
    private int requestBufferSize = 4096;

    public SelectorThread() {
        this.configureProperties();
    }

    protected void configureProperties() {
        if (System.getProperty(SELECTOR_TIMEOUT) != null) {
            try {
                selectorTimeout = Integer.parseInt(System.getProperty(SELECTOR_TIMEOUT));
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "selectorThread.invalidSelectorTimeout");
            }
        }
        if (System.getProperty(MAX_ACCEPTOR_THREAD) != null) {
            try {
                this.maxAcceptWorkerThread = Integer.parseInt(System.getProperty(MAX_ACCEPTOR_THREAD));
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "selectorThread.maxAcceptWorkerThreads");
            }
        }
        if (System.getProperty(MIN_THREAD) != null) {
            try {
                this.minWorkerThreads = Integer.parseInt(System.getProperty(MIN_THREAD));
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "selectorThread.invalidMinThreads");
            }
        }
        if (System.getProperty(MAX_SIMUL_CONNECTION) != null) {
            try {
                this.maxConnections = Integer.parseInt(System.getProperty(MAX_SIMUL_CONNECTION));
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "selectorThread.invalidMaxConnections");
            }
        }
        if (System.getProperty(MAX_READ_THREAD) != null) {
            try {
                this.maxReadWorkerThread = Integer.parseInt(System.getProperty(MAX_READ_THREAD));
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "selectorThread.maxReadWorkerThreads");
            }
        }
        if (System.getProperty(TASK_POOL) != null) {
            try {
                int taskPoolNumber;
                this.readPoolNumber = this.processorPoolNumber = (taskPoolNumber = Integer.parseInt(System.getProperty(TASK_POOL)));
                this.acceptPoolNumber = this.processorPoolNumber;
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "selectorThread.invalidPoolSize");
            }
        }
        if (System.getProperty(NON_BLOCKING_MODE) != null) {
            this.useNioNonBlocking = Boolean.valueOf(System.getProperty(NON_BLOCKING_MODE));
        }
        if (System.getProperty(DISPLAY_CONFIGURATION) != null) {
            this.displayConfiguration = Boolean.valueOf(System.getProperty(DISPLAY_CONFIGURATION));
        }
        if (System.getProperty(MAX_KEEP_ALIVE_REQUEST) != null) {
            try {
                this.maxKeepAliveRequests = Integer.parseInt(System.getProperty(MAX_KEEP_ALIVE_REQUEST));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void initEndpoint() throws IOException, InstantiationException {
        this.initMonitoringLevel();
        if (this.maxAcceptWorkerThread > 0 && this.useNioNonBlocking) {
            this.acceptPipeline = new Pipeline(this.maxAcceptWorkerThread, this.minWorkerThreads, "Accept", this.port, this.minSpareThreads);
            this.acceptPipeline.initPipeline();
        }
        if (this.maxReadWorkerThread > 0) {
            this.readPipeline = new Pipeline(this.maxReadWorkerThread, this.minWorkerThreads, "Read", this.port, this.minSpareThreads);
            this.readPipeline.initPipeline();
        }
        this.processorPipeline = new Pipeline(this.maxProcessorWorkerThread, this.minWorkerThreads, "http", this.port, this.minSpareThreads);
        this.processorPipeline.initPipeline();
        this.setName("SelectorThread-" + this.port);
        if (!this.secure) {
            try {
                if (this.useNioNonBlocking) {
                    ServerSocketChannel serverChannel = ServerSocketChannel.open();
                    this.selector = Selector.open();
                    this.serverSocket = serverChannel.socket();
                    serverChannel.socket().bind(new InetSocketAddress(this.port));
                    serverChannel.configureBlocking(false);
                    serverChannel.register(this.selector, 16);
                }
                this.serverSocketChannel = ServerSocketChannel.open();
                this.serverSocket = this.serverSocketChannel.socket();
                if (this.inet == null) {
                    this.serverSocket.bind(new InetSocketAddress(this.port));
                }
                this.serverSocket.bind(new InetSocketAddress(this.inet, this.port));
            }
            catch (SocketException ex) {
                throw new SocketException(ex.getMessage() + ": " + this.port);
            }
        } else if (this.serverSocket == null) {
            try {
                this.serverSocket = this.inet == null ? this.factory.createSocket(this.port, this.backlog) : this.factory.createSocket(this.port, this.backlog, this.inet);
            }
            catch (BindException be) {
                throw new BindException(be.getMessage() + ":" + this.port);
            }
        }
        this.serverSocket.setSoTimeout(this.serverTimeout);
        if (this.secure) {
            this.useNioNonBlocking = false;
        }
        if (this.useNioNonBlocking) {
            this.initReadTask(this.readPoolNumber);
            this.initAcceptTask(this.acceptPoolNumber);
            this.initProcessorTask(this.processorPoolNumber);
        } else {
            this.initReadBlockingTask(this.readPoolNumber);
        }
        this.initialized = true;
        if (this.displayConfiguration) {
            logger.log(Level.INFO, "\n Grizzly NIO configuration:\n\t useNioNonBlocking:" + this.useNioNonBlocking + "\n\t readPoolNumber:" + this.readPoolNumber + "\n\t processorPoolNumber:" + this.processorPoolNumber + "\n\t acceptPoolNumber:" + this.acceptPoolNumber + "\n\t maxAcceptWorkerThread:" + this.maxAcceptWorkerThread + "\n\t maxReadWorkerThread:" + this.maxReadWorkerThread + "\n\t maxProcessorWorkerThread: " + this.maxProcessorWorkerThread + "\n\t minWorkerThreads:" + this.minWorkerThreads + "\n\t selectorTimeout:" + selectorTimeout + "\n\t ByteBuffer size: " + Constants.CHANNEL_BYTE_SIZE + "\n\t useKeepAliveAlgorithm:" + ProcessorTask.useKeepAliveAlgorithm + "\n\t Keep-Alive timeout:" + ProcessorTask.keepAliveTimeout + "\n\t maxHttpHeaderSize:" + ProcessorTask.maxHttpHeaderSize + "\n\t maxKeepAliveRequests: " + this.maxKeepAliveRequests + "\n\t socketSoTimeout: " + Constants.DEFAULT_CONNECTION_TIMEOUT);
        }
    }

    private void initReadTask(int size) {
        for (int i = 0; i < size; ++i) {
            ReadTask task = new ReadTask();
            task.setPipeline(this.readPipeline);
            this.readTasks.addLast(task);
        }
    }

    private void initReadBlockingTask(int size) {
        for (int i = 0; i < size; ++i) {
            this.readBlockingTasks.addLast(this.createReadBlockingTask(true));
        }
    }

    private ReadBlockingTask createReadBlockingTask(boolean initialize) {
        ReadBlockingTask task = new ReadBlockingTask();
        task.setSelectorThread(this);
        if (this.maxReadWorkerThread > 0) {
            task.setPipeline(this.readPipeline);
        }
        task.setProcessorTask(this.createProcessorTask(false, initialize));
        TaskEvent taskEvent = new TaskEvent();
        taskEvent.setTaskContext(new TaskContext(false));
        task.setTaskEvent(taskEvent);
        return task;
    }

    private void initAcceptTask(int size) {
        for (int i = 0; i < size; ++i) {
            AcceptTask task = new AcceptTask();
            task.setPipeline(this.acceptPipeline);
            this.acceptTasks.addLast(task);
        }
    }

    private void initProcessorTask(int size) {
        for (int i = 0; i < size; ++i) {
            this.processorTasks.addLast(this.createProcessorTask(this.useNioNonBlocking, true));
        }
    }

    protected ProcessorTask createProcessorTask(boolean useNioNonBlocking, boolean initialize) {
        ProcessorTask task = new ProcessorTask(useNioNonBlocking, initialize);
        task.setAdapter(this.adapter);
        task.setMaxKeepAliveRequests(this.maxKeepAliveRequests);
        task.setBufferSize(this.requestBufferSize);
        task.setSelectorThread(this);
        if (this.secure) {
            task.setSSLImplementation(this.sslImplementation);
        }
        task.setRequestGroupInfo(this.globalRequestProcessor);
        task.setPipeline(this.processorPipeline);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProcessorTask getProcessorTask(boolean useNioNonBlocking) {
        ProcessorTask processorTask = null;
        LinkedList linkedList = this.processorTasks;
        synchronized (linkedList) {
            if (this.processorTasks.size() > 0) {
                processorTask = (ProcessorTask)this.processorTasks.removeFirst();
            }
        }
        if (processorTask == null) {
            processorTask = this.createProcessorTask(useNioNonBlocking, false);
        }
        processorTask.setUseMonitoring(isMonitoringEnabled);
        return processorTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReadTask getReadTask() {
        ReadTask task = null;
        LinkedList linkedList = this.readTasks;
        synchronized (linkedList) {
            if (this.readTasks.size() > 0) {
                task = (ReadTask)this.readTasks.removeFirst();
            }
        }
        if (task == null) {
            task = new ReadTask();
            task.setPipeline(this.readPipeline);
        }
        task.activate();
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReadBlockingTask getReadBlockingTask(Socket socket) {
        ReadBlockingTask task = null;
        LinkedList linkedList = this.readBlockingTasks;
        synchronized (linkedList) {
            if (this.readBlockingTasks.size() > 0) {
                task = (ReadBlockingTask)this.readBlockingTasks.removeFirst();
            }
        }
        if (task == null) {
            task = this.createReadBlockingTask(false);
        }
        task.setSocket(socket);
        task.setUseMonitoring(isMonitoringEnabled);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AcceptTask getAcceptTask() {
        AcceptTask task = null;
        LinkedList linkedList = this.acceptTasks;
        synchronized (linkedList) {
            if (this.acceptTasks.size() > 0) {
                task = (AcceptTask)this.acceptTasks.removeFirst();
            }
        }
        if (task == null) {
            task = new AcceptTask();
            task.setPipeline(this.acceptPipeline);
        }
        return task;
    }

    public void run() {
        try {
            this.startEndpoint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "selectorThread.errorOnRequest", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableInterestOps() {
        List list = this.listOfOps;
        synchronized (list) {
            Iterator it = this.listOfOps.iterator();
            if (this.listOfOps.isEmpty()) {
                return;
            }
            while (it.hasNext()) {
                KeyAndOp keyAndOp = (KeyAndOp)it.next();
                it.remove();
                SelectionKey selectionKey = keyAndOp.key;
                if (!selectionKey.isValid()) continue;
                int op = keyAndOp.Op;
                selectionKey.interestOps(selectionKey.interestOps() | op);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableChannelRegistration() throws ClosedChannelException {
        List list = this.listOfChannels;
        synchronized (list) {
            if (this.listOfChannels.isEmpty()) {
                return;
            }
            Iterator it = this.listOfChannels.iterator();
            while (it.hasNext()) {
                SocketChannelAndOp sco = (SocketChannelAndOp)it.next();
                it.remove();
                SocketChannel channel = sco.channel;
                int Op = sco.Op;
                SelectionKey readKey = null;
                try {
                    if (channel == null) continue;
                    readKey = channel.register(this.selector, Op);
                    readKey.attach(sco.task);
                }
                catch (ClosedChannelException ex) {
                    logger.log(Level.FINE, "selectorThread.enableChannelRegistration", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterestOp(SelectionKey key, int Op) {
        if (key.isValid()) {
            KeyAndOp keyAndOp = new KeyAndOp(key, Op);
            List list = this.listOfOps;
            synchronized (list) {
                this.listOfOps.add(keyAndOp);
            }
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterInterestOp(SelectionKey key) {
        List list = this.listOfOpsToDeregister;
        synchronized (list) {
            this.listOfOpsToDeregister.add(key);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableInterestOp() {
        SelectionKey key = null;
        List list = this.listOfOpsToDeregister;
        synchronized (list) {
            int size = this.listOfOpsToDeregister.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    key = (SelectionKey)this.listOfOpsToDeregister.get(i);
                    if (!key.isValid()) continue;
                    this.cancelKey(key);
                }
            }
            this.listOfOpsToDeregister.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChannelInterestOp(SocketChannel channel, int Op, Task task) throws IOException {
        SocketChannelAndOp sco = new SocketChannelAndOp(channel, Op, task);
        List list = this.listOfChannels;
        synchronized (list) {
            this.listOfChannels.add(sco);
        }
        this.selector.wakeup();
    }

    public void startEndpoint() throws IOException, InstantiationException {
        this.running = true;
        this.registerMonitoringLevelEvents();
        if (this.acceptPipeline != null) {
            this.acceptPipeline.startPipeline();
        }
        if (this.readPipeline != null) {
            this.readPipeline.startPipeline();
        }
        this.processorPipeline.startPipeline();
        if (this.secure) {
            Socket socket = null;
            while (this.running) {
                try {
                    socket = this.acceptSocket();
                    if (socket == null) continue;
                    this.factory.handshake(socket);
                    this.handleConnection(socket);
                }
                catch (Throwable ex) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    logger.log(Level.FINE, "selectorThread.sslHandshakeException", ex);
                }
            }
        } else if (this.useNioNonBlocking) {
            SelectionKey key = null;
            while (this.running) {
                try {
                    Set<SelectionKey> readyKeys;
                    this.enableChannelRegistration();
                    this.enableInterestOps();
                    int selectorState = 0;
                    try {
                        selectorState = this.selector.select(selectorTimeout);
                    }
                    catch (CancelledKeyException ex) {
                        // empty catch block
                    }
                    this.disableInterestOp();
                    if (selectorState <= 0 || (readyKeys = this.selector.selectedKeys()).isEmpty()) continue;
                    Iterator<SelectionKey> iterator = readyKeys.iterator();
                    while (iterator.hasNext()) {
                        key = iterator.next();
                        iterator.remove();
                        if (!key.isValid()) continue;
                        this.handleConnection(key);
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.FINE, "selectorThread.errorOnRequest", t);
                }
            }
        } else {
            Socket socket = null;
            while (this.running) {
                try {
                    this.lockSelector();
                    SocketChannel sc = this.serverSocketChannel.accept();
                    socket = sc.socket();
                    if (socket == null) continue;
                    this.handleConnection(socket);
                }
                catch (Throwable t) {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    logger.log(Level.FINE, "selectorThread.errorOnRequest", t);
                }
            }
        }
    }

    private void handleConnection(Socket socket) throws IOException {
        this.setSocketOptions(socket);
        this.getReadBlockingTask(socket).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockSelector() throws InterruptedException {
        if (this.maxConnections == -1) {
            return;
        }
        SelectorThread selectorThread = this;
        synchronized (selectorThread) {
            ++this.currentConnectionNumber;
            if (this.currentConnectionNumber > this.maxConnections) {
                logger.log(Level.INFO, "selectorThread.maxConnectionReached", new Object[]{new Integer(this.port), new Integer(this.maxConnections)});
                this.isWaiting = true;
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockSelector() {
        if (this.maxConnections == -1) {
            return;
        }
        SelectorThread selectorThread = this;
        synchronized (selectorThread) {
            --this.currentConnectionNumber;
            if (this.isWaiting) {
                try {
                    this.notify();
                    this.isWaiting = false;
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "selectorThread.errorOnRequest", ex);
                }
            }
        }
    }

    private void handleConnection(SelectionKey key) throws IOException, InterruptedException {
        Task task = null;
        ProcessorTask processorTask = null;
        if ((key.readyOps() & 0x10) == 16) {
            this.lockSelector();
            key.interestOps(key.interestOps() & 0xFFFFFFEF);
            task = this.getAcceptTask();
            task.setSelectionKey(key);
        } else if ((key.readyOps() & 1) == 1) {
            key.interestOps(key.interestOps() & 0xFFFFFFFE);
            Task attachedTask = (Task)key.attachment();
            if (attachedTask == null) {
                this.cancelKey(key);
                return;
            }
            if (attachedTask.getType() == 0) {
                task = this.getReadTask();
                processorTask = this.getProcessorTask(true);
                task.addTaskListener(processorTask);
                processorTask.addTaskListener(attachedTask);
                processorTask.addTaskListener(task);
                processorTask.setSocket(((SocketChannel)key.channel()).socket());
                task.setSelectionKey(key);
                processorTask.setSelectionKey(key);
                key.attach(task);
                this.setSocketOptions(((SocketChannel)key.channel()).socket());
            } else {
                task = (ReadTask)key.attachment();
            }
        }
        if (task != null) {
            task.setSelectorThread(this);
            task.execute();
        } else {
            this.cancelKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void cancelKey(SelectionKey key) {
        block10: {
            key.cancel();
            try {
                ((SocketChannel)key.channel()).socket().shutdownOutput();
            }
            catch (IOException ex) {
                // empty catch block
            }
            ((SocketChannel)key.channel()).socket().close();
            Object var4_4 = null;
            try {
                key.channel().close();
            }
            catch (IOException ex) {
                logger.log(Level.FINEST, "selectorThread.unableToCloseKey", key);
            }
            break block10;
            {
                catch (IOException iOException) {
                    Object var4_5 = null;
                    try {
                        key.channel().close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.FINEST, "selectorThread.unableToCloseKey", key);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    key.channel().close();
                }
                catch (IOException ex) {
                    logger.log(Level.FINEST, "selectorThread.unableToCloseKey", key);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnTask(Task task) {
        if (task != null) {
            task.recycle();
            if (task.getType() == 3) {
                LinkedList linkedList = this.readBlockingTasks;
                synchronized (linkedList) {
                    this.readBlockingTasks.addLast(task);
                }
                this.unlockSelector();
            } else if (task.getType() == 2) {
                LinkedList linkedList = this.processorTasks;
                synchronized (linkedList) {
                    this.processorTasks.addLast(task);
                }
                this.unlockSelector();
            } else {
                if (task.getType() == 1) {
                    LinkedList linkedList = this.readTasks;
                    synchronized (linkedList) {
                        this.readTasks.addLast(task);
                    }
                }
                if (task.getType() == 0) {
                    LinkedList linkedList = this.acceptTasks;
                    synchronized (linkedList) {
                        this.acceptTasks.addLast(task);
                    }
                }
            }
        }
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    public void pauseEndpoint() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void resumeEndpoint() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stopEndpoint() {
        if (this.acceptPipeline != null) {
            this.acceptPipeline.stopPipeline();
        }
        if (this.readPipeline != null) {
            this.readPipeline.stopPipeline();
        }
        this.processorPipeline.stopPipeline();
        if (this.running) {
            this.running = false;
            if (this.serverSocket != null && this.secure) {
                this.closeServerSocket();
            }
        }
        this.unregisterComponents();
        this.unregisterMonitoringLevelEvents();
    }

    protected void closeServerSocket() {
        if (!this.paused) {
            this.unlockAccept();
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "selectorThread.closeSocketException", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void unlockAccept() {
        Socket s;
        block9: {
            if (!this.secure) return;
            s = null;
            if (this.inet == null) {
                s = new Socket("127.0.0.1", this.port);
                break block9;
            }
            s = new Socket(this.inet, this.port);
            s.setSoLinger(true, 0);
        }
        Object var4_2 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                logger.log(Level.FINE, "selectorThread.unlockAcceptException" + this.port + " " + e.toString());
                Object var4_3 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean getUseNioNonBlocking() {
        return this.useNioNonBlocking;
    }

    public void setMaxThreads(int maxThreads) {
        if (maxThreads > 0) {
            this.maxProcessorWorkerThread = maxThreads;
        }
    }

    public int getMaxThreads() {
        return this.maxProcessorWorkerThread;
    }

    public void setMaxSpareThreads(int maxThreads) {
    }

    public int getMaxSpareThreads() {
        return this.maxProcessorWorkerThread;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    ServerSocketFactory getServerSocketFactory() {
        return this.factory;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public int getSoLinger() {
        return this.linger;
    }

    public void setSoLinger(int i) {
        this.linger = i;
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public void setSoTimeout(int i) {
        this.socketTimeout = i;
    }

    public int getServerSoTimeout() {
        return this.serverTimeout;
    }

    public void setServerSoTimeout(int i) {
        this.serverTimeout = i;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation;
    }

    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket acceptSocket() {
        if (!this.running || this.serverSocket == null) {
            return null;
        }
        Socket accepted = null;
        try {
            accepted = this.factory == null ? this.serverSocket.accept() : this.factory.acceptSocket(this.serverSocket);
            if (null == accepted) {
                logger.log(Level.WARNING, "selectorThread.");
            } else if (!this.running) {
                accepted.close();
                accepted = null;
            } else if (this.factory != null) {
                this.factory.initSocket(accepted);
            }
        }
        catch (InterruptedIOException iioe) {
        }
        catch (AccessControlException ace) {
            logger.log(Level.WARNING, "selectorThread.wrongPermission", new Object[]{this.serverSocket, ace});
        }
        catch (IOException e) {
            Object msg = null;
            if (this.running) {
                logger.log(Level.SEVERE, "selectorThread.shutdownException", new Object[]{this.serverSocket, e});
            }
            if (accepted != null) {
                try {
                    accepted.close();
                }
                catch (Throwable ex) {
                    logger.log(Level.SEVERE, "selectorThread.shutdownException", new Object[]{this.serverSocket, ex});
                }
                accepted = null;
            }
            if (!this.running) {
                return null;
            }
            this.reinitializing = true;
            SelectorThread selectorThread = this;
            synchronized (selectorThread) {
                if (this.reinitializing) {
                    this.reinitializing = false;
                    this.closeServerSocket();
                    this.initialized = false;
                    try {
                        logger.log(Level.WARNING, "selectorThread.reinit");
                        this.initEndpoint();
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, "selectorThread.nonfatal", t);
                    }
                    if (!this.initialized) {
                        logger.log(Level.WARNING, "selectorThread.restart");
                        try {
                            this.stopEndpoint();
                            this.initEndpoint();
                            this.startEndpoint();
                        }
                        catch (Throwable t) {
                            logger.log(Level.SEVERE, "selectorThread.nonfatal", t);
                        }
                    }
                }
            }
        }
        return accepted;
    }

    protected void setSocketOptions(Socket socket) throws SocketException {
        if (this.linger >= 0) {
            socket.setSoLinger(true, this.linger);
        }
        if (this.tcpNoDelay) {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        if (this.socketTimeout > 0) {
            socket.setSoTimeout(this.socketTimeout);
        }
        socket.setReuseAddress(true);
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (isMonitoringEnabled) {
            this.registerComponents();
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    private void registerComponents() {
        if (this.domain != null) {
            try {
                this.processorPipelineName = new ObjectName(this.domain + ":" + "type=ThreadPool,name=http" + this.port);
                Registry.getRegistry().registerComponent((Object)this.processorPipeline, this.processorPipelineName, null);
                this.globalRequestProcessorName = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=http" + this.port);
                Registry.getRegistry().registerComponent((Object)this.globalRequestProcessor, this.globalRequestProcessorName, null);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "selectorThread.mbeanRegistrationException", new Object[]{new Integer(this.port), ex});
            }
        }
    }

    private void unregisterComponents() {
        if (this.domain != null && this.processorPipelineName != null && this.globalRequestProcessorName != null) {
            try {
                Registry.getRegistry().unregisterComponent(this.processorPipelineName);
                Registry.getRegistry().unregisterComponent(this.globalRequestProcessorName);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "mbeanDeregistrationException", new Object[]{new Integer(this.port), ex});
            }
        }
    }

    public void registerMonitoringLevelEvents() {
        MonitoringRegistry monitoringRegistry = WebContainer.getInstance().getServerContext().getMonitoringRegistry();
        monitoringRegistry.registerMonitoringLevelListener((MonitoringLevelListener)this, MonitoredObjectType.HTTP_LISTENER);
    }

    public void unregisterMonitoringLevelEvents() {
        MonitoringRegistry monitoringRegistry = WebContainer.getInstance().getServerContext().getMonitoringRegistry();
        monitoringRegistry.unregisterMonitoringLevelListener((MonitoringLevelListener)this);
    }

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (MonitoredObjectType.HTTP_LISTENER.equals(type)) {
            if (MonitoringLevel.OFF.equals((Object)to)) {
                isMonitoringEnabled = false;
                this.unregisterComponents();
            } else {
                isMonitoringEnabled = true;
                this.registerComponents();
            }
        }
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    private void initMonitoringLevel() {
        try {
            ModuleMonitoringLevels levels;
            Config cfg = ServerBeansFactory.getConfigBean(WebContainer.getInstance().getServerContext().getConfigContext());
            MonitoringLevel monitoringLevel = MonitoringLevel.OFF;
            if (cfg.getMonitoringService() != null && (levels = cfg.getMonitoringService().getModuleMonitoringLevels()) != null) {
                monitoringLevel = MonitoringLevel.instance((String)levels.getHttpService());
            }
            isMonitoringEnabled = !MonitoringLevel.OFF.equals((Object)monitoringLevel);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "selectorThread.initMonitoringException", new Object[]{new Integer(this.port), ex});
        }
    }

    public int getMaxHttpHeaderSize() {
        return maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        SelectorThread.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setMinThreads(int minWorkerThreads) {
        this.minWorkerThreads = minWorkerThreads;
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    private class SocketChannelAndOp {
        public SocketChannel channel;
        public int Op;
        public Task task;

        public SocketChannelAndOp(SocketChannel channel, int Op, Task task) {
            this.channel = channel;
            this.Op = Op;
            this.task = task;
        }
    }

    private class KeyAndOp {
        public SelectionKey key;
        public int Op;

        public KeyAndOp(SelectionKey skey, int Op) {
            this.key = skey;
            this.Op = Op;
        }
    }
}

