/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.enterprise.web.connector.grizzly.NonBlockingPipedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;

public class NonBlockingPipedInputStream
extends InputStream {
    boolean closedByWriter = false;
    volatile boolean closedByReader = false;
    boolean connected = false;
    Thread readSide;
    Thread writeSide;
    protected int keepAlive = -1;
    protected static final int PIPE_SIZE;
    protected byte[] buffer;
    protected int in = -1;
    protected int out = 0;
    private static final String PIPED_TIMEOUT = "com.sun.enterprise.web.connector.grizzly.pipedinputstreamtimeout";
    private static int timeout;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NonBlockingPipedInputStream(NonBlockingPipedOutputStream src) throws IOException {
        this.connect(src);
        this.buffer = new byte[PIPE_SIZE];
    }

    public NonBlockingPipedInputStream() {
        this.buffer = new byte[PIPE_SIZE];
    }

    public void connect(NonBlockingPipedOutputStream src) throws IOException {
        src.connect(this);
    }

    protected synchronized void receive(int b) throws IOException {
        this.checkStateForReceive();
        this.writeSide = Thread.currentThread();
        if (this.in == this.out) {
            this.awaitSpace();
        }
        if (this.in < 0) {
            this.in = 0;
            this.out = 0;
        }
        this.buffer[this.in++] = (byte)(b & 0xFF);
        if (this.in >= this.buffer.length) {
            this.in = 0;
        }
    }

    synchronized void receive(byte[] b, int off, int len) throws IOException {
        this.checkStateForReceive();
        this.writeSide = Thread.currentThread();
        int bytesToTransfer = len;
        while (bytesToTransfer > 0) {
            if (this.in == this.out) {
                this.awaitSpace();
            }
            int nextTransferAmount = 0;
            if (this.out < this.in) {
                nextTransferAmount = this.buffer.length - this.in;
            } else if (this.in < this.out) {
                if (this.in == -1) {
                    this.out = 0;
                    this.in = 0;
                    nextTransferAmount = this.buffer.length - this.in;
                } else {
                    nextTransferAmount = this.out - this.in;
                }
            }
            if (nextTransferAmount > bytesToTransfer) {
                nextTransferAmount = bytesToTransfer;
            }
            if (!$assertionsDisabled && nextTransferAmount <= 0) {
                throw new AssertionError();
            }
            System.arraycopy(b, off, this.buffer, this.in, nextTransferAmount);
            bytesToTransfer -= nextTransferAmount;
            off += nextTransferAmount;
            this.in += nextTransferAmount;
            if (this.in < this.buffer.length) continue;
            this.in = 0;
        }
    }

    synchronized void receive(ByteBuffer byteBuffer, int bytesToTransfer) throws IOException {
        this.checkStateForReceive();
        this.writeSide = Thread.currentThread();
        while (bytesToTransfer > 0) {
            if (this.in == this.out) {
                this.awaitSpace();
            }
            int nextTransferAmount = 0;
            if (this.out < this.in) {
                nextTransferAmount = this.buffer.length - this.in;
            } else if (this.in < this.out) {
                if (this.in == -1) {
                    this.out = 0;
                    this.in = 0;
                    nextTransferAmount = this.buffer.length - this.in;
                } else {
                    nextTransferAmount = this.out - this.in;
                }
            }
            if (nextTransferAmount > bytesToTransfer) {
                nextTransferAmount = bytesToTransfer;
            }
            byteBuffer.get(this.buffer, this.in, nextTransferAmount);
            bytesToTransfer -= nextTransferAmount;
            this.in += nextTransferAmount;
            if (this.in < this.buffer.length) continue;
            this.in = 0;
        }
    }

    private void checkStateForReceive() throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByWriter || this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (this.readSide != null && !this.readSide.isAlive()) {
            throw new IOException("Read end dead");
        }
    }

    private void awaitSpace() throws IOException {
        while (this.in == this.out) {
            if (this.readSide != null && !this.readSide.isAlive()) {
                throw new IOException("Pipe broken");
            }
            this.notifyAll();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
        }
    }

    synchronized void receivedLast() {
        this.closedByWriter = true;
        this.notifyAll();
    }

    public synchronized int read() throws IOException {
        boolean useKeepAlive;
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (this.writeSide != null && !this.writeSide.isAlive() && !this.closedByWriter && this.in < 0) {
            throw new IOException("Write end dead");
        }
        this.readSide = Thread.currentThread();
        int trials = 2;
        int count = 0;
        boolean bl = useKeepAlive = this.keepAlive >= 0;
        while (this.in < 0) {
            if (useKeepAlive && count > this.keepAlive) {
                throw new KeepAliveExpired("KeepAlive expired after: " + this.keepAlive);
            }
            ++count;
            if (this.closedByWriter) {
                return -1;
            }
            if (this.writeSide != null && !this.writeSide.isAlive() && --trials < 0) {
                throw new IOException("Pipe broken");
            }
            this.notifyAll();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
        }
        int ret = this.buffer[this.out++] & 0xFF;
        if (this.out >= this.buffer.length) {
            this.out = 0;
        }
        if (this.in == this.out) {
            this.in = -1;
        }
        return ret;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c < 0) {
            return -1;
        }
        b[off] = (byte)c;
        int rlen = 1;
        while (this.in >= 0 && --len > 0) {
            b[off + rlen] = this.buffer[this.out++];
            ++rlen;
            if (this.out >= this.buffer.length) {
                this.out = 0;
            }
            if (this.in != this.out) continue;
            this.in = -1;
        }
        return rlen;
    }

    public synchronized int available() throws IOException {
        if (this.in < 0) {
            return 0;
        }
        if (this.in == this.out) {
            return this.buffer.length;
        }
        if (this.in > this.out) {
            return this.in - this.out;
        }
        return this.in + this.buffer.length - this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.closedByReader = true;
        NonBlockingPipedInputStream nonBlockingPipedInputStream = this;
        synchronized (nonBlockingPipedInputStream) {
            this.in = -1;
        }
        this.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        this.closedByWriter = false;
        this.closedByReader = false;
        this.readSide = null;
        this.writeSide = null;
        NonBlockingPipedInputStream nonBlockingPipedInputStream = this;
        synchronized (nonBlockingPipedInputStream) {
            this.in = -1;
            this.out = 0;
        }
        this.buffer = new byte[PIPE_SIZE];
        this.keepAlive = -1;
    }

    public void setMaxKeepAlive(int keepAlive) {
        this.keepAlive = keepAlive;
    }

    static {
        $assertionsDisabled = !NonBlockingPipedInputStream.class.desiredAssertionStatus();
        PIPE_SIZE = 16 * Constants.CHANNEL_BYTE_SIZE;
        timeout = 190;
        if (System.getProperty(PIPED_TIMEOUT) != null) {
            timeout = Integer.parseInt(System.getProperty(PIPED_TIMEOUT));
        }
    }

    public class KeepAliveExpired
    extends RuntimeException {
        public KeepAliveExpired(String message) {
            super(message);
        }
    }
}

