/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.web.cache.CacheManager;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.util.logging.IASLevel;
import com.sun.enterprise.web.CacheModule;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;

final class WebModuleListener
implements LifecycleListener {
    private static Logger _logger;
    private static boolean _debugLog;
    private String instanceClassPath;

    public WebModuleListener(String instanceClassPath) {
        this.instanceClassPath = instanceClassPath;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        WebModule webModule;
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _debugLog = _logger.isLoggable(Level.FINE);
        }
        try {
            webModule = (WebModule)event.getLifecycle();
        }
        catch (ClassCastException e) {
            _logger.log(Level.WARNING, "webmodule.listener.classcastException", event.getLifecycle());
            return;
        }
        if (event.getType().equals("start")) {
            this.configureJspParameters(webModule);
            this.startCacheManager(webModule);
        } else if (event.getType().equals("stop")) {
            this.stopCacheManager(webModule);
        }
    }

    private void configureJspParameters(WebModule webModule) {
        SunWebApp bean = webModule.getIasWebAppConfigBean();
        String name = webModule.findServletMapping("*.jsp");
        Wrapper wrapper = (Wrapper)webModule.findChild(name);
        if (wrapper == null) {
            return;
        }
        String servletClass = wrapper.getServletClass();
        if (servletClass != null && (servletClass.equals("org.apache.jasper.servlet.JspServlet") || servletClass.equals("com.sun.enterprise.web.jsp.JspServlet"))) {
            if (bean != null && bean.getJspConfig() != null) {
                WebProperty[] props = bean.getJspConfig().getWebProperty();
                for (int i = 0; i < props.length; ++i) {
                    String pname = props[i].getAttributeValue("name");
                    String pvalue = props[i].getAttributeValue("value");
                    if (_debugLog) {
                        _logger.fine("jsp-config property for [" + webModule.getID() + "] is [" + pname + "] = [" + pvalue + "]");
                    }
                    if ("reload-interval".equals(pname)) {
                        int reloadInterval = -1;
                        try {
                            reloadInterval = Integer.parseInt(pvalue);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (reloadInterval == -1) {
                            wrapper.addInitParameter("development", "false");
                            wrapper.addInitParameter("checkInterval", "0");
                            continue;
                        }
                        wrapper.addInitParameter("checkInterval", pvalue);
                        wrapper.addInitParameter("modificationTestInterval", pvalue);
                        continue;
                    }
                    wrapper.addInitParameter(pname, pvalue);
                }
            }
            wrapper.addInitParameter("logVerbosityLevel", this.getJasperLogLevel());
            String sysClassPath = System.getProperty("java.class.path");
            if (this.instanceClassPath != null && this.instanceClassPath.length() > 0) {
                sysClassPath = sysClassPath + this.instanceClassPath;
            }
            wrapper.addInitParameter("com.sun.appserv.jsp.classpath", sysClassPath);
        }
    }

    private String getJasperLogLevel() {
        Level level = _logger.getLevel();
        if (level.equals(IASLevel.FATAL)) {
            return "fatal";
        }
        if (level.equals(Level.WARNING)) {
            return "warning";
        }
        if (level.equals(Level.FINE)) {
            return "information";
        }
        if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            return "debug";
        }
        return "warning";
    }

    private void startCacheManager(WebModule webModule) {
        SunWebApp bean = webModule.getIasWebAppConfigBean();
        if (bean != null) {
            CacheManager cm = null;
            try {
                cm = CacheModule.configureResponseCache(webModule, bean);
            }
            catch (Exception ee) {
                _logger.log(Level.WARNING, "webmodule.listener.cachemgrException", ee);
            }
            if (cm != null) {
                try {
                    cm.start();
                    if (_debugLog) {
                        _logger.fine("Cache Manager started");
                    }
                    ServletContext ctxt = webModule.getServletContext();
                    ctxt.setAttribute("com.sun.appserv.web.CacheManager", (Object)cm);
                }
                catch (LifecycleException ee) {
                    _logger.log(Level.WARNING, ee.getMessage(), ee.getThrowable());
                }
            }
        }
    }

    private void stopCacheManager(WebModule webModule) {
        ServletContext ctxt = webModule.getServletContext();
        CacheManager cm = (CacheManager)ctxt.getAttribute("com.sun.appserv.web.CacheManager");
        if (cm != null) {
            try {
                cm.stop();
                if (_debugLog) {
                    _logger.fine("Cache Manager stopped");
                }
                ctxt.removeAttribute("com.sun.appserv.web.CacheManager");
            }
            catch (LifecycleException ee) {
                _logger.log(Level.WARNING, ee.getMessage(), ee.getThrowable());
            }
        }
    }
}

