/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.runtime.web.LocaleCharsetInfo;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetMap;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.web.PwcWebModule;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;

public class WebModule
extends PwcWebModule {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private SunWebApp iasBean = null;
    private LocaleCharsetMap[] _lcMap = null;
    private boolean hasBeenXmlConfigured = false;
    private WebContainer webContainer;
    protected Object[] cachedFinds;

    public WebModule(WebContainer webContainer) {
        this.webContainer = webContainer;
    }

    public void setIasWebAppConfigBean(SunWebApp iasBean) {
        this.iasBean = iasBean;
    }

    public SunWebApp getIasWebAppConfigBean() {
        return this.iasBean;
    }

    public void setI18nInfo() {
        LocaleCharsetInfo lcinfo;
        if (this.iasBean == null) {
            return;
        }
        if (this.iasBean.isParameterEncoding()) {
            this.formHintField = this.iasBean.getAttributeValue("ParameterEncoding", "FormHintField");
            this.defaultCharset = this.iasBean.getAttributeValue("ParameterEncoding", "DefaultCharset");
        }
        if ((lcinfo = this.iasBean.getLocaleCharsetInfo()) != null) {
            if (lcinfo.getAttributeValue("DefaultLocale") != null) {
                logger.warning("webmodule.default_locale_deprecated");
            }
            if (lcinfo.isParameterEncoding() && !this.iasBean.isParameterEncoding()) {
                this.formHintField = lcinfo.getAttributeValue("ParameterEncoding", "FormHintField");
                this.defaultCharset = lcinfo.getAttributeValue("ParameterEncoding", "DefaultCharset");
            }
            this._lcMap = lcinfo.getLocaleCharsetMap();
        }
    }

    public LocaleCharsetMap[] getLocaleCharsetMap() {
        return this._lcMap;
    }

    public boolean hasLocaleToCharsetMapping() {
        LocaleCharsetMap[] locCharsetMap = this.getLocaleCharsetMap();
        return locCharsetMap != null && locCharsetMap.length > 0;
    }

    public String mapLocalesToCharset(Enumeration locales) {
        String encoding = null;
        LocaleCharsetMap[] locCharsetMap = this.getLocaleCharsetMap();
        if (locCharsetMap != null && locCharsetMap.length > 0) {
            boolean matchFound = false;
            while (locales.hasMoreElements() && !matchFound) {
                Locale reqLoc = (Locale)locales.nextElement();
                for (int i = 0; i < locCharsetMap.length && !matchFound; ++i) {
                    String language = locCharsetMap[i].getAttributeValue("Locale");
                    if (language == null || language.equals("")) continue;
                    String country = null;
                    int index = language.indexOf(95);
                    if (index != -1) {
                        country = language.substring(index + 1);
                        language = language.substring(0, index);
                    }
                    Locale mapLoc = null;
                    mapLoc = country != null ? new Locale(language, country) : new Locale(language);
                    if (!mapLoc.equals(reqLoc)) continue;
                    encoding = locCharsetMap[i].getAttributeValue("Charset");
                    matchFound = true;
                }
            }
        }
        return encoding;
    }

    public void setXmlConfigured(boolean hasBeenXmlConfigured) {
        this.hasBeenXmlConfigured = hasBeenXmlConfigured;
    }

    public boolean hasBeenXmlConfigured() {
        return this.hasBeenXmlConfigured;
    }

    public void setCachedFindOperation(Object[] cachedFinds) {
        this.cachedFinds = cachedFinds;
    }

    public Object[] getCachedFindOperation() {
        return this.cachedFinds;
    }

    public synchronized void start() throws LifecycleException {
        super.start();
        this.webContainer.enableMonitoring(this, ((VirtualServer)this.getParent()).getID());
    }
}

