/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Connector;
import org.apache.catalina.Host;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.tomcat5.CoyoteConnector;

public class VirtualServerValve
extends ValveBase {
    private ArrayList disabledConnectors = new ArrayList();
    private ArrayList disabledVirtualServer = new ArrayList();
    protected static Logger logger = null;
    private static final String _FINE = "com.sun.enterprise.web.VirtualServerValve/1.0";
    private ArrayList offVirtualHosts = new ArrayList();
    private String recycledMessage;
    protected static final StringManager sm = StringManager.getManager("com.sun.enterprise.web");

    public VirtualServerValve() {
        if (logger == null) {
            logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        }
    }

    public void addDisabledConnector(Connector connector) {
        this.disabledConnectors.add(connector);
    }

    public void addDisabledVirtualHost(String virtualHostName) {
        this.disabledVirtualServer.add(virtualHostName);
    }

    public boolean removeDisabledVirtualHost(String virtualHostName) {
        return this.disabledVirtualServer.remove(virtualHostName);
    }

    public void addOffVirtualHost(String virtualHostName) {
        this.offVirtualHosts.add(virtualHostName);
    }

    public boolean removeOffVirtualHost(String virtualHostName) {
        return this.offVirtualHosts.remove(virtualHostName);
    }

    public boolean isVsInOffList(String vsName) {
        return this.offVirtualHosts.contains(vsName);
    }

    public boolean isVsInDisabledList(String vsName) {
        return this.disabledVirtualServer.contains(vsName);
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        Connector connector = request.getConnector();
        if (this.disabledConnectors.contains(connector)) {
            this.recycledMessage = this.transform(String.valueOf(((CoyoteConnector)connector).getPort()), "virtualServerValve.listenerOff");
            logger.log(Level.FINE, this.recycledMessage);
            ((HttpServletResponse)response.getResponse()).sendError(404, this.recycledMessage);
            return 2;
        }
        Host host = request.getHost();
        String mappedHost = host.getName();
        if (this.offVirtualHosts.contains(mappedHost)) {
            this.recycledMessage = this.transform(mappedHost, "virtualServerValve.vsOff");
            logger.log(Level.FINE, this.recycledMessage);
            ((HttpServletResponse)response.getResponse()).sendError(404, this.recycledMessage);
            return 2;
        }
        if (this.disabledVirtualServer.contains(mappedHost)) {
            this.recycledMessage = this.transform(mappedHost, "virtualServerValve.vsDisabled");
            logger.log(Level.FINE, this.recycledMessage);
            ((HttpServletResponse)response.getResponse()).sendError(403, this.recycledMessage);
            return 2;
        }
        return 1;
    }

    private String transform(String message, String messageID) {
        return sm.getString(messageID, message);
    }
}

