/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cache.test;

import com.sun.enterprise.util.cache.ConcurrentCache;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConcurrentCacheTest {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private String[] keys;
    private int maxKeys;
    private int maxLoop;

    public ConcurrentCacheTest(int maxKeys, int maxLoop) {
        this.maxKeys = maxKeys;
        this.maxLoop = maxLoop;
        this.keys = new String[maxKeys];
        for (int i = 0; i < maxKeys; ++i) {
            this.keys[i] = "" + i;
        }
    }

    public void testConcurrentCache() {
        int maxBuckets = 0;
        maxBuckets = this.maxKeys * 100 / 89;
        ConcurrentCache cache = new ConcurrentCache(maxBuckets);
        for (int i = 0; i < this.maxKeys; ++i) {
            cache.putEntry(this.keys[i], this.keys[i]);
        }
        long t1 = 0L;
        long t2 = 0L;
        double sum = 0.0;
        for (int j = 0; j < this.maxLoop; ++j) {
            t1 = System.currentTimeMillis();
            for (int i = 0; i < this.maxKeys; ++i) {
                String key = this.keys[i];
                if (cache.getEntry(key).equals(key)) continue;
                _logger.log(Level.WARNING, "iplanet_util.lookup_fail", key);
            }
            t2 = System.currentTimeMillis();
            _logger.log(Level.FINE, "ConcurrentMap lookup took: " + (double)(t2 - t1) / 1000.0 + " seconds.");
            sum += (double)(t2 - t1);
        }
        _logger.log(Level.FINE, "Average ConcurrentCache lookup took: " + sum / (double)this.maxLoop / 1000.0 + " seconds.");
        cache = null;
    }

    public static void main(String[] args) {
        ConcurrentCacheTest test = new ConcurrentCacheTest(200000, 10);
        test.testConcurrentCache();
    }
}

