/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.Orb;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.config.serverbeans.SslClientConfig;
import com.sun.enterprise.iiop.FailoverIORInterceptor;
import com.sun.enterprise.iiop.IIOPPrimaryToContactInfoImpl;
import com.sun.enterprise.iiop.PEORBConfigurator;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;

public final class ORBManager {
    static Logger _logger;
    private static final boolean debug = true;
    private static final String orbClass = "com.sun.corba.ee.impl.orb.ORBImpl";
    private static final String orbSingletonClass = "com.sun.corba.ee.impl.orb.ORBSingleton";
    private static final String peorbConfigClass = "com.sun.enterprise.iiop.PEORBConfigurator";
    public static final String OMG_ORB_CLASS_PROPERTY = "org.omg.CORBA.ORBClass";
    public static final String OMG_ORB_SINGLETON_CLASS_PROPERTY = "org.omg.CORBA.ORBSingletonClass";
    public static final String SUN_PEORB_CONFIGURATOR_CLASS_PROPERTY = "com.sun.CORBA.ORBUserConfigurators";
    public static final String SUN_ORB_ID_PROPERTY = "com.sun.CORBA.ORBid";
    public static final String ORB_UTIL_CLASS_PROPERTY = "javax.rmi.CORBA.UtilClass";
    public static final String JNDI_PROVIDER_URL_PROPERTY = "java.naming.provider.url";
    public static final String JNDI_CORBA_ORB_PROPERTY = "java.naming.corba.orb";
    public static final String OMG_ORB_INIT_HOST_PROPERTY = "org.omg.CORBA.ORBInitialHost";
    public static final String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    public static final String SUN_ORB_SERVER_HOST_PROPERTY = "com.sun.CORBA.ORBServerHost";
    public static final String SUN_ORB_SERVER_PORT_PROPERTY = "com.sun.CORBA.ORBServerPort";
    public static final String RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.StubClass";
    public static final String RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.PortableRemoteObjectClass";
    public static final String SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY = "com.sun.CORBA.transport.ORBSocketFactoryClass";
    public static final String SUN_ORB_IOR_TO_SOCKETINFO_CLASS_PROPERTY = "com.sun.CORBA.transport.ORBIORToSocketInfoClass";
    public static final String SUN_ORB_JTS_CLASS_PROPERTY = "com.sun.corba.ee.CosTransactions.ORBJTSClass";
    public static final String SUN_MAX_CONNECTIONS_PROPERTY = "com.sun.CORBA.connection.ORBHighWaterMark";
    public static final String DEFAULT_MAX_CONNECTIONS = "1024";
    private static final String J2EE_INITIALIZER = "com.sun.enterprise.iiop.J2EEInitializer";
    private static final String PI_ORB_INITIALIZER_CLASS_PREFIX = "org.omg.PortableInterceptor.ORBInitializerClass.";
    public static final String ORB_LISTEN_SOCKET_PROPERTY = "com.sun.CORBA.transport.ORBListenSocket";
    private static final String IIOP_CLEAR_TEXT_CONNECTION = "IIOP_CLEAR_TEXT";
    public static final String ORB_DISABLED_PORTS_PROPERTY = "com.sun.CORBA.connection.ORBDisabledListenPorts";
    private static final String SSL = "SSL";
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String ORB_SSL_CERTDB_PATH = "com.sun.CSIV2.ssl.CertDB";
    private static final String ORB_SSL_CERTDB_PASSWORD = "com.sun.CSIV2.ssl.CertDBPassword";
    public static final String SUN_GIOP_FRAGMENT_SIZE_PROPERTY = "com.sun.CORBA.giop.ORBFragmentSize";
    public static final String SUN_GIOP_BUFFER_SIZE_PROPERTY = "com.sun.CORBA.giop.ORBBufferSize";
    private static final String SUN_GIOP_DEFAULT_FRAGMENT_SIZE = "1024";
    private static final String SUN_GIOP_DEFAULT_BUFFER_SIZE = "1024";
    public static final String ORB_SSL_CLIENT_REQUIRED = "com.sun.CSIV2.ssl.client.required";
    public static final String ORB_SSL_SERVER_REQUIRED = "com.sun.CSIV2.ssl.server.required";
    public static final String ORB_CLIENT_AUTH_REQUIRED = "com.sun.CSIV2.client.auth.required";
    private static final String DEFAULT_ORB_INIT_HOST = "localhost";
    private static final String DEFAULT_ORB_INIT_PORT = "3700";
    private static final String CONFIG_DIR = "config";
    private static final String J2EE_ORB_CONFIG_FILE_NAME = "orb.properties";
    private static final String J2EE_ORB_CONFIG_PORT_NAME = "port";
    private static final String J2EE_ORB_CONFIG_HOST_NAME = "host";
    private static final String NATIVE_LIB_DIR = "nativelib";
    private static final String S1AS_ORB_ID = "S1AS-ORB";
    private static ORB orb;
    private static Properties orbInitializationProperties;
    private static int orbInitialPort;
    private static boolean librariesLoaded;
    private static IiopListener[] iiopListenerBeans;
    private static Orb orbBean;
    private static IiopService iiopServiceBean;
    private static final String SUN_LISTEN_ADDR_ANY_ADDRESS = "com.sun.CORBA.orb.AddrAnyAddress";
    private static final String ORB_IOR_ADDR_ANY_INITIALIZER = "com.sun.enterprise.iiop.IORAddrAnyInitializer";
    private static Properties csiv2Props;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ORBManager() {
    }

    public static synchronized void init(String[] args, Properties props) {
        if (orb != null) {
            return;
        }
        try {
            ServerContext serverContext = ApplicationServer.getServerContext();
            ConfigContext configContext = serverContext.getConfigContext();
            if (!$assertionsDisabled && configContext == null) {
                throw new AssertionError();
            }
            Server serverBean = ServerBeansFactory.getServerBean(configContext);
            if (!$assertionsDisabled && serverBean == null) {
                throw new AssertionError();
            }
            iiopServiceBean = ServerBeansFactory.getIiopServiceBean(configContext);
            if (!$assertionsDisabled && iiopServiceBean == null) {
                throw new AssertionError();
            }
            iiopListenerBeans = iiopServiceBean.getIiopListener();
            if (!($assertionsDisabled || iiopListenerBeans != null && iiopListenerBeans.length > 0)) {
                throw new AssertionError();
            }
            orbBean = iiopServiceBean.getOrb();
            if (!$assertionsDisabled && orbBean == null) {
                throw new AssertionError();
            }
            csiv2Props.put(ORB_CLIENT_AUTH_REQUIRED, String.valueOf(iiopServiceBean.isClientAuthenticationRequired()));
            boolean corbaSSLRequired = true;
            for (int i = 0; i < iiopListenerBeans.length; ++i) {
                if (iiopListenerBeans[i].getSsl() != null) continue;
                corbaSSLRequired = false;
                break;
            }
            csiv2Props.put(ORB_SSL_SERVER_REQUIRED, String.valueOf(corbaSSLRequired));
        }
        catch (ConfigException cfe) {
            _logger.log(Level.SEVERE, "enterprise_util.orbmgr_config_excep", cfe);
        }
        catch (NullPointerException npe) {
            _logger.log(Level.FINE, "Server Context is NULL. Ignoring and proceeding.");
        }
        ORBManager.createORB(args, props);
    }

    public static Properties getCSIv2Props() {
        return csiv2Props;
    }

    public static ORB getORB() {
        if (orb == null) {
            ORBManager.init(null, null);
        }
        return orb;
    }

    public static synchronized void setORB(ORB theORB) {
        if (orb == null) {
            orb = theORB;
        }
    }

    public static int getORBInitialPort() {
        if (orbInitialPort == -1) {
            ORBManager.checkORBInitialPort(new Properties());
        }
        return orbInitialPort;
    }

    private static synchronized void createORB(String[] args, Properties props) {
        Properties orbInitProperties = new Properties();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getProperty(ORBManager.ORB_UTIL_CLASS_PROPERTY) == null) {
                    System.setProperty(ORBManager.ORB_UTIL_CLASS_PROPERTY, "com.sun.corba.ee.impl.javax.rmi.CORBA.Util");
                }
                if (System.getProperty(ORBManager.RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY) == null) {
                    System.setProperty(ORBManager.RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY, "com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl");
                }
                if (System.getProperty(ORBManager.RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY) == null) {
                    System.setProperty(ORBManager.RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY, "com.sun.corba.ee.impl.javax.rmi.PortableRemoteObject");
                }
                return null;
            }
        });
        try {
            if (props == null) {
                orbInitProperties.put(SUN_ORB_JTS_CLASS_PROPERTY, "com.sun.jts.CosTransactions.DefaultTransactionService");
            } else {
                orbInitProperties.putAll((Map<?, ?>)props);
            }
            orbInitProperties.put("com.sun.CORBA.ORBUserConfigurators.com.sun.enterprise.iiop.PEORBConfigurator", "");
            orbInitProperties.put(SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY, "com.sun.enterprise.iiop.IIOPSSLSocketFactory");
            orbInitProperties.put(SUN_ORB_IOR_TO_SOCKETINFO_CLASS_PROPERTY, "com.sun.enterprise.iiop.IORToSocketInfoImpl");
            orbInitProperties.put("com.sun.CORBA.transport.ORBIIOPPrimaryToContactInfoClass", IIOPPrimaryToContactInfoImpl.class.getName());
            orbInitProperties.put(PI_ORB_INITIALIZER_CLASS_PREFIX + FailoverIORInterceptor.class.getName(), "dummy");
            orbInitProperties.put(ORB_UTIL_CLASS_PROPERTY, "com.sun.corba.ee.impl.javax.rmi.CORBA.Util");
            orbInitProperties.put(RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY, "com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl");
            orbInitProperties.put(RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY, "com.sun.corba.ee.impl.javax.rmi.PortableRemoteObject");
            orbInitProperties.put("org.omg.PortableInterceptor.ORBInitializerClass.com.sun.enterprise.iiop.J2EEInitializer", "");
            orbInitProperties.put("com.sun.CORBA.ORBAllowLocalOptimization", "true");
            orbInitProperties.put(OMG_ORB_CLASS_PROPERTY, orbClass);
            orbInitProperties.put(OMG_ORB_SINGLETON_CLASS_PROPERTY, orbSingletonClass);
            orbInitProperties.put(SUN_ORB_ID_PROPERTY, S1AS_ORB_ID);
            orbInitProperties.put("com.sun.CORBA.ORBShowInfoMessages", "true");
            String initialPort = ORBManager.checkORBInitialPort(orbInitProperties);
            String orbInitialHost = ORBManager.checkORBInitialHost(orbInitProperties);
            args = ORBManager.addORBInitRef(args, orbInitialHost, initialPort);
            ORBManager.checkAdditionalORBListeners(orbInitProperties);
            ORBManager.checkConnectionSettings(orbInitProperties);
            ORBManager.checkMessageFragmentSize(orbInitProperties);
            ORBManager.checkServerSSLOutboundSettings(orbInitProperties);
            ORBManager.checkForOrbPropertyValues(orbInitProperties);
            if (Switch.getSwitch().getContainerType() == 2) {
                PEORBConfigurator.setThreadPoolManager();
            }
            orbInitializationProperties = orbInitProperties;
            orb = ORB.init(args, orbInitProperties);
            ((com.sun.corba.ee.spi.orb.ORB)((Object)orb)).getFVDCodeBaseIOR();
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise_util.excep_in_createorb", ex);
        }
    }

    private static String checkForAddrAny(Properties props, String orbInitialHost) {
        if (orbInitialHost.equals("0.0.0.0") || orbInitialHost.equals("::") || orbInitialHost.equals("::ffff:0.0.0.0")) {
            try {
                String localAddress = InetAddress.getLocalHost().getHostAddress();
                return localAddress;
            }
            catch (UnknownHostException uhe) {
                _logger.log(Level.WARNING, "Unknown host exception - Setting host to localhost");
                return DEFAULT_ORB_INIT_HOST;
            }
        }
        props.setProperty(SUN_ORB_SERVER_HOST_PROPERTY, orbInitialHost);
        return orbInitialHost;
    }

    private static String checkORBInitialHost(Properties props) {
        String orbInitialHost = System.getProperty(OMG_ORB_INIT_HOST_PROPERTY);
        if (orbInitialHost == null) {
            orbInitialHost = props.getProperty(OMG_ORB_INIT_HOST_PROPERTY);
        }
        if (orbInitialHost == null) {
            try {
                orbInitialHost = iiopListenerBeans[0].getAddress();
                orbInitialHost = ORBManager.checkForAddrAny(props, orbInitialHost);
            }
            catch (NullPointerException npe) {
                _logger.log(Level.FINE, "IIOP listener element is null. Ignoring and proceeding.");
            }
        }
        if (orbInitialHost == null) {
            orbInitialHost = DEFAULT_ORB_INIT_HOST;
        }
        props.setProperty(OMG_ORB_INIT_HOST_PROPERTY, orbInitialHost);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Setting orb initial host to " + orbInitialHost);
        }
        return orbInitialHost;
    }

    private static String checkORBInitialPort(Properties props) {
        String initialPort = System.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        if (initialPort == null) {
            initialPort = props.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        }
        if (initialPort == null) {
            try {
                initialPort = iiopListenerBeans[0].getPort();
                if (!iiopListenerBeans[0].isEnabled()) {
                    props.setProperty(ORB_DISABLED_PORTS_PROPERTY, initialPort);
                }
                if (!iiopListenerBeans[0].isEnabled()) {
                    props.setProperty(SUN_ORB_SERVER_PORT_PROPERTY, "-1");
                } else {
                    props.setProperty(SUN_ORB_SERVER_PORT_PROPERTY, initialPort);
                }
            }
            catch (NullPointerException npe) {
                _logger.log(Level.FINE, "IIOP listener element is null. Ignoring and proceeding.");
            }
        }
        if (initialPort == null) {
            initialPort = DEFAULT_ORB_INIT_PORT;
        }
        props.setProperty(OMG_ORB_INIT_PORT_PROPERTY, initialPort);
        if (Switch.getSwitch().getContainerType() == 2) {
            props.setProperty("com.sun.CORBA.POA.ORBPersistentServerPort", initialPort);
        }
        orbInitialPort = new Integer(initialPort);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Setting orb initial port to " + initialPort);
        }
        return initialPort;
    }

    private static void checkAdditionalORBListeners(Properties props) {
        if (iiopListenerBeans != null) {
            StringBuffer listenSockets = new StringBuffer("");
            for (int i = 0; i < iiopListenerBeans.length; ++i) {
                if (i == 0 && iiopListenerBeans[0].getSsl() == null || !iiopListenerBeans[i].isEnabled()) continue;
                if (!iiopListenerBeans[i].isSecurityEnabled() || iiopListenerBeans[i].getSsl() == null) {
                    ORBManager.checkForAddrAny(props, iiopListenerBeans[i].getAddress());
                    listenSockets.append((listenSockets.length() > 0 ? "," : "") + IIOP_CLEAR_TEXT_CONNECTION + ":" + iiopListenerBeans[i].getPort());
                    continue;
                }
                Ssl sslBean = null;
                sslBean = iiopListenerBeans[i].getSsl();
                if (!$assertionsDisabled && sslBean == null) {
                    throw new AssertionError();
                }
                boolean clientAuth = sslBean.isClientAuthEnabled();
                String type = clientAuth ? SSL_MUTUALAUTH : SSL;
                listenSockets.append((listenSockets.length() > 0 ? "," : "") + type + ":" + iiopListenerBeans[i].getPort());
            }
            props.setProperty(ORB_LISTEN_SOCKET_PROPERTY, listenSockets.toString());
        }
    }

    private static void checkConnectionSettings(Properties props) {
        if (orbBean != null) {
            String maxConnections;
            try {
                maxConnections = orbBean.getMaxConnections();
                Integer.parseInt(maxConnections);
            }
            catch (NumberFormatException nfe) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                }
                maxConnections = "1024";
            }
            props.setProperty(SUN_MAX_CONNECTIONS_PROPERTY, maxConnections);
        }
    }

    private static void checkMessageFragmentSize(Properties props) {
        if (orbBean != null) {
            String bufferSize;
            String fragmentSize;
            try {
                int fsize = Integer.parseInt(orbBean.getMessageFragmentSize().trim()) / 8 * 8;
                if (fsize < 32) {
                    fragmentSize = "32";
                    _logger.log(Level.INFO, "Setting ORB Message Fragment size to " + fragmentSize);
                } else {
                    fragmentSize = String.valueOf(fsize);
                }
                bufferSize = fragmentSize;
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "enterprise_util.excep_in_reading_fragment_size", nfe);
                _logger.log(Level.INFO, "Setting ORB Message Fragment size to Default 1024");
                fragmentSize = "1024";
                bufferSize = "1024";
            }
            props.setProperty(SUN_GIOP_FRAGMENT_SIZE_PROPERTY, fragmentSize);
            props.setProperty(SUN_GIOP_BUFFER_SIZE_PROPERTY, bufferSize);
        }
    }

    private static void checkServerSSLOutboundSettings(Properties props) {
        SslClientConfig sslClientConfigBean;
        if (iiopServiceBean != null && (sslClientConfigBean = iiopServiceBean.getSslClientConfig()) != null) {
            Ssl ssl = sslClientConfigBean.getSsl();
            if (!$assertionsDisabled && ssl == null) {
                throw new AssertionError();
            }
        }
    }

    private static void checkForOrbPropertyValues(Properties props) {
        ElementProperty[] ep;
        if (orbBean != null && ((ep = orbBean.getElementProperty()) != null || ep.length != 0)) {
            for (int i = 0; i < ep.length; ++i) {
                props.setProperty(ep[i].getName(), ep[i].getValue());
            }
        }
    }

    private static String[] addORBInitRef(String[] args, String orbInitialHost, String initialPort) {
        String[] newArgs;
        if (args == null) {
            newArgs = new String[2];
        } else {
            newArgs = new String[args.length + 2];
            for (int i = 0; i < args.length; ++i) {
                newArgs[i] = args[i];
            }
        }
        newArgs[i++] = "-ORBInitRef";
        newArgs[i++] = "NameService=corbaloc:iiop:1.2@" + orbInitialHost + ":" + initialPort + "/NameService";
        return newArgs;
    }

    public static Tie exportObject(Remote remote) throws RemoteException {
        PortableRemoteObject.exportObject(remote);
        Tie servantsTie = Util.getTie(remote);
        servantsTie.orb(ORBManager.getORB());
        return servantsTie;
    }

    public static Properties getAllORBProperties() {
        return orbInitializationProperties;
    }

    static {
        $assertionsDisabled = !ORBManager.class.desiredAssertionStatus();
        _logger = LogDomains.getLogger("javax.enterprise.system.util");
        orb = null;
        orbInitialPort = -1;
        librariesLoaded = false;
        iiopListenerBeans = null;
        orbBean = null;
        iiopServiceBean = null;
        csiv2Props = new Properties();
    }
}

