/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.Print;
import com.sun.enterprise.util.SimpleFilenameFilter;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class FileUtil {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static final boolean debug = true;
    private static final String JAR_FILE_NAME = "j2ee.jar";
    private static final String HOME_DIR_PROP = "com.sun.enterprise.home";
    private static final String DEFAULT_HOME_DIR = System.getProperty("user.dir");
    public static final char JAR_SEPARATOR_CHAR = '/';
    private static final long JAR_ENTRY_UNKNOWN_VALUE = -1L;
    private static final int BYTE_READ_ERROR = -1;
    private static String basedir = null;
    private static final boolean DeleteOnExit_ShutdownHook = true;
    private static Vector deleteOnExit_normal = null;
    private static Vector deleteOnExit_forced = null;

    public static File getTempDirectory() {
        String temp = System.getProperty("java.io.tmpdir");
        String home = System.getProperty("user.name");
        if (home == null) {
            home = "";
        }
        File tmp = null;
        tmp = temp == null ? new File(home, "tmp") : new File(temp, "j2ee-ri-" + home);
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        return tmp;
    }

    public static String getAbsolutePath(String relativePath) {
        if (FileUtil.isAbsolute(relativePath)) {
            return relativePath;
        }
        String rpath = relativePath.replace('/', File.separatorChar);
        if (basedir == null) {
            FileUtil.setBaseDir();
        }
        String path = basedir + File.separator + relativePath;
        return new File(path).getAbsolutePath();
    }

    private static void setBaseDir() {
        basedir = System.getProperty(HOME_DIR_PROP);
        if (basedir != null) {
            return;
        }
        basedir = DEFAULT_HOME_DIR;
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String filename = st.nextToken();
            if (!filename.endsWith(JAR_FILE_NAME)) continue;
            try {
                String parent = new File(filename).getAbsoluteFile().getParentFile().getParent();
                if (parent != null) {
                    basedir = parent;
                }
                return;
            }
            catch (NullPointerException ex) {
                return;
            }
        }
    }

    private static boolean isAbsolute(String fpath) {
        return new File(fpath).isAbsolute();
    }

    public static Set getAllFilesUnder(File directory, FilenameFilter filenameFilter) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        return FileUtil.getAllFilesUnder(directory, filenameFilter, true);
    }

    public static Set getAllFilesUnder(File directory, FilenameFilter filenameFilter, boolean relativize) throws IOException {
        TreeSet allFiles = new TreeSet();
        File relativizingDir = relativize ? directory : null;
        FileUtil.recursiveGetFilesUnder(relativizingDir, directory, filenameFilter, allFiles, false);
        return allFiles;
    }

    public static Set getAllFilesAndDirectoriesUnder(File directory) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        TreeSet allFiles = new TreeSet();
        FileUtil.recursiveGetFilesUnder(directory, directory, null, allFiles, true);
        return allFiles;
    }

    private static void recursiveGetFilesUnder(File relativizingRoot, File directory, FilenameFilter filenameFilter, Set set, boolean returnDirectories) {
        File[] files = directory.listFiles(filenameFilter);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileUtil.recursiveGetFilesUnder(relativizingRoot, files[i], filenameFilter, set, returnDirectories);
                if (!returnDirectories) continue;
                if (relativizingRoot != null) {
                    set.add(FileUtil.relativize(relativizingRoot, files[i]));
                    continue;
                }
                set.add(files[i]);
                continue;
            }
            if (relativizingRoot != null) {
                set.add(FileUtil.relativize(relativizingRoot, files[i]));
                continue;
            }
            set.add(files[i]);
        }
    }

    public static File relativize(File parent, File child) {
        String baseDir = parent.getAbsolutePath();
        String baseDirAndChild = child.getAbsolutePath();
        String relative = baseDirAndChild.substring(baseDir.length(), baseDirAndChild.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return new File(relative);
    }

    public static String classNameFromEntryName(String entryName) {
        String className = entryName;
        if (entryName.endsWith(".class")) {
            int dotClassIndex = entryName.indexOf(".class");
            className = entryName.substring(0, dotClassIndex);
            className = className.replace('/', '.');
        }
        return className;
    }

    public static String classNameFromFile(File file) {
        String className = file.toString();
        if (className.endsWith(".class")) {
            String contentFileStr = className.replace(File.separatorChar, '.');
            int cutOffPoint = contentFileStr.lastIndexOf(".class");
            className = contentFileStr.substring(0, cutOffPoint);
        }
        return className;
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        File parent = new File(destFile.getParent());
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileInputStream fis = new FileInputStream(sourceFile);
        FileChannel in = fis.getChannel();
        FileOutputStream fos = new FileOutputStream(destFile);
        FileChannel out = fos.getChannel();
        in.transferTo(0L, in.size(), out);
        in.close();
        out.close();
        fis.close();
        fos.close();
    }

    public static String[] parseFileList(String files) {
        Vector<String> fileNames = new Vector<String>();
        boolean checkDriveLetter = !File.pathSeparator.equals(":");
        StringTokenizer st = new StringTokenizer(files, ":");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (checkDriveLetter && name.length() == 1 && st.hasMoreTokens()) {
                name = name + ":" + st.nextToken();
            }
            fileNames.addElement(name);
        }
        int size = fileNames.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)fileNames.elementAt(i);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean jarEntriesEqual(File file1, String entry1Name, File file2, String entry2Name) throws IOException {
        JarFile jarFile2;
        boolean identical;
        block13: {
            identical = false;
            JarFile jarFile1 = null;
            jarFile2 = null;
            try {
                try {
                    jarFile1 = new JarFile(file1);
                    jarFile2 = new JarFile(file2);
                    String jarEntry1Name = entry1Name.replace(File.separatorChar, '/');
                    String jarEntry2Name = entry2Name.replace(File.separatorChar, '/');
                    JarEntry entry1 = jarFile1.getJarEntry(jarEntry1Name);
                    JarEntry entry2 = jarFile2.getJarEntry(jarEntry2Name);
                    if (entry1 == null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, file1 + ":" + entry1Name + " not found");
                        }
                    } else if (entry2 == null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, file2 + ":" + entry2Name + " not found");
                        }
                    } else {
                        identical = FileUtil.jarEntriesEqual(jarFile1, entry1, jarFile2, entry2);
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Are " + entry1Name + " and " + entry2Name + " identical? " + (identical ? "YES" : "NO"));
                    }
                }
                catch (IOException e) {
                    if (!_logger.isLoggable(Level.WARNING)) throw e;
                    _logger.log(Level.WARNING, "enterprise_util.excep_in_fileutil", e);
                    throw e;
                }
                Object var12_12 = null;
                if (jarFile1 == null) break block13;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (jarFile1 != null) {
                    jarFile1.close();
                }
                if (jarFile2 == null) throw throwable;
                jarFile2.close();
                throw throwable;
            }
            jarFile1.close();
        }
        if (jarFile2 == null) return identical;
        jarFile2.close();
        return identical;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean jarEntriesEqual(JarFile jarFile1, JarEntry entry1, JarFile jarFile2, JarEntry entry2) throws IOException {
        InputStream inputStream2;
        boolean identical;
        block14: {
            identical = false;
            int entry1Size = (int)entry1.getSize();
            int entry2Size = (int)entry2.getSize();
            if ((long)entry1Size != -1L && (long)entry2Size != -1L && entry1Size != entry2Size) {
                if (!_logger.isLoggable(Level.FINE)) return identical;
                _logger.log(Level.FINE, "sz: " + entry1Size + " , " + entry2Size);
                return identical;
            }
            if (entry1Size == 0) {
                return true;
            }
            InputStream inputStream1 = null;
            inputStream2 = null;
            try {
                try {
                    inputStream1 = jarFile1.getInputStream(entry1);
                    inputStream2 = jarFile2.getInputStream(entry2);
                    byte[] file1Bytes = new byte[entry1Size];
                    byte[] file2Bytes = new byte[entry2Size];
                    int read = 0;
                    int numBytesRead1 = 0;
                    while ((read = inputStream1.read(file1Bytes, numBytesRead1, entry1Size - numBytesRead1)) != -1 & (numBytesRead1 += read) != entry1Size) {
                    }
                    int numBytesRead2 = 0;
                    while ((read = inputStream2.read(file2Bytes, numBytesRead2, entry2Size - numBytesRead2)) != -1 & (numBytesRead2 += read) != entry2Size) {
                    }
                    if (numBytesRead1 == -1) throw new IOException("Byte read error " + numBytesRead1 + " " + numBytesRead2);
                    if (numBytesRead2 == -1) {
                        throw new IOException("Byte read error " + numBytesRead1 + " " + numBytesRead2);
                    }
                    if (Arrays.equals(file1Bytes, file2Bytes)) {
                        identical = true;
                    } else {
                        _logger.log(Level.FINE, "bytes not equal");
                    }
                }
                catch (IOException e) {
                    if (!_logger.isLoggable(Level.WARNING)) throw e;
                    _logger.log(Level.WARNING, "enterprise_util.excep_in_fileutil", e);
                    throw e;
                }
                Object var15_15 = null;
                if (inputStream1 == null) break block14;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (inputStream1 != null) {
                    inputStream1.close();
                }
                if (inputStream2 == null) throw throwable;
                inputStream2.close();
                throw throwable;
            }
            inputStream1.close();
        }
        if (inputStream2 == null) return identical;
        inputStream2.close();
        return identical;
    }

    public static boolean isEARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/application.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isWARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("WEB-INF/web.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isEJBJar(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/ejb-jar.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isRARFile(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/ra.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isAppClientJar(File file) {
        try {
            JarFile jar = new JarFile(file);
            ZipEntry result = jar.getEntry("META-INF/application-client.xml");
            jar.close();
            return result != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean deleteDirContents(File dir) {
        if (dir.isDirectory()) {
            try {
                boolean ok = true;
                File dirCon = dir.getCanonicalFile();
                String[] ch = dirCon.list();
                for (int i = 0; i < ch.length; ++i) {
                    File file = new File(dir, ch[i]);
                    try {
                        File fileCon = file.getCanonicalFile();
                        if (fileCon.getParentFile().equals(dirCon)) {
                            if (FileUtil.delete(fileCon)) continue;
                            ok = false;
                            continue;
                        }
                        Print.dprintln("Symbolic link? " + file);
                        if (file.delete()) continue;
                        ok = false;
                        continue;
                    }
                    catch (IOException ioe) {
                        Print.dprintStackTrace("Can't delete: " + file, ioe);
                        ok = false;
                    }
                }
                return ok;
            }
            catch (IOException ioe) {
                Print.dprintStackTrace("Can't delete dir contents: " + dir, ioe);
                return false;
            }
        }
        return false;
    }

    public static boolean deleteDir(File fileDir) {
        return FileUtil.delete(fileDir);
    }

    public static URL getEntryAsUrl(File moduleLocation, String uri) throws MalformedURLException {
        URL url = null;
        if (moduleLocation != null) {
            if (moduleLocation.isFile()) {
                url = FileUtil.createJarUrl(moduleLocation, uri);
            } else {
                String path = uri.replace('/', File.separatorChar);
                url = new File(moduleLocation, path).toURL();
            }
        }
        return url;
    }

    public static URL createJarUrl(File jarFile, String entry) throws MalformedURLException {
        return new URL("jar:" + jarFile.toURL() + "!/" + entry);
    }

    public static boolean delete(File dir) {
        if (dir.isDirectory()) {
            FileUtil.deleteDirContents(dir);
            return dir.delete();
        }
        return dir.delete();
    }

    public static File deleteOnExit(File file) {
        return FileUtil.deleteOnExit(file, false);
    }

    public static File deleteOnExit(File file, boolean forceDeleteDir) {
        if (!file.isAbsolute()) {
            Print.dprintStackTrace("File is not Absolute! " + file.toString());
        } else {
            if (deleteOnExit_forced == null) {
                deleteOnExit_forced = new Vector();
                deleteOnExit_normal = new Vector();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        FileUtil._delFiles(deleteOnExit_forced, true);
                        FileUtil._delFiles(deleteOnExit_normal, false);
                    }
                });
            }
            if (forceDeleteDir && file.isDirectory()) {
                if (!deleteOnExit_forced.contains(file)) {
                    deleteOnExit_forced.add(file);
                }
            } else if (!deleteOnExit_normal.contains(file)) {
                deleteOnExit_normal.add(file);
            }
        }
        return file;
    }

    private static void _delFiles(List list, boolean forceDelete) {
        if (list == null) {
            return;
        }
        if (!forceDelete) {
            Comparator fileComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String n1 = o1.toString();
                    String n2 = o2.toString();
                    return n2.length() - n1.length();
                }

                public boolean equals(Object o) {
                    return super.equals(o);
                }
            };
            Collections.sort(list, fileComparator);
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            if (!file.isAbsolute()) {
                Print.dprintln("[Not Absolute!] " + file);
                continue;
            }
            if (!file.exists()) continue;
            if (forceDelete) {
                if (FileUtil.delete(file)) continue;
                Print.dprintln("[Not Deleted!] " + file);
                continue;
            }
            if (file.delete()) continue;
            Print.dprintln("[Not Deleted!] " + file);
        }
    }

    public static String getClassNameFromFile(File f) throws IOException, ClassFormatError {
        FileClassLoader fcl = new FileClassLoader(f.toString());
        return fcl.getClassName(f);
    }

    public static void countWords() {
        try {
            String[] filter = new String[]{".java"};
            File f = new File("/home/dannyc/workspace/j2ee/src/share/com/sun/enterprise/deployment");
            Set s = FileUtil.getAllFilesUnder(f, new SimpleFilenameFilter(filter));
            int i = 0;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, s.toString());
            }
            Iterator itr = s.iterator();
            while (itr.hasNext()) {
                File next = (File)itr.next();
                File absoluteFile = new File(f, next.toString());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "\n" + absoluteFile);
                }
                FileReader fr = new FileReader(absoluteFile);
                int nextChar = 0;
                boolean start = false;
                while (nextChar != -1) {
                    if (nextChar == 34) {
                        boolean bl = start = !start;
                        if (!start) {
                            _logger.log(Level.FINE, "\"");
                            ++i;
                        } else if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, " \t word = ");
                        }
                    }
                    if (start && _logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, new Character((char)nextChar).toString());
                    }
                    nextChar = fr.read();
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, i + " words in " + s.size() + " files.");
            }
        }
        catch (Throwable ioe) {
            _logger.log(Level.SEVERE, "enterprise_util.excep_countwords", ioe);
        }
    }
}

