/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.ThreadedReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class BuildLogMsgDoc {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: BuildLogMsgDoc <resource-file-name>");
            System.exit(1);
        }
        String inFile = args[0];
        String outFile = args[0] + ".html";
        try {
            BuildLogMsgDoc.createHtml(inFile, outFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void createHtml(String in, String out) throws FileNotFoundException, IOException {
        BufferedReader reader = new BufferedReader(new FileReader(in));
        BufferedWriter writer = new BufferedWriter(new FileWriter(out, false));
        try {
            writer.write(BuildLogMsgDoc.tableHeader(in));
            writer.newLine();
            writer.write(BuildLogMsgDoc.tableRow("Message Id", "Severity", "Message Text", "Description"));
            writer.newLine();
            String line = null;
            Object newLine = null;
            while ((line = reader.readLine()) != null) {
                BuildLogMsgDoc.parsePropertyEntry(writer, line);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            writer.write(BuildLogMsgDoc.tableFooter());
            try {
                reader.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                writer.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        writer.write(BuildLogMsgDoc.tableFooter());
        try {
            reader.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            writer.close();
        }
        catch (Exception ex) {}
    }

    protected static void parsePropertyEntry(BufferedWriter writer, String line) {
        String result = line.trim();
        if (result.length() == 0) {
            return;
        }
        if (result.startsWith("#")) {
            return;
        }
        String key = null;
        String messageId = null;
        String message = null;
        int pos = -2;
        int pos2 = -2;
        int pos3 = -2;
        pos = result.indexOf("=");
        if (pos > 0) {
            key = result.substring(0, pos);
            result = result.substring(pos + 1);
            pos2 = result.indexOf(" ");
            pos3 = result.indexOf(":");
            if ((pos3 < 0 || pos2 < pos3) && pos2 > 0) {
                messageId = result.substring(0, pos2);
                message = result.substring(pos2 + 1).trim();
                BuildLogMsgDoc.formatLine(writer, key, messageId, message);
                return;
            }
            if (pos3 > 0) {
                messageId = result.substring(0, pos3);
                message = result.substring(pos3 + 1).trim();
                BuildLogMsgDoc.formatLine(writer, key, messageId, message);
                return;
            }
        }
        System.err.println("Failed to parse: " + line + " pos=" + pos + " pos2=" + pos2 + " pos3=" + pos3);
    }

    protected static void formatLine(BufferedWriter writer, String key, String messageId, String message) {
        ArrayList files = BuildLogMsgDoc.findSourceFiles(key);
        if (files == null) {
            try {
                System.err.println("message " + key + "is not found in any files");
                writer.write(BuildLogMsgDoc.tableRow(messageId, "UNKNOWN", message, "key=" + key + " found in NO FILES"));
                writer.newLine();
            }
            catch (Exception ex) {
                System.err.println("formatLine id " + key + " exception ");
                ex.printStackTrace();
            }
        } else {
            for (int i = 0; i < files.size(); ++i) {
                BuildLogMsgDoc.findSourceOccurrence(writer, key, messageId, message, (String)files.get(i));
            }
        }
    }

    protected static String findLevel(String line) {
        String[] keywords = new String[]{"INFO", "WARNING", "SEVERE", "CONFIG", "ALERT", "FATAL", "FINE", "FINER", "FINEST"};
        line = line.toUpperCase();
        for (int i = 0; i < keywords.length; ++i) {
            int pos = line.indexOf(keywords[i]);
            if (pos < 0) continue;
            return keywords[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void findSourceOccurrence(BufferedWriter writer, String messageKey, String messageId, String message, String in) {
        block18: {
            BufferedReader reader = null;
            reader = new BufferedReader(new FileReader(in));
            int lineno = 1;
            int foundOn = -1;
            String line = null;
            while (true) {
                String level;
                if ((line = reader.readLine()) == null) {
                    if (foundOn <= 0) break;
                    System.err.println("found " + messageKey + " but no level in " + in);
                    writer.write(BuildLogMsgDoc.tableRow(messageId, "UNKNOWN", message, "key=" + messageKey + " found in " + in + " line " + foundOn));
                    writer.newLine();
                    break;
                }
                int pos = line.indexOf(messageKey);
                if (pos >= 0) {
                    if (foundOn > 0) {
                        System.err.println("found next " + messageKey + " before finding previous level in " + in);
                        writer.write(BuildLogMsgDoc.tableRow(messageId, "UNKNOWN", message, "key=" + messageKey + " found in " + in + " line " + foundOn));
                        writer.newLine();
                    }
                    foundOn = lineno;
                }
                if (foundOn >= lineno && (level = BuildLogMsgDoc.findLevel(line)) != null) {
                    if (foundOn < lineno + 5) {
                        writer.write(BuildLogMsgDoc.tableRow(messageId, level, message, "key=" + messageKey + " found in " + in + " line " + foundOn + " logged in line " + lineno));
                    } else {
                        writer.write(BuildLogMsgDoc.tableRow(messageId, "**" + level, message, "key=" + messageKey + " found in " + in + " line " + foundOn + " logged in line " + lineno));
                    }
                    writer.newLine();
                    foundOn = -1;
                }
                ++lineno;
            }
            Object var12_12 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block18;
            }
            catch (Exception ex2) {}
            break block18;
            {
                catch (Exception ex) {
                    System.err.println("findSourceOccurrence id " + messageKey + " in " + in + " exception");
                    ex.printStackTrace();
                    Object var12_13 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block18;
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected static ArrayList findSourceFiles(String messageKey) {
        try {
            ArrayList stdoutList = new ArrayList();
            ArrayList stderrList = new ArrayList();
            Process p = Runtime.getRuntime().exec("/bin/find /ias/tip/iplanet/ias/server/src/java -name \"*.java\" -exec grep -l " + messageKey + " {} ;");
            ThreadedReader inReader = new ThreadedReader(p.getInputStream(), stdoutList, messageKey);
            ThreadedReader errReader = new ThreadedReader(p.getErrorStream(), stderrList, messageKey);
            inReader.start();
            errReader.start();
            inReader.join();
            errReader.join();
            p.waitFor();
            p.exitValue();
            if (!stderrList.isEmpty()) {
                System.err.println("findSourceFiles " + messageKey + " stderr");
                for (int i = 0; i < stderrList.size(); ++i) {
                    System.err.println("  " + (String)stderrList.get(i));
                }
            }
            if (!stdoutList.isEmpty()) {
                return stdoutList;
            }
            return null;
        }
        catch (Exception ex) {
            System.err.println("findSourceFiles " + messageKey + " exception");
            ex.printStackTrace();
            return null;
        }
    }

    protected static String tableHeader(String inFile) {
        String r = "<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">";
        r = r + "\n<html>";
        r = r + "\n<head>";
        r = r + "\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">";
        r = r + "\n<meta name=\"Author\" content=\"Ken Ebbs\">";
        r = r + "\n<meta name=\"GENERATOR\" content=\"Mozilla/4.79 [en] (Windows NT 5.0; U) [Netscape]\">";
        r = r + "\n<title>Logging Message Reference</title>";
        r = r + "\n</head>";
        r = r + "\n<body>";
        r = r + "\n&nbsp;";
        r = r + "\n<table BORDER WIDTH=\"100%\" >";
        r = r + "\n<caption>Log Messages For " + inFile + "</caption>";
        return r;
    }

    protected static String tableFooter() {
        String r = "</table>";
        r = r + "\n</body>";
        r = r + "\n</html>";
        return r;
    }

    protected static String tableRow(String messageId, String severity, String messageText, String description) {
        String r = "<tr>";
        r = r + "\n<td>" + messageId + "</td>";
        r = r + "\n<td>" + severity + "</td>";
        r = r + "\n<td>" + messageText + "</td>";
        r = r + "\n<td>" + description + "</td>";
        r = r + "\n</tr>";
        return r;
    }
}

