/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.ConfigChangeCategory;
import com.sun.enterprise.admin.event.tx.JTSEvent;
import com.sun.enterprise.admin.event.tx.JTSEventListener;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JTSConfigChangeEventListener
implements JTSEventListener {
    private static StringManager sm = StringManager.getManager(JTSConfigChangeEventListener.class);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    public String xPath = ServerXPathHelper.XPATH_TRANSACTION_SERVICE;
    private static ConfigChangeCategory category = new ConfigChangeCategory("jts", ServerXPathHelper.REGEX_XPATH_CONFIG + "/" + "{1,}" + ServerTags.TRANSACTION_SERVICE + ".*");

    public static ConfigChangeCategory getCategory() {
        return category;
    }

    public void handleCreate(JTSEvent event) throws AdminEventListenerException {
        throw new AdminEventListenerException("handleCreate is not valid for JTSEvent");
    }

    public void handleDelete(JTSEvent event) throws AdminEventListenerException {
        throw new AdminEventListenerException("handleDelete is not valid for JTSEvent");
    }

    public void handleUpdate(JTSEvent event) throws AdminEventListenerException {
        if (event == null) {
            return;
        }
        ArrayList configChangeList = event.getConfigChangeList();
        if (configChangeList == null) {
            return;
        }
        ConfigUpdate configUpdate = null;
        boolean match = false;
        for (int i = 0; i < configChangeList.size(); ++i) {
            configUpdate = (ConfigUpdate)configChangeList.get(i);
            if (!this.xPath.equals(configUpdate.getXPath())) continue;
            match = true;
            break;
        }
        if (match) {
            Set attributeSet = configUpdate.getAttributeSet();
            String next = null;
            Iterator iter = attributeSet.iterator();
            while (iter.hasNext()) {
                next = (String)iter.next();
                if (next.equals(ServerTags.TIMEOUT_IN_SECONDS)) {
                    _logger.log(Level.FINE, " Transaction Timeout interval event occurred");
                    String oldTimeout = configUpdate.getOldValue(ServerTags.TIMEOUT_IN_SECONDS);
                    String newTimeout = configUpdate.getNewValue(ServerTags.TIMEOUT_IN_SECONDS);
                    if (oldTimeout.equals(newTimeout)) continue;
                    try {
                        Switch.getSwitch().getTransactionManager().setTransactionTimeout(Integer.parseInt(newTimeout, 10));
                    }
                    catch (Exception ex) {
                        _logger.log(Level.WARNING, "transaction.reconfig_txn_timeout_failed", ex);
                    }
                    continue;
                }
                if (next.equals(ServerTags.KEYPOINT_INTERVAL)) {
                    _logger.log(Level.FINE, "Keypoint interval event occurred");
                    String oldKeyPoint = configUpdate.getOldValue(ServerTags.KEYPOINT_INTERVAL);
                    String newKeyPoint = configUpdate.getNewValue(ServerTags.KEYPOINT_INTERVAL);
                    if (oldKeyPoint.equals(newKeyPoint)) continue;
                    Configuration.setKeypointTrigger(Integer.parseInt(newKeyPoint, 10));
                    continue;
                }
                if (next.equals(ServerTags.RETRY_TIMEOUT_IN_SECONDS)) {
                    String oldRetryTiemout = configUpdate.getOldValue(ServerTags.RETRY_TIMEOUT_IN_SECONDS);
                    String newRetryTiemout = configUpdate.getNewValue(ServerTags.RETRY_TIMEOUT_IN_SECONDS);
                    _logger.log(Level.FINE, "retry_timeout_in_seconds reconfig event occurred " + newRetryTiemout);
                    if (oldRetryTiemout.equals(newRetryTiemout)) continue;
                    Configuration.setCommitRetryVar(newRetryTiemout);
                    continue;
                }
                AdminEventMulticaster.notifyFailure(event, "restart");
            }
        }
    }
}

