/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.web;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.web.TagLibFactory;
import com.sun.enterprise.tools.verifier.wsclient.WebServiceClientCheckMgrImpl;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class WebCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private static final String testsListFileName = "TestNamesWeb.xml";
    private static final String sunONETestsListFileName = WebCheckMgrImpl.getSunPrefix().concat("TestNamesWeb.xml");
    private static Vector test = new Vector();
    private static TagLibDescriptor[] tlds;

    public WebCheckMgrImpl(FrameworkContext frameworkContext) {
        this.frameworkContext = frameworkContext;
    }

    public void check(Descriptor descriptor) throws Exception {
        this.createTaglibDescriptors(descriptor);
        super.check(descriptor);
        this.checkWebServices(descriptor);
        this.checkWebServicesClient(descriptor);
    }

    protected Vector getTests() {
        return test;
    }

    protected String getTestsListFileName() {
        return testsListFileName;
    }

    protected String getSunONETestsListFileName() {
        return sunONETestsListFileName;
    }

    protected String getArchiveUri(Descriptor descriptor) {
        return ((WebBundleDescriptor)descriptor).getDisplayName();
    }

    protected void createTaglibDescriptors(Descriptor descriptor) {
        TagLibFactory tlf = new TagLibFactory(this.context);
        tlds = tlf.getTagLibDescriptors((WebBundleDescriptor)descriptor);
        if (tlds != null) {
            this.context.setTagLibDescriptors(tlds);
            this.setVerifierContext(this.context);
        }
    }

    protected void checkWebServicesClient(Descriptor descriptor) throws Exception {
        if (this.frameworkContext.isPartition() && !this.frameworkContext.isWebServicesClient()) {
            return;
        }
        WebBundleDescriptor desc = (WebBundleDescriptor)descriptor;
        WebServiceClientCheckMgrImpl webServiceClientCheckMgr = new WebServiceClientCheckMgrImpl(this.frameworkContext);
        if (desc.hasWebServiceClients()) {
            Set serviceRefDescriptors = desc.getServiceReferenceDescriptors();
            Iterator it = serviceRefDescriptors.iterator();
            while (it.hasNext()) {
                webServiceClientCheckMgr.setVerifierContext(this.context);
                webServiceClientCheckMgr.check((ServiceReferenceDescriptor)it.next());
            }
        }
    }

    protected String getSpecVersion(Descriptor descriptor) {
        return ((WebBundleDescriptor)descriptor).getSpecVersion();
    }

    protected void setModuleName(Result r) {
        r.setModuleName("web");
    }
}

