/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.runtime.web.Servlet;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Iterator;
import java.util.Set;

public class ASServlet
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        try {
            Float runtimeSpecVersion = this.getRuntimeSpecVersion();
            Servlet[] servlets = descriptor.getSunDescriptor().getServlet();
            if (servlets != null && servlets.length > 0) {
                for (int rep = 0; rep < servlets.length; ++rep) {
                    String servletName = servlets[rep].getServletName();
                    if (this.validServletName(servletName, descriptor)) {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB servlet] servlet-name [ {0} ] properly defined in the war file.", new Object[]{servletName}));
                    } else {
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB servlet] servlet-name [ {0} ] is not a valid, either empty or not defined in web.xml.", new Object[]{servletName}));
                        oneFailed = true;
                    }
                    String prinName = servlets[rep].getPrincipalName();
                    if (prinName != null && !"".equals(prinName)) {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-WEB servlet] principal-name [ {0} ] properly defined in the war file.", new Object[]{prinName}));
                        continue;
                    }
                    if (runtimeSpecVersion.compareTo(new Float("2.4")) < 0) {
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB servlet ] principal-name [ {0} ] cannot be an empty string.", new Object[]{prinName}));
                        oneFailed = true;
                        continue;
                    }
                    this.addNaDetails(result, compName);
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "NOT APPLICABLE [AS-WEB servlet] principal-name not defined", new Object[]{descriptor.getName()}));
                }
            } else {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB sun-web-app] servlet element(s) not defined in the web archive [ {0} ].", new Object[]{descriptor.getName()}));
                return result;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-WEB sun-web-app] servlet element(s) are valid within the web archive [ {0} ] .", new Object[]{descriptor.getName()}));
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB sun-web-app] could not create the servlet object"));
        }
        return result;
    }

    boolean validServletName(String servletName, WebBundleDescriptor descriptor) {
        boolean valid = false;
        if (servletName != null && servletName.length() != 0) {
            Set servlets = descriptor.getServletDescriptors();
            Iterator itr = servlets.iterator();
            while (itr.hasNext()) {
                WebComponentDescriptor servlet = (WebComponentDescriptor)itr.next();
                String thisServletName = servlet.getCanonicalName();
                if (!servletName.equals(thisServletName)) continue;
                valid = true;
                break;
            }
        }
        return valid;
    }
}

