/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.common.ResourceEnvRef;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;

public class ASResourceEnvRef
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        boolean notApp = false;
        boolean chkOk = true;
        try {
            ResourceEnvRef[] envRefs = descriptor.getSunDescriptor().getResourceEnvRef();
            if (envRefs != null && envRefs.length > 0) {
                for (int rep = 0; rep < envRefs.length; ++rep) {
                    boolean isValidResRefName = false;
                    String resName = envRefs[rep].getResourceEnvRefName();
                    String jndiName = envRefs[rep].getJndiName();
                    if (this.validResEnvRefName(resName, descriptor)) {
                        isValidResRefName = true;
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB sun-web-app] resource-env-ref [ {0} ] properly defined in the war file.", new Object[]{resName}));
                    } else {
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB sun-web-app] resource-env-ref name [ {0} ] is not valid, either empty or not defined in web.xml.", new Object[]{resName}));
                    }
                    if (isValidResRefName && this.validJndiName(jndiName, resName, descriptor)) {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-WEB resource-env-ref] jndi-name  [ {0} ] properly defined in the war file.", new Object[]{jndiName}));
                        continue;
                    }
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB resource-env-ref] jndi-name [ {0} ] is not valid, either empty or not starts with \"jms/\".", new Object[]{resName}));
                }
            } else {
                notApp = true;
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB sun-web-app] resource-env-ref element not defined in the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (notApp) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-WEB sun-web-app] resource-env-ref element(s) are valid within the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB resource-env-ref] Could not create the resource-env-ref"));
        }
        return result;
    }

    boolean validResEnvRefName(String name, WebBundleDescriptor descriptor) {
        boolean valid = true;
        if (name != null && name.length() != 0) {
            try {
                descriptor.getJmsDestinationReferenceByName(name);
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    boolean validJndiName(String refJndiName, String refName, WebBundleDescriptor descriptor) {
        boolean valid = true;
        if (refJndiName != null && refJndiName.length() != 0) {
            JmsDestinationReferenceDescriptor resDesc = descriptor.getJmsDestinationReferenceByName(refName);
            String type = resDesc.getRefType();
            if (type.indexOf("javax.jms") > -1) {
                if (!refJndiName.startsWith("jms/")) {
                    valid = false;
                }
            } else {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }
}

