/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.runtime.web.Cache;
import com.sun.enterprise.deployment.runtime.web.CacheHelper;
import com.sun.enterprise.deployment.runtime.web.CacheMapping;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.runtime.ASCache;
import java.util.Iterator;
import java.util.Set;

public class ASCacheMapping
extends ASCache
implements WebCheck {
    boolean oneWarning = false;
    boolean oneFailed = false;

    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        boolean notApp = false;
        try {
            Cache cache = descriptor.getSunDescriptor().getCache();
            CacheMapping[] cacheMapp = null;
            String servletName = null;
            String urlPattern = null;
            String timeout = null;
            if (cache != null) {
                cacheMapp = cache.getCacheMapping();
            }
            if (cache != null && cacheMapp != null && cacheMapp.length != 0) {
                for (int rep = 0; rep < cacheMapp.length; ++rep) {
                    servletName = cacheMapp[rep].getServletName();
                    urlPattern = cacheMapp[rep].getUrlPattern();
                    timeout = cacheMapp[rep].getTimeout();
                    String[] httpMethods = cacheMapp[rep].getHttpMethod();
                    String cacheHelperRef = cacheMapp[rep].getCacheHelperRef();
                    if (servletName != null) {
                        if (this.validServletName(servletName, descriptor)) {
                            this.addGoodDetails(result, compName);
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB cache-mapping] servlet-name  [ {0} ] properly defined.", new Object[]{servletName}));
                        } else {
                            this.addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB cache-mapping] servlet-name [ {0} ], does not exist in the web application.", new Object[]{servletName}));
                            this.oneFailed = true;
                        }
                    } else if (urlPattern != null) {
                        if (this.validURL(urlPattern)) {
                            this.addGoodDetails(result, compName);
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-WEB cache-mapping] url-pattern [ {0} ] properly defined.", new Object[]{urlPattern}));
                        } else {
                            this.addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB cache-mapping] url-pattern [ {0} ], does not exist in  the web application.", new Object[]{urlPattern}));
                            this.oneFailed = true;
                        }
                    }
                    if (cacheHelperRef != null) {
                        if (this.validCacheHelperRef(cacheHelperRef, cache)) {
                            this.addGoodDetails(result, compName);
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-WEB cache-mapping] cache-helper-ref element [ {0} ]  defined properly.", new Object[]{cacheHelperRef}));
                            continue;
                        }
                        this.oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB cache-mapping] cache-helper-ref [ {0} ] not valid, either empty or  cache-helper not defined for it.", new Object[]{cacheHelperRef}));
                        continue;
                    }
                    if (timeout != null) {
                        int i = rep + 1;
                        String timeoutName = this.getXPathValue("sun-web-app/cache/cache-mapping[" + i + "]/timeout/@name");
                        if (this.validTimeout(timeout, timeoutName)) {
                            this.addGoodDetails(result, compName);
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed3", "PASSED [AS-WEB cache-mapping] timeout element [ {0} ] properly defined.", new Object[]{new Integer(timeout)}));
                        } else {
                            this.oneFailed = true;
                            this.addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-WEB cache-mapping] timeout element [{0}] must be a Long ( Not less than -1 and not more that MAX_LONG) and its name attribute [{1}] can not be empty/null.", new Object[]{timeout, timeoutName}));
                        }
                    }
                    int j = rep + 1;
                    int count = this.getCountNodeSet("sun-web-app/cache/cache-mapping[" + j + "]/refresh-field");
                    if (count > 0) {
                        String cacheMapName = null;
                        cacheMapName = cacheMapp[rep].getServletName() != null ? cacheMapp[rep].getServletName() : cacheMapp[rep].getUrlPattern();
                        String name = this.getXPathValue("sun-web-app/cache/cache-mapping[" + j + "]/refresh-field/@name");
                        if (name != null && name.length() != 0) {
                            this.addGoodDetails(result, compName);
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed3a", "PASSED [AS-WEB cache-mapping] for {0}, refresh-field name [{1}] has been furnished", new Object[]{cacheMapName, name}));
                        } else {
                            this.addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed3a", "FAILED [AS-WEB cache-mapping] for {0}, refresh-field name [{1}] cannot be empty/null string", new Object[]{cacheMapName, name}));
                            this.oneFailed = true;
                        }
                    }
                    if (!this.checkHTTPMethodList(httpMethods, result, compName, descriptor)) {
                        this.oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed4", "FAILED [AS-WEB cache-mapping] http-method - List of HTTP methods is not proper,  atleast one of the method name in the list is empty/null "));
                    }
                    if (this.getCountNodeSet("sun-web-app/cache/cache-mapping[" + j + "]/key-field") <= 0) continue;
                    this.testForKeyFields(cache, j, result, compName);
                }
            } else {
                notApp = true;
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB cache-mapping] element not defined", new Object[]{descriptor.getName()}));
            }
            if (this.oneFailed) {
                result.setStatus(1);
            } else if (this.oneWarning) {
                result.setStatus(2);
            } else if (notApp) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        }
        catch (Exception ex) {
            this.oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed7", "FAILED [AS-WEB cache-mapping] could not create the cache object"));
        }
        return result;
    }

    boolean validURL(String URL2) {
        boolean valid = false;
        if (URL2 != null && (URL2.startsWith("/") || URL2.startsWith("/") && URL2.endsWith("/*") || URL2.startsWith("*."))) {
            valid = true;
        }
        return valid;
    }

    boolean validServletName(String servletName, WebBundleDescriptor descriptor) {
        boolean valid = false;
        if (servletName != null && servletName.length() != 0) {
            Set servlets = descriptor.getServletDescriptors();
            Iterator itr = servlets.iterator();
            while (itr.hasNext()) {
                String thisServletName = ((WebComponentDescriptor)itr.next()).getCanonicalName();
                if (!servletName.equals(thisServletName)) continue;
                valid = true;
                break;
            }
        }
        return valid;
    }

    boolean validTimeout(String timeout, String timeoutName) {
        boolean valid = false;
        if (timeout != null) {
            try {
                long timeoutValue = Long.parseLong(timeout);
                if (timeoutValue >= -1L && timeoutValue <= Long.MAX_VALUE && timeoutName != null && timeoutName.length() != 0) {
                    valid = true;
                }
            }
            catch (NumberFormatException exception) {}
        } else {
            valid = true;
        }
        return valid;
    }

    boolean checkHTTPMethodList(String[] httpMethods, Result result, WebComponentNameConstructor compName, WebBundleDescriptor descriptor) {
        boolean valid = true;
        if (httpMethods != null) {
            for (int rep = 0; rep < httpMethods.length; ++rep) {
                if (httpMethods[rep] != null && !httpMethods[rep].trim().equals("")) {
                    if (httpMethods[rep].equalsIgnoreCase("GET") || httpMethods[rep].equalsIgnoreCase("POST") || httpMethods[rep].equalsIgnoreCase("HEAD")) {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed4", "PASSED [AS-WEB cache-mapping ] http-method  [ {0} ] properly defined in the WEB DD.", new Object[]{httpMethods[rep]}));
                        continue;
                    }
                    this.oneWarning = true;
                    this.addWarningDetails(result, compName);
                    result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-WEB cache-mapping] http-method name [ {0} ] present, suggested to be GET | POST | HEAD.", new Object[]{httpMethods[rep]}));
                    continue;
                }
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed5", "FAILED [AS-WEB cache-mapping] http-method name [ {0} ] is invalid, it should be GET | POST | HEAD.", new Object[]{httpMethods[rep]}));
                valid = false;
            }
        }
        return valid;
    }

    boolean validCacheHelperRef(String helperRef, Cache cache) {
        boolean valid = false;
        if (helperRef.length() != 0) {
            CacheHelper[] helperClasses = null;
            CacheHelper helperClass = null;
            String name = null;
            if (cache != null) {
                helperClasses = cache.getCacheHelper();
            }
            if (cache != null && helperClasses != null) {
                for (int rep = 0; rep < helperClasses.length; ++rep) {
                    helperClass = helperClasses[rep];
                    if (helperClass == null) continue;
                    int i = rep + 1;
                    name = this.getXPathValue("sun-web-app/cache/cache-helper[" + i + "]/@name");
                    if (!helperRef.equals(name)) continue;
                    valid = true;
                    break;
                }
            }
        }
        return valid;
    }

    public void testForKeyFields(Cache cache, int mapCount, Result result, WebComponentNameConstructor compName) {
        int keyCount = this.getCountNodeSet("sun-web-app/cache/cache-mapping[" + mapCount + "]/key-field");
        String cacheMapName = this.getXPathValue("sun-web-app/cache/cache-mapping[" + mapCount + "]/servlet-name");
        if (cacheMapName == null) {
            cacheMapName = this.getXPathValue("sun-web-app/cache/cache-mapping[" + mapCount + "]/url-pattern");
        }
        if (keyCount > 0) {
            for (int k = 1; k <= keyCount; ++k) {
                String name = this.getXPathValue("sun-web-app/cache/cache-mapping[" + mapCount + "]/key-field[" + k + "]/@name");
                if (name != null && name.length() == 0) {
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed6", "FAILED [AS-WEB cache-mapping] for {0}, key-field #{1}, name cannot be an empty string", new Object[]{cacheMapName, new Integer(k)}));
                    this.oneFailed = true;
                    continue;
                }
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed5", "PASSED [AS-WEB cache-mapping] for {0}, key-field #{1} name value furnished", new Object[]{cacheMapName, new Integer(k)}));
            }
        }
    }
}

