/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ErrorPageDescriptor;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompiler;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImpl;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class WebArchiveClassesLoadable
extends WebTest
implements WebCheck {
    static final /* synthetic */ boolean $assertionsDisabled;

    public Result check(WebBundleDescriptor descriptor) {
        Iterator entries;
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        String archiveUri = this.getAbstractArchiveUri(descriptor);
        try {
            entries = this.getClassNames(descriptor).iterator();
        }
        catch (Exception e) {
            result.failed(smh.getLocalString(this.getClass().getName() + ".exception", "Error: [ {0} ] exception while loading the archive [ {1} ].", new Object[]{e, descriptor.getName()}));
            return result;
        }
        boolean allPassed = true;
        ClosureCompiler closureCompiler = this.getVerifierContext().getClosureCompiler();
        ((ClosureCompilerImpl)closureCompiler).addExcludedPattern("org.apache.jasper");
        while (entries.hasNext()) {
            String className = (String)entries.next();
            boolean status = closureCompiler.buildClosure(className);
            allPassed = status && allPassed;
        }
        if (allPassed) {
            result.setStatus(0);
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All the classes are loadable within [ {0} ] without any linkage error.", new Object[]{archiveUri}));
        } else {
            result.setStatus(1);
            this.addErrorDetails(result, compName);
            result.addErrorDetails(closureCompiler.toString());
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.loadableError", "Please either bundle the above mentioned classes in the application or use optional packaging support for them."));
        }
        return result;
    }

    private List getClassNames(WebBundleDescriptor descriptor) throws Exception {
        final LinkedList<String> results = new LinkedList<String>();
        Set servletDescriptors = descriptor.getServletDescriptors();
        Iterator itr = servletDescriptors.iterator();
        while (itr.hasNext()) {
            WebComponentDescriptor webDesc = (WebComponentDescriptor)itr.next();
            String servletClassName = webDesc.getWebComponentImplementation();
            results.add(servletClassName);
        }
        Vector servletFilterDescriptors = descriptor.getServletFilterDescriptors();
        for (int i = 0; i < servletFilterDescriptors.size(); ++i) {
            ServletFilter filter = (ServletFilter)servletFilterDescriptors.elementAt(i);
            String filterClassName = filter.getClassName();
            results.add(filterClassName);
        }
        Vector appListenerDescriptors = descriptor.getAppListenerDescriptors();
        for (int i = 0; i < appListenerDescriptors.size(); ++i) {
            AppListenerDescriptor listenerDescriptor = (AppListenerDescriptor)appListenerDescriptors.elementAt(i);
            String listenerClassName = listenerDescriptor.getListener();
            results.add(listenerClassName);
        }
        Enumeration en = descriptor.getErrorPageDescriptors();
        while (en.hasMoreElements()) {
            ErrorPageDescriptor errorPageDescriptor = (ErrorPageDescriptor)en.nextElement();
            results.add(errorPageDescriptor.getExceptionType());
        }
        File file = this.getVerifierContext().getOutDir();
        if (file == null) {
            throw new Exception("JSP compiler output directory not set");
        }
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        new File(file, "org/apache/jsp").listFiles(new FilenameFilter(){

            public boolean accept(File file, String s) {
                if (s.endsWith(".class")) {
                    String binName = "org/apache/jsp/" + s;
                    String clsName = binName.substring(0, binName.lastIndexOf(".")).replace('/', '.');
                    results.add(clsName);
                }
                return true;
            }
        });
        return results;
    }

    static {
        $assertionsDisabled = !WebArchiveClassesLoadable.class.desiredAssertionStatus();
    }
}

