/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;

public class TagNameIsUnique
extends WebTest
implements WebCheck {
    boolean oneFailed = false;

    public Result check(WebBundleDescriptor descriptor) {
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        Context context = this.getVerifierContext();
        Result result = this.loadWarFile(descriptor);
        boolean na = true;
        boolean failed = false;
        TagLibDescriptor[] tlds = context.getTagLibDescriptors();
        if (tlds != null && tlds.length != 0) {
            for (int i = 0; i < tlds.length; ++i) {
                String[] names = tlds[i].getNamesFromTagElement();
                if (names == null) continue;
                na = false;
                failed = this.checkForDuplicateNames(result, compName, names, tlds[i]);
                if (failed) continue;
                this.addGoodDetails(result, compName);
                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "All 'name' elements are defined properly under tag element of [ {0} ]", new Object[]{tlds[i].getUri()}));
            }
        }
        if (this.oneFailed) {
            result.setStatus(1);
        } else if (na) {
            result.setStatus(3);
            this.addNaDetails(result, compName);
            result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable", "No tag libraries are defined in the application"));
        } else {
            result.setStatus(0);
        }
        return result;
    }

    public boolean checkForDuplicateNames(Result result, WebComponentNameConstructor compName, String[] names, TagLibDescriptor tld) {
        boolean duplicate = false;
        for (int i = 0; i < names.length - 1; ++i) {
            String tmp = names[i];
            if (tmp == null) {
                this.oneFailed = true;
                this.addErrorDetails(result, compName);
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "The name element value [ {0} ] under tag element in [ {1} ] is not defined properly", new Object[]{names[i], tld.getUri()}));
                continue;
            }
            for (int j = i + 1; j < names.length; ++j) {
                duplicate = tmp.trim().equals(names[j]);
                if (!duplicate) continue;
                this.oneFailed = true;
                this.addErrorDetails(result, compName);
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "The name element value [ {0} ] under tag element in [ {1} ] is not unique", new Object[]{names[i], tld.getUri()}));
            }
        }
        return this.oneFailed;
    }
}

