/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.File;
import java.util.logging.Level;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspC;

public class AllJSPsMustBeCompilable
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        try {
            this.compile(descriptor);
        }
        catch (JasperException e) {
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".exception", "Error: Some JSPs bundled inside [ {0} ] could not be compiled. See details below.", new Object[]{descriptor.getName()}));
            result.addErrorDetails(e.toString());
            return result;
        }
        this.addGoodDetails(result, compName);
        result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "All JSPs are compilable."));
        result.setStatus(0);
        return result;
    }

    private void compile(WebBundleDescriptor descriptor) throws JasperException {
        String archiveUri = this.getAbstractArchiveUri(descriptor);
        File outDir = this.getVerifierContext().getOutDir();
        this.logger.log(Level.INFO, "Starting to compile JSPs with archiveUri " + archiveUri);
        JspC jspc = new JspC();
        jspc.setUriroot(archiveUri);
        jspc.setCompile(true);
        jspc.setOutputDir(outDir.getAbsolutePath());
        String as_lib_root = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator;
        String cp = this.getVerifierContext().getClassPath() + File.pathSeparator + as_lib_root + "j2ee.jar" + File.pathSeparator + as_lib_root + "jaxrpc-api.jar" + File.pathSeparator + as_lib_root + "jaxr-api.jar" + File.pathSeparator + as_lib_root + "saaj-api.jar" + File.pathSeparator + as_lib_root + "mail.jar" + File.pathSeparator;
        this.logger.log(Level.INFO, "JSPC classpath " + cp);
        jspc.setClassPath(cp);
        jspc.setVerbose(1);
        jspc.execute();
    }
}

