/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.logging.Level;

public class EjbClassImplementsComponentInterface
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor) {
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), (EjbSessionDescriptor)descriptor);
            }
            if (descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalClassName(), (EjbSessionDescriptor)descriptor);
            }
            if ((descriptor.getRemoteClassName() == null || "".equals(descriptor.getRemoteClassName())) && (descriptor.getLocalClassName() == null || "".equals(descriptor.getLocalClassName()))) {
                if (this.implementsEndpoints(descriptor)) {
                    this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.webservice.notapp", "Not Applicable because, EJB [ {0} ] implements a Service Endpoint Interface.", new Object[]{this.compName.toString()}));
                    this.result.setStatus(3);
                } else {
                    this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Ejb [ {0} ] does not have local or remote interfaces", new Object[]{descriptor.getEjbClassName()}));
                    this.result.setStatus(1);
                    return this.result;
                }
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        this.result.setStatus(3);
        return this.result;
    }

    private void commonToBothInterfaces(String component, EjbSessionDescriptor descriptor) {
        boolean foundEjbClassName = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> c = jcl.loadClass(descriptor.getEjbClassName());
            foundEjbClassName = true;
            Class<?> rc = jcl.loadClass(component);
            boolean foundOne = false;
            block2: do {
                Class<?>[] interfaces = c.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{interfaces[i].getName()});
                    if (!interfaces[i].getName().equals(rc.getName()) || !(descriptor instanceof EjbSessionDescriptor)) continue;
                    this.result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: [ {0} ] class implments the enterprise Bean's remote interface [ {1} ].  It is recommended that the enterprise bean class not implement the remote interface to prevent inadvertent passing of this as a method argument or result. ", new Object[]{descriptor.getEjbClassName(), rc.getName()}));
                    foundOne = true;
                    continue block2;
                }
            } while ((c = c.getSuperclass()) != null);
            if (!foundOne) {
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "[ {0} ] does not optionally implement bean class remote interface  [ {1} ]", new Object[]{descriptor.getEjbClassName(), rc.getName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            if (!foundEjbClassName) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            }
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{component}));
        }
    }
}

