/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

public class ASEjbRefreshPeriod
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        boolean oneWarning = false;
        boolean oneFailed = false;
        boolean isReadOnly = false;
        String refreshPeriod = null;
        try {
            String s1 = "/sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/refresh-period-in-seconds";
            refreshPeriod = this.getXPathValue(s1);
            IASEjbExtraDescriptors iasEjbExtraDesc = descriptor.getIASEjbExtraDescriptors();
            isReadOnly = iasEjbExtraDesc.isIsReadOnlyBean();
            if (refreshPeriod != null) {
                if ((refreshPeriod = refreshPeriod.trim()).length() == 0) {
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-EJB ejb] : refresh-period-in-seconds is invalid. It should be between 0 and 2147483647"));
                } else {
                    if (!(descriptor instanceof EjbEntityDescriptor) || !isReadOnly) {
                        oneWarning = true;
                        result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB ejb] : refresh-period-in-seconds should be defined for Read Only Beans."));
                        return result;
                    }
                    try {
                        int refValue = Integer.parseInt(refreshPeriod);
                        if (refValue < 0 || refValue > Integer.MAX_VALUE) {
                            oneFailed = true;
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-EJB ejb] : refresh-period-in-seconds cannot be greater than 2147483647 or less than 0"));
                        } else {
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        }
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB ejb] : refresh-period-in-seconds is {0}", new Object[]{new Integer(refValue)}));
                    }
                    catch (NumberFormatException nfex) {
                        oneFailed = true;
                        Verifier.debug(nfex);
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-EJB ejb] : refresh-period-in-seconds is invalid. It should be between 0 and 2147483647"));
                    }
                }
            } else if (descriptor instanceof EjbEntityDescriptor && isReadOnly) {
                oneWarning = true;
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB ejb] : refresh-period-in-seconds should be defined for Read Only Beans"));
            } else {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB ejb] : refresh-period-in-seconds is not defined"));
            }
            if (oneWarning) {
                result.setStatus(2);
            }
            if (oneFailed) {
                result.setStatus(1);
            }
        }
        catch (Exception ex) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB cmp] Could not create descriptor Object."));
        }
        return result;
    }
}

