/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceMethodTest;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;

public abstract class InterfaceMatchMethodArgs
extends InterfaceMethodTest {
    protected boolean runIndividualMethodTest(EjbDescriptor descriptor, Method method, Result result) {
        ComponentNameConstructor compName = null;
        try {
            boolean signaturesMatch;
            boolean businessMethodFound;
            compName = new ComponentNameConstructor(descriptor);
            Class<?> methodReturnType = method.getReturnType();
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
            Object[] methodParameterTypes = method.getParameterTypes();
            do {
                Method[] businessMethods = EJBClass.getDeclaredMethods();
                businessMethodFound = false;
                signaturesMatch = false;
                for (int j = 0; j < businessMethods.length; ++j) {
                    if (!method.getName().equals(businessMethods[j].getName())) continue;
                    businessMethodFound = true;
                    Object[] businessMethodParameterTypes = businessMethods[j].getParameterTypes();
                    if (!Arrays.equals(methodParameterTypes, businessMethodParameterTypes)) continue;
                    signaturesMatch = true;
                    break;
                }
                if (businessMethodFound && signaturesMatch) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For " + this.getInterfaceType() + "Interface [ {0} ] method [ {1} ]", new Object[]{method.getDeclaringClass().getName(), method.getName()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding business method with a matching parameters was found."));
                    return true;
                }
                if (!businessMethodFound || signaturesMatch) continue;
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{method.getDeclaringClass().getName(), method.getName()});
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug3", new Object[]{method.getName()});
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug2");
            } while ((EJBClass = EJBClass.getSuperclass()) != null && (!businessMethodFound || !signaturesMatch));
            if (!signaturesMatch) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For" + this.getInterfaceType() + " Interface [ {0} ] method [ {1} ]", new Object[]{method.getDeclaringClass().getName(), method.getName()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No corresponding business method with matching arguments was found for method [ {0} ].", new Object[]{method.getName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: " + this.getInterfaceType() + " interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{this.getClassName(descriptor), descriptor.getName()}));
        }
        return false;
    }

    private String getClassName(EjbDescriptor descriptor) {
        return this.getInterfaceName(descriptor);
    }
}

