/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findermethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.util.Arrays;

public class HomeInterfaceFindMethodMatch
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)) {
                if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
                }
                if (!oneFailed && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
                }
                if (oneFailed) {
                    this.result.setStatus(1);
                } else {
                    this.result.setStatus(0);
                }
                return this.result;
            }
            this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistence}));
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean ejbFindMethodFound = false;
        boolean ejbFinderFound = false;
        boolean signaturesMatch = false;
        boolean oneFailed = false;
        int ejbFinderMethodLoopCounter = 0;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> homeInterfaceClass = jcl.loadClass(home);
            Method[] homeInterfaceMethods = homeInterfaceClass.getDeclaredMethods();
            for (int i = 0; i < homeInterfaceMethods.length; ++i) {
                if (!homeInterfaceMethods[i].getName().startsWith("find")) continue;
                ejbFinderFound = false;
                signaturesMatch = false;
                Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                do {
                    Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                    for (int z = 0; z < ejbFinderMethods.length; ++z) {
                        Object[] ejbFinderMethodParameterTypes;
                        if (!ejbFinderMethods[z].getName().startsWith("ejbFind") || !homeInterfaceMethods[i].getName().toUpperCase().equals(ejbFinderMethods[z].getName().toUpperCase().substring(3))) continue;
                        ejbFinderFound = true;
                        Object[] methodParameterTypes = homeInterfaceMethods[i].getParameterTypes();
                        if (!Arrays.equals(methodParameterTypes, ejbFinderMethodParameterTypes = ejbFinderMethods[z].getParameterTypes())) continue;
                        signaturesMatch = true;
                        ejbFinderMethodLoopCounter = z;
                        break;
                    }
                    if (!ejbFinderFound || !signaturesMatch) continue;
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), homeInterfaceMethods[i].getName()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding [ {0} ] method with matching parameters was found.", new Object[]{ejbFinderMethods[ejbFinderMethodLoopCounter].getName()}));
                } while ((EJBClass = EJBClass.getSuperclass()) != null && (!ejbFinderFound || !signaturesMatch));
                if (ejbFinderFound && !signaturesMatch) {
                    oneFailed = true;
                    this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), homeInterfaceMethods[i].getName()}));
                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A corresponding [ {0} ] method was found, but the parameters did not match.", new Object[]{"ejb" + homeInterfaceMethods[i].getName().toUpperCase().substring(0, 1) + homeInterfaceMethods[i].getName().substring(1)}));
                    continue;
                }
                if (ejbFinderFound) continue;
                oneFailed = true;
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), homeInterfaceMethods[i].getName()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No corresponding ejbFind<METHOD>(...)  method was found."));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] or EJB Class [ {1} ] does not exist or is not loadable.", new Object[]{descriptor.getHomeClassName(), descriptor.getEjbClassName()}));
            return oneFailed;
        }
    }
}

