/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findermethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.lang.reflect.Method;

public class HomeInterfaceFindMethodExceptionRemote
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)) {
                boolean oneFailed = false;
                if (descriptor.getHomeClassName() == null || "".equals(descriptor.getHomeClassName())) {
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable", "No Remote Interface for this Ejb", new Object[0]));
                    return result;
                }
                try {
                    Context context = this.getVerifierContext();
                    ClassLoader jcl = context.getClassLoader();
                    Class<?> c = jcl.loadClass(descriptor.getHomeClassName());
                    Method[] methods = c.getDeclaredMethods();
                    boolean throwsRemoteException = false;
                    for (int i = 0; i < methods.length; ++i) {
                        throwsRemoteException = false;
                        if (!methods[i].getName().startsWith("find")) continue;
                        Class[] methodExceptionTypes = methods[i].getExceptionTypes();
                        if (EjbUtils.isValidRemoteException(methodExceptionTypes)) {
                            throwsRemoteException = true;
                            break;
                        }
                        if (throwsRemoteException) {
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The find<METHOD> method which must throw java.rmi.RemoteException was found."));
                            continue;
                        }
                        if (throwsRemoteException) continue;
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A find<METHOD> method was found, but did not throw java.rmi.RemoteException."));
                    }
                }
                catch (ClassNotFoundException e) {
                    Verifier.debug(e);
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getName()}));
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistence}));
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

