/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findbyprimarykey;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class HomeInterfaceFindByPrimaryKeyReturn
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        if (descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName()) && descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor.getRemoteClassName(), descriptor);
            }
            if (!(oneFailed || descriptor.getLocalHomeClassName() == null || "".equals(descriptor.getLocalHomeClassName()) || descriptor.getLocalClassName() == null || "".equals(descriptor.getLocalClassName()))) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor.getLocalClassName(), descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, String remote, EjbDescriptor descriptor) {
        boolean findByPrimaryKeyMethodFound = false;
        boolean oneFailed = false;
        boolean returnValueValid = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> homeInterfaceClass = jcl.loadClass(home);
            Method[] ejbFinderMethods = homeInterfaceClass.getDeclaredMethods();
            Class<?> rc = jcl.loadClass(remote);
            for (int j = 0; j < ejbFinderMethods.length; ++j) {
                Class<?> returnByPrimaryKeyValue;
                returnValueValid = false;
                if (!ejbFinderMethods[j].getName().equals("findByPrimaryKey")) continue;
                if (!findByPrimaryKeyMethodFound) {
                    findByPrimaryKeyMethodFound = true;
                }
                if ((returnByPrimaryKeyValue = ejbFinderMethods[j].getReturnType()).getName().equals(rc.getName()) && !returnByPrimaryKeyValue.getName().equals("java.util.Collection") && !returnByPrimaryKeyValue.getName().equals("java.util.Enumeration")) {
                    returnValueValid = true;
                }
                if (findByPrimaryKeyMethodFound && returnValueValid) {
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j].getName()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "A findByPrimaryKey method was found with valid return type."));
                    break;
                }
                if (!findByPrimaryKeyMethodFound || returnValueValid) break;
                oneFailed = true;
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j].getName()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A findByPrimaryKey method was found, but with invalid return type."));
                break;
            }
            if (!findByPrimaryKeyMethodFound) {
                oneFailed = true;
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug3", "For Home interface [ {0} ] ", new Object[]{homeInterfaceClass.getName()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No findByPrimaryKey method was found in home interface class [ {0} ].", new Object[]{homeInterfaceClass.getName()}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable.", new Object[]{home}));
            oneFailed = true;
            return oneFailed;
        }
    }
}

