/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.lang.reflect.Method;

public class BusinessMethodException
extends EjbTest
implements EjbCheck {
    Result result = null;
    int foundWarning = 0;
    int foundAtLeastOne = 0;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            boolean remoteInterfaceType = false;
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                remoteInterfaceType = true;
                oneFailed = this.commonToBothInterfaces(remoteInterfaceType, descriptor.getRemoteClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                remoteInterfaceType = false;
                oneFailed = this.commonToBothInterfaces(remoteInterfaceType, descriptor.getLocalClassName(), descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else if (this.foundAtLeastOne == 0) {
                this.result.setStatus(3);
            } else if (this.foundWarning > 0) {
                this.result.setStatus(2);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return this.result;
    }

    private boolean commonToBothInterfaces(boolean remoteInterfaceType, String remote, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> rc = jcl.loadClass(remote);
            boolean businessFound = false;
            boolean throwsRemoteException = false;
            Method[] remoteMethods = rc.getMethods();
            for (int h = 0; h < remoteMethods.length; ++h) {
                if (remoteMethods[h].getDeclaringClass().getName().equals("javax.ejb.EJBObject") || remoteMethods[h].getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject")) continue;
                businessFound = false;
                throwsRemoteException = false;
                Class<?> c = jcl.loadClass(descriptor.getEjbClassName());
                do {
                    Method[] methods = c.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals(remoteMethods[h].getName())) continue;
                        ++this.foundAtLeastOne;
                        businessFound = true;
                        Class[] exceptions = methods[i].getExceptionTypes();
                        if (remoteInterfaceType && EjbUtils.isValidRemoteException(exceptions)) {
                            throwsRemoteException = true;
                        }
                        if (businessFound && !throwsRemoteException) {
                            this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly does not throw java.rmi.RemoteException from business method [ {1} ].", new Object[]{c.getName(), methods[i].getName()}));
                            continue;
                        }
                        if (!businessFound || !throwsRemoteException) continue;
                        this.result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                        this.result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".warning", "Error: Compatibility Note:\n A public business method [ {0} ] was found, but\n EJB 1.0 allowed the business methods to throw the \n java.rmi.RemoteException to indicate a non-application\n exception. This practice is deprecated in EJB 1.1\n ---an EJB 1.1 compliant enterprise bean should\n throw the javax.ejb.EJBException or another \n RuntimeException to indicate non-application exceptions\n to the Container. ", new Object[]{methods[i].getName()}));
                        ++this.foundWarning;
                    }
                } while ((c = c.getSuperclass()) != null && !businessFound);
            }
            if (this.foundAtLeastOne == 0) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", " [ {0} ] does not declare any business methods. ", new Object[]{descriptor.getEjbClassName()}));
            }
            return oneFailed;
        }
        catch (Exception e) {
            e.printStackTrace();
            Verifier.debug(e);
            oneFailed = true;
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{remote, descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

