/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.admin;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Iterator;
import java.util.Set;

public class CheckAdminObjectImpl
extends ConnectorTest
implements ConnectorCheck {
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (!descriptor.hasAdminObjects()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.admin.notApp", "Resource Adapter does not define any administered objects"));
            return result;
        }
        Set adminObjects = descriptor.getAdminObjects();
        boolean oneFailed = false;
        Iterator iter = adminObjects.iterator();
        while (iter.hasNext()) {
            AdminObject adminObj = (AdminObject)iter.next();
            String intf = adminObj.getAdminObjectInterface();
            String impl = adminObj.getAdminObjectClass();
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getRarClassLoader();
            Class<?> implClass = null;
            try {
                implClass = jcl.loadClass(impl);
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.admin.nonexist", "Error: The class [ {0} ] as defined under adminobject-class in the deployment descriptor does not exist", new Object[]{impl}));
                return result;
            }
            if (CheckAdminObjectImpl.isImplementorOf(implClass, intf)) continue;
            oneFailed = true;
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: adminobject-class [ {0} ] does not implement adminobject-interface [ {1} ].", new Object[]{impl, intf}));
            return result;
        }
        if (!oneFailed) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Success: all adminobject-class implement their corresponding adminobject-interface"));
        }
        return result;
    }
}

