/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.gui;

import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.gui.MainPanel;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;

public class MainFrame
extends JFrame {
    private static MainFrame verifierPanel = null;
    private static boolean exitOnClose = false;
    MainPanel mp = null;

    public static JFrame getDeploytoolVerifierFrame(File jarFile) {
        StringManagerHelper.setLocalStringsManager(Verifier.class);
        if (verifierPanel == null) {
            verifierPanel = new MainFrame();
        } else {
            verifierPanel.getMainPanel().reset();
        }
        if (jarFile != null) {
            verifierPanel.getMainPanel().setJarFilename(jarFile.getAbsolutePath());
        }
        return verifierPanel;
    }

    public MainPanel getMainPanel() {
        return this.mp;
    }

    public static boolean getExitOnClose() {
        return exitOnClose;
    }

    public static void setExitOnClose(boolean b) {
        exitOnClose = b;
    }

    public MainFrame() {
        this((String)null);
    }

    public MainFrame(String jarFileName) {
        this(jarFileName, false);
    }

    public MainFrame(String jarFileName, boolean exitOnClose) {
        super(StringManagerHelper.getLocalStringsManager().getLocalString("com.sun.enterprise.tools.verifier.gui.MainFrame.WindowTitle", "Verify Specification Compliance"));
        MainFrame.setExitOnClose(exitOnClose);
        this.getAccessibleContext().setAccessibleName(StringManagerHelper.getLocalStringsManager().getLocalString("com.sun.enterprise.tools.verifier.gui.MainFrame.jfName", "Main Window"));
        this.getAccessibleContext().setAccessibleDescription(StringManagerHelper.getLocalStringsManager().getLocalString("com.sun.enterprise.tools.verifier.gui.MainFrame.jfDesc", "This is the main window of the verifier tool"));
        if (exitOnClose) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        Container contentPane = this.getContentPane();
        this.mp = new MainPanel(this, jarFileName);
        contentPane.add(this.mp);
    }
}

