/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.CLIPParser;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.LongOption;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Initializer {
    private LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private FrameworkContext frameworkContext = new FrameworkContext();
    private String FO_Str = "Failures only";
    private String WFO_Str = "Warning and Failures only";
    private String AO_Str = "All";
    private final int FAIL = 0;
    private final int WARN = 1;
    private final int ALL = 2;

    public Initializer(String[] args) {
        this.parseArgs(args);
    }

    public FrameworkContext getFrameworkContext() {
        return this.frameworkContext;
    }

    private void parseArgs(String[] argv) {
        int c;
        LongOption[] longopts = new LongOption[16];
        StringBuffer sb = new StringBuffer();
        longopts[0] = new LongOption("help", false, null, 104);
        longopts[1] = new LongOption("timestamp", false, null, 116);
        longopts[2] = new LongOption("verbose", false, null, 118);
        longopts[3] = new LongOption("version", false, null, 86);
        longopts[4] = new LongOption("destdir", true, sb, 100);
        longopts[5] = new LongOption("reportlevel", true, sb, 114);
        longopts[6] = new LongOption("gui", false, null, 117);
        longopts[7] = new LongOption("app", false, null, 97);
        longopts[8] = new LongOption("appclient", false, null, 112);
        longopts[9] = new LongOption("connector", false, null, 99);
        longopts[10] = new LongOption("ejb", false, null, 101);
        longopts[11] = new LongOption("web", false, null, 119);
        longopts[12] = new LongOption("webservices", false, null, 115);
        longopts[13] = new LongOption("webservicesclient", false, null, 108);
        longopts[14] = new LongOption("runtimetests", false, null, 82);
        longopts[15] = new LongOption("configdir", false, null, 67);
        String[] levels = new String[]{"a", "w", "f", "all", "warnings", "failures"};
        CLIPParser parser = null;
        parser = new CLIPParser("verifier", argv, "-:vtVhud:r:apcewslRC:", longopts);
        block21: while ((c = parser.getopt()) != -1) {
            switch (c) {
                case 0: {
                    String arg = parser.getOptarg();
                    this.processValidLongOpt((char)new Integer(sb.toString()).intValue(), arg, levels);
                    continue block21;
                }
                case 118: {
                    this.logger.setLevel(Level.FINEST);
                    Handler[] handler = Logger.getLogger("").getHandlers();
                    for (int i = 0; i < handler.length; ++i) {
                        handler[i].setLevel(Level.FINEST);
                    }
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.verboseFlag");
                    continue block21;
                }
                case 116: {
                    this.frameworkContext.setUseTimeStamp(true);
                    continue block21;
                }
                case 104: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.helpMessage");
                    this.usage();
                    continue block21;
                }
                case 86: {
                    this.logger.log(Level.INFO, this.getClass().getName() + ".Version");
                    System.exit(0);
                    continue block21;
                }
                case 117: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.startGUI");
                    this.frameworkContext.setUsingGui(true);
                    continue block21;
                }
                case 114: {
                    String arg = parser.getOptarg();
                    if (arg == null) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-r"});
                        this.usage();
                        continue block21;
                    }
                    boolean validLevel = false;
                    for (int i = 0; i < levels.length; ++i) {
                        if (!arg.equals(levels[i])) continue;
                        validLevel = true;
                        break;
                    }
                    if (!validLevel) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidreplevel", new Object[]{"verifier", arg});
                        this.usage();
                        continue block21;
                    }
                    this.setReportingLevel(arg.charAt(0));
                    continue block21;
                }
                case 100: {
                    String arg = parser.getOptarg();
                    if (arg == null) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-d"});
                        this.usage();
                        continue block21;
                    }
                    if (this.verifyAndSetResultDir(arg)) continue block21;
                    this.usage();
                    continue block21;
                }
                case 58: {
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqsarg", new Object[]{"verifier", new Character((char)parser.getOptopt()).toString()});
                    this.usage();
                    continue block21;
                }
                case 97: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.app");
                    this.frameworkContext.setApp(true);
                    this.frameworkContext.setPartition(true);
                    continue block21;
                }
                case 112: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.appclient");
                    this.frameworkContext.setAppClient(true);
                    this.frameworkContext.setPartition(true);
                    continue block21;
                }
                case 99: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.connector");
                    this.frameworkContext.setConnector(true);
                    this.frameworkContext.setPartition(true);
                    continue block21;
                }
                case 101: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.ejb");
                    this.frameworkContext.setEjb(true);
                    this.frameworkContext.setPartition(true);
                    continue block21;
                }
                case 119: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.web");
                    this.frameworkContext.setWeb(true);
                    this.frameworkContext.setPartition(true);
                    continue block21;
                }
                case 115: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.webservices");
                    this.frameworkContext.setWebServices(true);
                    this.frameworkContext.setPartition(true);
                    continue block21;
                }
                case 108: {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.webservicesclient");
                    this.frameworkContext.setWebServicesClient(true);
                    this.frameworkContext.setPartition(true);
                    continue block21;
                }
                case 63: {
                    char x = (char)parser.getOptopt();
                    if (x == '?') {
                        this.usage();
                    }
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidarg", new Object[]{"verifier", new Character(x).toString()});
                    this.usage();
                    continue block21;
                }
                case 82: {
                    this.frameworkContext.setAreRuntimeTestsNeeded(false);
                    continue block21;
                }
                case 67: {
                    String arg = parser.getOptarg();
                    if (arg == null || !new File(arg).exists()) {
                        this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-C"});
                        this.usage();
                    }
                    this.frameworkContext.setConfigDirStr(arg);
                    continue block21;
                }
            }
            this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidarg", new Object[]{"verifier", new Character((char)c).toString()});
            this.usage();
        }
        int i = parser.getOptind();
        if (i < argv.length) {
            File jarFile = new File(argv[i]);
            if (!jarFile.exists()) {
                this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidArchive", new Object[]{argv[i]});
                this.usage();
            }
            this.frameworkContext.setJarFileName(jarFile.getPath());
            this.logger.log(Level.FINE, this.getClass().getName() + ".debug.jarFileName", new Object[]{this.frameworkContext.getJarFileName()});
            ++i;
            while (i < argv.length) {
                this.logger.log(Level.INFO, this.getClass().getName() + ".extraargs", new Object[]{"verifier", argv[i]});
                ++i;
            }
        } else if (!this.frameworkContext.isUsingGui()) {
            this.logger.log(Level.SEVERE, this.getClass().getName() + ".jarmissing", new Object[]{"verifier"});
            this.usage();
        }
        if (this.frameworkContext.isUsingGui()) {
            MainFrame mf = new MainFrame(this.frameworkContext.getJarFileName(), true);
            mf.setSize(800, 600);
            mf.setVisible(true);
        }
        this.logger.log(Level.FINE, this.getClass().getName() + ".debug.endParseArgs");
    }

    private void processValidLongOpt(int c, String arg, String[] levels) {
        switch (c) {
            case 118: {
                this.logger.setLevel(Level.FINEST);
                Handler[] handler = Logger.getLogger("").getHandlers();
                for (int i = 0; i < handler.length; ++i) {
                    handler[i].setLevel(Level.FINEST);
                }
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.verboseFlag");
                break;
            }
            case 116: {
                this.frameworkContext.setUseTimeStamp(true);
                break;
            }
            case 104: {
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.helpMessage");
                this.usage();
                break;
            }
            case 86: {
                this.logger.log(Level.INFO, this.getClass().getName() + ".Version");
                System.exit(0);
                break;
            }
            case 117: {
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.startGUI");
                this.frameworkContext.setUsingGui(true);
                break;
            }
            case 114: {
                if (arg == null) {
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-r"});
                    this.usage();
                    break;
                }
                boolean validLevel = false;
                for (int i = 0; i < levels.length; ++i) {
                    if (!arg.equals(levels[i])) continue;
                    validLevel = true;
                    break;
                }
                if (!validLevel) {
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidreplevel", new Object[]{"verifier", arg});
                    this.usage();
                    break;
                }
                this.setReportingLevel(arg.charAt(0));
                break;
            }
            case 100: {
                if (arg == null) {
                    this.logger.log(Level.SEVERE, this.getClass().getName() + ".reqargs", new Object[]{"verifier", "-d"});
                    this.usage();
                    break;
                }
                if (this.verifyAndSetResultDir(arg)) break;
                this.usage();
                break;
            }
            default: {
                this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidarg", new Object[]{"verifier", new Character((char)c).toString()});
                this.usage();
            }
        }
    }

    private void setReportingLevel(char c) {
        boolean setWarningLevelOnce = false;
        switch (c) {
            case 'w': {
                if (!setWarningLevelOnce) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.displayWarningFailures");
                    this.frameworkContext.setReportLevel(1);
                    setWarningLevelOnce = true;
                    break;
                }
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.reportLevel", new Object[]{this.getReportLevelString(this.frameworkContext.getReportLevel())});
                break;
            }
            case 'f': {
                if (!setWarningLevelOnce) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.displayFailures");
                    this.frameworkContext.setReportLevel(0);
                    setWarningLevelOnce = true;
                    break;
                }
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.reportLevel", new Object[]{this.getReportLevelString(this.frameworkContext.getReportLevel())});
                break;
            }
            case 'a': {
                if (!setWarningLevelOnce) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug.displayAll");
                    this.frameworkContext.setReportLevel(2);
                    setWarningLevelOnce = true;
                    break;
                }
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug.reportLevel", new Object[]{this.getReportLevelString(this.frameworkContext.getReportLevel())});
                break;
            }
            default: {
                this.logger.log(Level.SEVERE, this.getClass().getName() + ".invalidreplevel", new Object[]{"verifier", new Character(c).toString()});
                this.usage();
            }
        }
    }

    private void usage() {
        if (!this.frameworkContext.isUsingGui()) {
            this.logger.log(Level.INFO, this.getUsageString());
            System.exit(1);
        }
    }

    private String getUsageString() {
        String usage = "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine1", "usage: VERIFIER [optional_params] <jarFile>") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine2", "where :") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine3", "  [optional_params]: Must be: ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine5", "    -d|--destdir <destination dir> : Verifier results are put in the specified existing directory") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine34", "     -t|--timestamp : verifier results are generated with timestamp appended to it") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine16", "   -h|--help|-?     : display verifier help") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine7", "    -u|--gui      : use Verifier GUI") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine4", "     -v|--verbose : verbose debug turned on ") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine17", "   -V|--version   : display verifier tool version") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine8", "          (Note: Overrides default behavior, ") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine9", "                 required jarFile not needed)") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine10", "   -r|--reportlevel : result reporting level") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine11", "   level=   a|all : set output report level to display all results") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine14", "            f|failures : set output report level to display only failure") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine15", "            results") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine12", "            w|warnings : set output report level to display only warning and") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine13", "            failure results") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine27", "   -a|--app         : run only the Application tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine28", "   -p|--appclient   : run only the Application Client tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine29", "   -c|--connector   : run only the Connector tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine30", "   -e|--ejb         : run only the EJB tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine31", "   -w|--web         : run only the Web tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine32", "   -s|--webservices : run only the WebServices tests") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine33", "   -l|--webservicesclient : run only the WebServicesClient tests") + "\n\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine19", "    Note: The default mode is non-verbose mode and the default reportlevel is to display all results.\n   In verbose mode, the status of each running each test is displayed on the console.\n ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine20", "<jarFile>: ear/war/jar/rar file to perform static verification on ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine21", "Below is an example which runs verifier in verbose mode") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine22", "and writes all the results of static verification of ") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine23", "file sample.ear to the destination directory /verifierresults") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine24", " verifier -v -ra -d /verifierresults sample.ear") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine25", " The results get generated in both text and xml format.") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine26", " Two result files, sample.ear.txt and sample.ear.xml, will be created.") + "\n\n";
        return usage;
    }

    private boolean verifyAndSetResultDir(String name) {
        File outputDir = new File(name);
        if (outputDir.exists()) {
            if (outputDir.isDirectory()) {
                if (outputDir.canWrite()) {
                    this.frameworkContext.setOutputDirName(name);
                    return true;
                }
                this.logger.log(Level.SEVERE, this.getClass().getName() + ".log.noPermissions", new Object[]{name});
                return false;
            }
            this.logger.log(Level.SEVERE, this.getClass().getName() + ".log.notADir", new Object[]{name});
            return false;
        }
        this.logger.log(Level.SEVERE, this.getClass().getName() + ".log.noDirExists", new Object[]{name});
        return false;
    }

    private String getReportLevelString(int rl) {
        String rls = "";
        if (rl == 0) {
            rls = this.FO_Str;
        } else if (rl == 1) {
            rls = this.WFO_Str;
        } else if (rl == 2) {
            rls = this.AO_Str;
        }
        return rls;
    }
}

