/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.tools.verifier.VerifyThread;
import com.sun.enterprise.util.OS;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Logger;

public class AppVerifier {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    private String[] cmdStrings;
    private long mTimeoutMilliseconds = 0L;
    private static final long DEFAULT_TIMEOUT_SEC = 600L;
    public static final long kSleepTime = 2000L;
    private Process mSubProcess = null;
    private int mExitValue = -1;
    String archive = null;

    public AppVerifier(String archive) {
        this.archive = archive;
    }

    private void init() {
        String installDir = System.getProperty("com.sun.aas.installRoot");
        String appservResultDir = System.getProperty("java.io.tmpdir");
        this.cmdStrings = OS.isUnix() ? new String[]{installDir + File.separator + "bin" + File.separator + "verifier", "-t", "-d", appservResultDir, this.archive} : new String[]{"cmd.exe", "/C", installDir + File.separator + "bin" + File.separator + "verifier", "-t", "-d", appservResultDir, this.archive};
        this.mTimeoutMilliseconds = 1800000L;
    }

    public int verify() {
        try {
            this.init();
            if (OS.isUnix()) {
                this.mSubProcess = Runtime.getRuntime().exec(this.cmdStrings);
            } else {
                String[] env = new String[]{"AS_VERIFIER_BACKEND=TRUE"};
                this.mSubProcess = Runtime.getRuntime().exec(this.cmdStrings, env);
            }
            new VerifyThread(this.mSubProcess.getInputStream(), _logger).start();
            new VerifyThread(this.mSubProcess.getErrorStream(), _logger).start();
            long timeBefore = System.currentTimeMillis();
            boolean isSubProcessFinished = false;
            while (true) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    this.mExitValue = this.mSubProcess.exitValue();
                    isSubProcessFinished = true;
                }
                catch (IllegalThreadStateException itse) {
                    long timeAfter;
                    if ((timeAfter = System.currentTimeMillis()) - timeBefore < this.mTimeoutMilliseconds) continue;
                }
                break;
            }
            if (!isSubProcessFinished) {
                this.mSubProcess.destroy();
                this.mExitValue = -255;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mExitValue = -1;
        }
        return this.mExitValue;
    }
}

