/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.launcher;

import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.tools.launcher.ProcessLauncherConfig;
import com.sun.enterprise.util.ASenvPropertyReader;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.net.NetUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;

public class ProcessLauncher {
    protected static final String RELATIVE_LOCATION_DOMAIN_XML = "/config/domain.xml";
    protected static final String CLASSPATH_ENV_NAME = "CLASSPATH";
    protected static final String JAVA_HOME_PROPERTY = "JAVA_HOME";
    protected static final String LAUNCHER_PROFILE_NAME = "com.sun.aas.processName";
    protected static final String LAUNCHER_RETURN_FUNCTION = "com.sun.aas.launcherReturn";
    protected static final String LAUNCHER_RETURN_FUNCTION_WAIT = "hold";
    protected static final String LAUNCHER_SCRIPT_LOCATION = "bin";
    protected static final String LAUNCHER_START_ACTION = "start";
    protected static final String LAUNCHER_STOP_ACTION = "stop";
    protected static final String INTERNAL_SERVER_PROFILE = "s1as8-server";
    protected static final String INTERNAL_NODE_AGENT_PROFILE = "s1as8-nodeagent";
    protected static final int SLEEP_TIME_FOR_PROCESS_START = 2000;
    protected static final String COMMAND_LINE_ARG_VERBOSE = "verbose";
    protected static final String COMMAND_LINE_ARG_DEBUG = "debug";
    protected static final String COMMAND_LINE_ARG_DISPLAY = "display";
    protected static final String COMMAND_LINE_ARG_NATIVE = "native";
    protected static final char[] COMMAND_DELIMITER_LIST = new char[]{'_', '+', '^', '@', '!', '?', '(', ')', '~', '`', '{', '}'};
    public static final String DEBUG_OPTIONS = "com.sun.aas.jdwpOptions";
    public static final String VERBOSE_SYSTEM_PROPERTY = "com.sun.aas.verboseMode";
    public static final String LOGFILE_SYSTEM_PROPERTY = "com.sun.aas.defaultLogFile";
    public static final String PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY = "com.sun.aas.promptForIdentity";
    private Logger _logger = null;
    private String[] _args = null;
    private static boolean bDebug = false;

    public static void main(String[] args) {
        ProcessLauncher pl = new ProcessLauncher();
        pl.process(args);
    }

    public static void bootstrap(String[] args) {
        ProcessLauncher pl = new ProcessLauncher();
        String profile = "s1as-deploytool";
        if (args != null && args.length >= 1) {
            profile = args[0];
            String[] newArgs = new String[args.length - 1];
            for (int ii = 0; ii < newArgs.length; ++ii) {
                newArgs[ii] = args[ii + 1];
            }
            args = newArgs;
        }
        System.setProperty(LAUNCHER_PROFILE_NAME, profile);
        if (bDebug) {
            System.out.println("bootstrapping profile - " + profile);
        }
        pl.process(args);
    }

    public void process(String[] args) {
        int iRet = 1;
        try {
            this.setArgs(args);
            if (System.getProperty("Debug") != null) {
                bDebug = true;
            }
            if (this.isVerboseEnabled() && !this.isDisplayEnabled()) {
                System.setProperty(VERBOSE_SYSTEM_PROPERTY, "true");
            }
            String passArg = null;
            passArg = args != null && args.length >= 1 ? args[0] : LAUNCHER_START_ACTION;
            if (bDebug) {
                System.out.println("ProcessLauncher Building command ..");
            }
            Command command = this.buildCommand(passArg);
            if (bDebug) {
                System.out.println("ProcessLauncher Executing command ..");
            }
            this.executeCommand(command, passArg);
            iRet = 0;
        }
        catch (ConfigException ce) {
            this.getLogger().log(Level.SEVERE, "launcher.config_exception", ce);
            ce.printStackTrace();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "enterprise.launcher_exception_startup", e);
            e.printStackTrace();
        }
        System.exit(iRet);
    }

    public void executeCommand(Command command, String action) throws IOException {
        String[] cmd = null;
        if (this.isDisplayEnabled()) {
            int ii;
            command.removeArg(COMMAND_LINE_ARG_DISPLAY);
            command.removeArg(COMMAND_LINE_ARG_NATIVE);
            String launcherRet = System.getProperty(LAUNCHER_RETURN_FUNCTION);
            if (launcherRet != null) {
                if (bDebug) {
                    System.out.println("-Dcom.sun.aas.launcherReturn=" + launcherRet);
                }
                command.addSystemVariable("-Dcom.sun.aas.launcherReturn=" + launcherRet);
            }
            cmd = command.getCommandInJNIFormatAsArray();
            boolean found = false;
            String sxDelim = "|";
            for (ii = 0; ii < COMMAND_DELIMITER_LIST.length; ++ii) {
                found = false;
                for (int jj = 0; jj < cmd.length; ++jj) {
                    if (cmd[jj].indexOf(COMMAND_DELIMITER_LIST[ii]) >= 0) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                sxDelim = String.valueOf(COMMAND_DELIMITER_LIST[ii]);
                break;
            }
            System.out.print("STARTOFCOMMAND" + sxDelim);
            for (ii = 0; ii < cmd.length; ++ii) {
                System.out.print(cmd[ii] + sxDelim);
            }
            System.out.print("ENDOFCOMMAND" + sxDelim);
        } else {
            this.executeBackgroundCommand(command, this.isVerboseEnabled(), action);
        }
    }

    protected void preBuildProcessing() {
    }

    public void executeBackgroundCommand(Command command, boolean verbose, String action) throws IOException {
        this.getLogger().log(Level.FINE, "ProcessLauncher: executing Runtime execute...");
        String[] cmd = command.getCommandAsArray();
        Process process = Runtime.getRuntime().exec(cmd);
        if (System.getProperty(PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY) != null && action.equals(LAUNCHER_START_ACTION)) {
            this.sendInputToProcessInput(System.in, process);
        }
        StreamFlusher sfErr = new StreamFlusher(process.getErrorStream(), System.err, command.getLogFile());
        sfErr.start();
        if (verbose || this.isWaitEnabled()) {
            StreamFlusher sfOut = new StreamFlusher(process.getInputStream(), System.out, command.getLogFile());
            sfOut.start();
            try {
                process.waitFor();
                sfOut.join();
                sfErr.join();
            }
            catch (InterruptedException ie) {
                System.out.println("While waiting in verbose mode, an InterruptedException was thrown ");
            }
        } else {
            StreamFlusher sfOut = new StreamFlusher(process.getInputStream(), System.out);
            sfOut.start();
            String logFile = command.getLogFile();
            if (logFile != null) {
                System.out.println(StringManager.getManager(ProcessLauncher.class).getString("launcher.redirecting.output", logFile));
            }
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void sendInputToProcessInput(InputStream in, Process subProcess) {
        block13: {
            if (in == null || subProcess == null) {
                return;
            }
            PrintWriter out = null;
            BufferedReader br = null;
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(subProcess.getOutputStream())));
            br = new BufferedReader(new InputStreamReader(System.in));
            String sxLine = null;
            while ((sxLine = br.readLine()) != null) {
                out.println(sxLine);
                if (!bDebug) continue;
                System.out.println("Feeding in Line:" + sxLine);
            }
            out.flush();
            Object var7_7 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block13;
            }
            catch (Throwable t) {}
            break block13;
            {
                catch (Exception e) {
                    this.getLogger().log(Level.INFO, "WRITE TO INPUT ERROR", e);
                    Object var7_8 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block13;
                    }
                    catch (Throwable t) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public Command buildCommand(String action) throws ConfigException {
        this.preBuildProcessing();
        String processName = System.getProperty(LAUNCHER_PROFILE_NAME, INTERNAL_SERVER_PROFILE);
        Command command = null;
        command = this.isServerProfile() ? this.buildInternalCommand(action) : this.buildExternalCommand(action);
        String finalCommand = command.toStringWithLines();
        this.getLogger().log(Level.INFO, finalCommand);
        return command;
    }

    public Command buildInternalCommand(String action) throws ConfigException {
        String locale;
        StringManager _strMgr = StringManager.getManager(ProcessLauncher.class);
        String domainXMLLocation = System.getProperty("com.sun.aas.instanceRoot") + RELATIVE_LOCATION_DOMAIN_XML;
        ConfigContext configCtxt = ConfigFactory.createConfigContext(domainXMLLocation);
        Domain domain = ConfigAPIHelper.getDomainConfigBean(configCtxt);
        String serverName = System.getProperty("com.sun.aas.instanceName");
        Server server = ServerHelper.getServerByName(configCtxt, serverName);
        String configRef = server.getConfigRef();
        Command command = new Command();
        Config config = ServerHelper.getConfigForServer(configCtxt, serverName);
        String logFile = this.configureLogService(config);
        if (bDebug) {
            System.out.println("LOGFILE = " + logFile);
        }
        this.createFileStructure(logFile);
        command.setLogFile(logFile);
        command.addSystemVariable("-Dcom.sun.aas.defaultLogFile=" + logFile);
        this.getLogger().log(Level.FINE, "Retrieved domain.xml from " + domainXMLLocation);
        this.getLogger().log(Level.FINE, "Start building the command the to execute.");
        ASenvPropertyReader reader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"));
        reader.setSystemProperties();
        if (this.isVerboseEnabled()) {
            command.addSystemVariable("-Dcom.sun.aas.verboseMode=true");
            System.setProperty(VERBOSE_SYSTEM_PROPERTY, "true");
        }
        String launcherConfigFile = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "processLauncher.xml";
        String processName = System.getProperty(LAUNCHER_PROFILE_NAME, INTERNAL_SERVER_PROFILE);
        this.getLogger().log(Level.FINE, "Loading ProcessLauncher config from: " + launcherConfigFile + " - for the process named: " + processName);
        ProcessLauncherConfig plConfig = new ProcessLauncherConfig(launcherConfigFile, processName);
        Properties systemProperties = plConfig.getSystemProperties();
        this.addSystemProperties(domain.getSystemProperty(), systemProperties);
        System.setProperty("com.sun.aas.configName", configRef);
        systemProperties.put("com.sun.aas.configName", configRef);
        JavaConfig javaConfig = config.getJavaConfig();
        String jvmCmd = javaConfig.getJavaHome() + File.separator + LAUNCHER_SCRIPT_LOCATION + File.separator + "java";
        command.setJavaCommand(jvmCmd);
        if (!action.equals(LAUNCHER_STOP_ACTION) && (javaConfig.isDebugEnabled() || this.isDebugEnabled())) {
            this.addDebugOptions(command, javaConfig.getDebugOptions());
        }
        if ((locale = domain.getLocale()) == null || locale.equals("")) {
            locale = System.getProperty("com.sun.aas.defaultLocale");
        }
        if (locale != null && !locale.equals("")) {
            command.addSystemVariable("-Dcom.sun.aas.defaultLocale=" + locale);
        }
        String[] jvmOptions = javaConfig.getJvmOptions();
        this.addJvmArguments(command, jvmOptions);
        String profilerClasspath = null;
        Profiler profiler = javaConfig.getProfiler();
        if (profiler != null && profiler.isEnabled()) {
            this.addElementProperties(profiler.getElementProperty(), systemProperties);
            jvmOptions = profiler.getJvmOptions();
            this.addJvmArguments(command, jvmOptions);
            profilerClasspath = profiler.getClasspath();
        }
        this.addSystemProperties(config.getSystemProperty(), systemProperties);
        if (ServerHelper.isServerClustered(configCtxt, server)) {
            Cluster cluster = ClusterHelper.getClusterForInstance(configCtxt, server.getName());
            this.addSystemProperties(cluster.getSystemProperty(), systemProperties);
        }
        this.addSystemProperties(server.getSystemProperty(), systemProperties);
        if (OS.isWindows()) {
            jvmCmd = jvmCmd.replace('/', '\\');
        }
        if (jvmCmd.startsWith(System.getProperty("com.sun.aas.javaRoot"))) {
            jvmCmd = null;
        }
        String classpath = this.deriveClasspath(plConfig, jvmCmd, javaConfig, profilerClasspath);
        this.getLogger().log(Level.FINE, "Complete process classpath = " + classpath);
        command.setClasspath(classpath);
        command.setMainClass(plConfig.getMainClass());
        this.deriveNativeClasspath(command, javaConfig, profiler, systemProperties);
        Iterator<Object> it = systemProperties.keySet().iterator();
        String key = null;
        String property = null;
        String value = null;
        while (it.hasNext()) {
            key = (String)it.next();
            value = systemProperties.getProperty(key);
            if (key.startsWith("-")) {
                property = key;
                if (value != null && !value.equals("")) {
                    property = property + "=" + value;
                }
                command.addJvmOption(property);
                this.getLogger().log(Level.FINE, "JVM Option: " + property);
                continue;
            }
            property = "-D" + key + "=" + value;
            command.addSystemVariable(property);
            this.getLogger().log(Level.FINE, "System Property: " + property);
        }
        String[] args = this.getArgs();
        for (int ii = 0; ii < args.length; ++ii) {
            command.addArg(args[ii]);
        }
        return command;
    }

    public Command buildExternalCommand(String action) throws ConfigException {
        Command command = new Command();
        this.getLogger().log(Level.FINE, "Start building the command the to execute.");
        String launcherConfigFile = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "processLauncher.xml";
        String processName = System.getProperty(LAUNCHER_PROFILE_NAME, INTERNAL_NODE_AGENT_PROFILE);
        this.getLogger().log(Level.FINE, "Loading ProcessLauncher config from: " + launcherConfigFile + " - for the process named: " + processName);
        String configRoot = System.getProperty("com.sun.aas.configRoot");
        if (configRoot == null) {
            configRoot = System.getProperty("com.sun.aas.installRoot") + File.separator + "config";
        }
        ASenvPropertyReader reader = new ASenvPropertyReader(configRoot);
        reader.setSystemProperties();
        if (this.isVerboseEnabled()) {
            command.addSystemVariable("-Dcom.sun.aas.verboseMode=true");
            System.setProperty(VERBOSE_SYSTEM_PROPERTY, "true");
        }
        ProcessLauncherConfig plConfig = new ProcessLauncherConfig(launcherConfigFile, processName);
        Properties systemProperties = plConfig.getSystemProperties();
        String logFile = systemProperties.getProperty(LOGFILE_SYSTEM_PROPERTY);
        if (bDebug) {
            System.out.println("Is external command nodeagent - " + this.isNodeAgentProfile());
        }
        if (this.isNodeAgentProfile()) {
            this.getLogger().log(Level.FINE, "BuildExternalCommand for NodeAgent");
            try {
                String domainXMLLocation = System.getProperty("com.sun.aas.instanceRoot") + RELATIVE_LOCATION_DOMAIN_XML;
                ConfigContext configCtxt = ConfigFactory.createConfigContext(domainXMLLocation);
                Domain domain = ConfigAPIHelper.getDomainConfigBean(configCtxt);
                String nodeAgentName = System.getProperty("com.sun.aas.instanceName");
                NodeAgent nodeAgent = NodeAgentHelper.getNodeAgentByName(configCtxt, nodeAgentName);
                LogService logService = nodeAgent.getLogService();
                if (logService != null) {
                    this.getLogger().log(Level.FINE, "LogService found for nodeagent");
                    String logFileX = logService.getFile();
                    if (logFileX != null) {
                        logFile = logFileX;
                        systemProperties.setProperty(LOGFILE_SYSTEM_PROPERTY, logFile);
                    }
                    String logLevel = logService.getModuleLogLevels().getNodeAgent();
                    this.getLogger().setLevel(Level.parse(logLevel));
                }
            }
            catch (ConfigException ce) {
                this.getLogger().log(Level.FINE, "domain.xml does not exist yet for the nodeagent");
            }
        }
        if (logFile != null) {
            if (this.createFileStructure(logFile) && !this.isInternalLogger()) {
                this.addLogFileToLogger(logFile);
            }
            command.setLogFile(logFile);
        }
        String javaHome = System.getProperty(JAVA_HOME_PROPERTY);
        String javaCall = "java";
        String javaCmd = null;
        if (OS.isWindows()) {
            javaCall = "javaw";
        }
        if (javaHome != null) {
            javaCmd = javaHome + File.separator + LAUNCHER_SCRIPT_LOCATION + File.separator + javaCall;
        } else {
            String javaInt = System.getProperty("java.home");
            javaCmd = javaInt + File.separator + LAUNCHER_SCRIPT_LOCATION + File.separator + javaCall;
        }
        command.setJavaCommand(javaCmd);
        String classpath = this.deriveClasspath(plConfig, null);
        command.setClasspath(classpath);
        command.setMainClass(plConfig.getMainClass());
        Iterator<Object> it = systemProperties.keySet().iterator();
        String key = null;
        String property = null;
        String value = null;
        while (it.hasNext()) {
            key = (String)it.next();
            value = systemProperties.getProperty(key);
            if (key.startsWith("-")) {
                property = key;
                if (value != null && !value.equals("")) {
                    property = property + "=" + value;
                }
                if (key.equals("-client") || key.equals("-server")) {
                    command.setMode(key);
                    continue;
                }
                command.addJvmOption(property);
                continue;
            }
            property = "-D" + key + "=" + value;
            command.addSystemVariable(property);
        }
        command.addSystemVariable("-Djava.library.path=" + this.deriveNativeClasspath(command, null, null, systemProperties));
        String[] args = this.getArgs();
        for (int ii = 0; ii < args.length; ++ii) {
            command.addArg(args[ii]);
        }
        return command;
    }

    protected String configureLogService(Config config) {
        String logFile = "";
        LogService logService = config.getLogService();
        if (logService != null) {
            logFile = logService.getFile();
            String logLevel = logService.getModuleLogLevels().getAdmin();
            this.getLogger().setLevel(Level.parse(logLevel));
        }
        return logFile;
    }

    protected String deriveClasspath(ProcessLauncherConfig plConfig, String jvmCmd) {
        return this.deriveClasspath(plConfig, jvmCmd, null, null);
    }

    protected String deriveClasspath(ProcessLauncherConfig plConfig, String jvmCmd, JavaConfig javaConfig, String profilerClasspath) {
        String libDir = RelativePathResolver.resolvePath(plConfig.getClasspathLibDir());
        String classpath = Classpath.getLibClasspath(libDir, plConfig.getClasspathIncludes(), plConfig.getClasspathExcludes());
        this.getLogger().log(Level.FINE, "Derived Classpath from " + libDir + " - \n" + classpath);
        String javaVersion = System.getProperty("java.version");
        if (jvmCmd != null) {
            try {
                Process process = Runtime.getRuntime().exec(jvmCmd + " -version");
                ByteArrayOutputStream baosOut = new ByteArrayOutputStream();
                ByteArrayOutputStream baosErr = new ByteArrayOutputStream();
                StreamFlusher sfOut = new StreamFlusher(process.getInputStream(), baosOut);
                StreamFlusher sfErr = new StreamFlusher(process.getErrorStream(), baosErr);
                sfOut.start();
                sfErr.start();
                process.waitFor();
                javaVersion = baosErr.toString();
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINE, "Java version retrieving error, will default to 1.5 or later!", e);
            }
        }
        String prefix = "";
        String jvmv = "";
        if (javaVersion.indexOf("1.4") >= 0) {
            jvmv = "j2se 1.4";
            prefix = plConfig.getClasspathJ2se14Prefix();
        } else {
            jvmv = "j2se 1.5 or later";
            prefix = plConfig.getClasspathJ2se15OrLaterPrefix();
        }
        this.getLogger().log(Level.FINE, "Java version being used is: ->" + jvmv + "<- based on ->" + javaVersion + "<-");
        if (prefix != null && !prefix.equals("")) {
            prefix = RelativePathResolver.resolvePath(prefix);
            classpath = classpath.equals("") ? prefix : prefix + File.pathSeparator + classpath;
        }
        if ((prefix = plConfig.getClasspathPrefix()) != null && !prefix.equals("")) {
            prefix = RelativePathResolver.resolvePath(prefix);
            classpath = classpath.equals("") ? prefix : prefix + File.pathSeparator + classpath;
        }
        if (javaConfig != null) {
            String classpathPrefix = javaConfig.getClasspathPrefix();
            String classpathServer = javaConfig.getServerClasspath();
            String classpathSuffix = javaConfig.getClasspathSuffix();
            if (classpathServer != null) {
                classpath = classpath + File.pathSeparator + classpathServer;
            }
            if (classpathPrefix != null) {
                classpath = classpathPrefix + File.pathSeparator + classpath;
            }
            if (classpathSuffix != null) {
                classpath = classpath + File.pathSeparator + classpathSuffix;
            }
            if (profilerClasspath != null) {
                classpath = classpath + File.pathSeparator + profilerClasspath;
            }
            if (!javaConfig.isEnvClasspathIgnored()) {
                String envClassPath = "";
                String[] sxEnv = new CliUtil().getAllEnv();
                for (int ii = 0; ii < sxEnv.length; ++ii) {
                    if (!sxEnv[ii].trim().startsWith(CLASSPATH_ENV_NAME)) continue;
                    String userCp = sxEnv[ii].substring(CLASSPATH_ENV_NAME.length() + 1).trim();
                    classpath = classpath + (userCp.equals("") ? "" : File.pathSeparator + userCp);
                    break;
                }
            }
        }
        this.getLogger().log(Level.FINE, "Final classpath - \n" + classpath);
        if (bDebug) {
            System.out.println("Final classpath=" + classpath);
        }
        return classpath;
    }

    protected String deriveNativeClasspath(Command command, JavaConfig javaConfig, Profiler profiler, Properties systemProperties) {
        String javaLibPath = System.getProperty("java.library.path");
        if (bDebug) {
            System.out.println("Current java.library.path=" + javaLibPath + "\n");
        }
        if (javaLibPath == null) {
            javaLibPath = "";
        }
        if (javaConfig != null) {
            String nativePrefix = javaConfig.getNativeLibraryPathPrefix();
            String nativeSuffix = javaConfig.getNativeLibraryPathSuffix();
            String nativeProfiler = null;
            if (profiler != null && profiler.isEnabled()) {
                nativeProfiler = profiler.getNativeLibraryPath();
            }
            if (nativePrefix != null && !nativePrefix.trim().equals("")) {
                javaLibPath = nativePrefix + (javaLibPath.equals("") ? "" : File.pathSeparator + javaLibPath);
            }
            if (nativeSuffix != null && !nativeSuffix.trim().equals("")) {
                javaLibPath = (javaLibPath.equals("") ? "" : javaLibPath + File.pathSeparator) + nativeSuffix;
            }
            if (nativeProfiler != null && !nativeProfiler.trim().equals("")) {
                javaLibPath = (javaLibPath.equals("") ? "" : javaLibPath + File.pathSeparator) + nativeProfiler;
            }
        }
        if (OS.isWindows()) {
            String nssRoot = System.getProperty("com.sun.aas.nssRoot");
            String installRoot = System.getProperty("com.sun.aas.installRoot");
            if (installRoot != null && nssRoot != null) {
                javaLibPath = nssRoot + File.pathSeparator + installRoot + File.separator + "lib" + File.pathSeparator + javaLibPath;
            }
        }
        if (this.isDisplayEnabled()) {
            String jvmLibPath = System.getProperty("com.sun.aas.javaRoot") + System.getProperty("com.sun.aas.nativeLauncherLibPrefix");
            if (command.getMode() != null) {
                jvmLibPath = jvmLibPath.substring(0, jvmLibPath.lastIndexOf(File.separator) + 1) + command.getMode().substring(1);
            }
            javaLibPath = javaLibPath != null ? jvmLibPath + File.pathSeparator + javaLibPath : jvmLibPath;
        }
        if (javaLibPath.indexOf(" ") >= 0) {
            this.getLogger().log(Level.WARNING, "launcher.spacesInPath");
            javaLibPath = javaLibPath.replaceAll("\"", "");
        }
        systemProperties.put("java.library.path", javaLibPath);
        System.setProperty("java.library.path", javaLibPath);
        command.setNativeClasspath(javaLibPath);
        if (bDebug) {
            System.out.println("Final java.library.path=" + javaLibPath + "\n");
        }
        return javaLibPath;
    }

    protected void addSystemProperties(SystemProperty[] sp, Properties systemProperties) {
        if (sp != null) {
            for (int ii = 0; ii < sp.length; ++ii) {
                systemProperties.put(sp[ii].getName(), sp[ii].getValue());
            }
        }
    }

    protected void addElementProperties(ElementProperty[] ep, Properties systemProperties) {
        if (ep != null) {
            for (int ii = 0; ii < ep.length; ++ii) {
                systemProperties.put(ep[ii].getName(), ep[ii].getValue());
            }
        }
    }

    protected Logger getLogger() {
        if (this._logger == null) {
            this._logger = Logger.getLogger("javax.enterprise.tools.launcher", "com.sun.logging.enterprise.system.tools.launcher.LogStrings");
            if (!this.isVerboseEnabled()) {
                Handler[] h = this._logger.getParent().getHandlers();
                for (int ii = 0; ii < h.length; ++ii) {
                    if (!h[ii].getClass().getName().equals("java.util.logging.ConsoleHandler")) continue;
                    this._logger.getParent().removeHandler(h[ii]);
                }
            }
        }
        if (bDebug) {
            this._logger.setLevel(Level.FINEST);
        }
        return this._logger;
    }

    protected boolean isInternalLogger() {
        boolean bRet = false;
        String logManager = System.getProperty("java.util.logging.manager");
        if (logManager != null && logManager.equals("com.sun.enterprise.server.logging.ServerLogManager")) {
            bRet = true;
        }
        return bRet;
    }

    protected void addLogFileToLogger(String logFile) {
        if (logFile == null) {
            return;
        }
        this.getLogger().log(Level.FINE, "*** Adding logFileHandler - " + logFile);
        try {
            FileHandler fh = new FileHandler(logFile, true);
            fh.setFormatter(new SimpleFormatter());
            fh.setLevel(Level.ALL);
            this.getLogger().addHandler(fh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void addJvmArguments(Command command, String[] args) {
        String systemProperty = null;
        Object property = null;
        Object value = null;
        if (args != null) {
            block0: for (int ii = 0; ii < args.length; ++ii) {
                systemProperty = args[ii].trim();
                if (bDebug) {
                    System.out.println("addJvmArguments: IN Property " + systemProperty);
                }
                if (systemProperty.trim().equals("")) continue;
                int iSpace = 0;
                int iQuote1 = 0;
                int iQuote2 = 0;
                block1: while (systemProperty.length() > 0) {
                    iSpace = systemProperty.indexOf(" -");
                    iQuote1 = systemProperty.indexOf("\"");
                    if (iSpace >= 0) {
                        if (iQuote1 >= 0) {
                            if (iQuote1 > iSpace && iSpace >= 0) {
                                this.addJvmArg(command, systemProperty.substring(0, iSpace));
                                systemProperty = systemProperty.substring(iSpace + 1).trim();
                                if (!bDebug) continue;
                                System.out.println("*** left 1:" + systemProperty);
                                continue;
                            }
                            int iQuoteStartPos = iQuote1 + 1;
                            while (true) {
                                if ((iQuote2 = systemProperty.indexOf("\"", iQuoteStartPos)) < 0) {
                                    this.getLogger().log(Level.WARNING, "launcher.missMatchQuotesInArg", systemProperty);
                                    systemProperty = "";
                                    continue block1;
                                }
                                if (systemProperty.charAt(iQuote2 - 1) != '\\') break;
                                iQuoteStartPos = iQuote2 + 1;
                            }
                            if (systemProperty.indexOf(" -", iQuote2) < 0) {
                                this.addJvmArg(command, systemProperty);
                                systemProperty = "";
                                continue;
                            }
                            this.addJvmArg(command, systemProperty.substring(0, ++iQuote2));
                            if (iQuote2 < systemProperty.length()) {
                                systemProperty = systemProperty.substring(iQuote2 + 1).trim();
                                if (!bDebug) continue;
                                System.out.println("*** left 2:" + systemProperty);
                                continue;
                            }
                            systemProperty = "";
                            continue;
                        }
                        int iDel = systemProperty.indexOf(" -");
                        while (iDel >= 0) {
                            this.addJvmArg(command, systemProperty.substring(0, iDel));
                            systemProperty = systemProperty.substring(iDel + 1).trim();
                            iDel = systemProperty.indexOf(" -");
                        }
                        if (systemProperty.equals("")) continue block0;
                        this.addJvmArg(command, systemProperty);
                        continue block0;
                    }
                    this.addJvmArg(command, systemProperty);
                    continue block0;
                }
            }
        }
    }

    protected void addJvmArg(Command command, String option) {
        if (option.startsWith("-D")) {
            command.addSystemVariable(option);
        } else if (option.equals("-client") || option.equals("-server")) {
            command.setMode(option);
        } else {
            command.addJvmOption(option);
        }
        if (bDebug) {
            System.out.println("addJvmArguments: OUT Property " + option);
        }
    }

    protected void addDebugOptions(Command command, String debug_options) {
        command.addDebugOption("-Xdebug");
        debug_options = debug_options.trim();
        if (debug_options.startsWith("-Xdebug")) {
            debug_options = debug_options.substring("-Xdebug".length()).trim();
        }
        String transport = this.getDebugProperty(debug_options, "transport");
        String addr = this.getDebugProperty(debug_options, "address");
        if (transport == null || transport.equals("")) {
            System.out.println("Cannot start server in debug mode: no transport specified in debug-options in domain.xml.");
        }
        if (transport.equals("dt_socket") && (addr == null || addr.equals(""))) {
            int port = NetUtils.getFreePort();
            if (port == 0) {
                System.out.println("Cannot start server in debug mode: unable to obtain a free port for transport dt_socket.");
            }
            addr = String.valueOf(port);
            debug_options = debug_options + ",address=" + addr;
        }
        command.addDebugOption(debug_options);
        String jdwpOptions = debug_options.substring(debug_options.indexOf("-Xrunjdwp:") + "-Xrunjdwp:".length());
        command.addSystemVariable("-Dcom.sun.aas.jdwpOptions=" + jdwpOptions);
    }

    protected String getDebugProperty(String debug_options, String name) {
        int nameIndex = debug_options.indexOf(name);
        if (nameIndex != -1) {
            String value = debug_options.substring(nameIndex + name.length() + 1);
            int commaIndex = value.indexOf(",");
            if (commaIndex != -1) {
                value = value.substring(0, commaIndex);
            }
            return value;
        }
        return null;
    }

    protected boolean isWaitEnabled() {
        boolean bRet = false;
        String launcherRet = System.getProperty(LAUNCHER_RETURN_FUNCTION);
        if (launcherRet != null && launcherRet.equals(LAUNCHER_RETURN_FUNCTION_WAIT)) {
            bRet = true;
        }
        return bRet;
    }

    protected boolean isVerboseEnabled() {
        return this.argExists(COMMAND_LINE_ARG_VERBOSE);
    }

    protected boolean isDebugEnabled() {
        return this.argExists(COMMAND_LINE_ARG_DEBUG);
    }

    protected boolean isDisplayEnabled() {
        return this.argExists(COMMAND_LINE_ARG_DISPLAY);
    }

    protected boolean isServerProfile() {
        String processName = this.getProcessLauncherProfile();
        return processName.equals(INTERNAL_SERVER_PROFILE);
    }

    protected boolean isNodeAgentProfile() {
        String processName = this.getProcessLauncherProfile();
        return processName.equals(INTERNAL_NODE_AGENT_PROFILE);
    }

    protected String getFiletRelativeName(String action) {
        return System.getProperty("com.sun.aas.instanceRoot") + File.separator + LAUNCHER_SCRIPT_LOCATION + File.separator + action;
    }

    protected String getProcessLauncherProfile() {
        return System.getProperty(LAUNCHER_PROFILE_NAME, INTERNAL_SERVER_PROFILE);
    }

    protected String getScriptRelativeName(String action) {
        String sxRet = this.getFiletRelativeName(action);
        sxRet = OS.isWindows() ? sxRet + "_temp.bat" : sxRet + "_temp.sh";
        return sxRet;
    }

    protected void setArgs(String[] args) {
        this._args = args;
    }

    protected String[] getArgs() {
        return this._args;
    }

    protected boolean argExists(String arg) {
        boolean bRet = false;
        String[] args = this.getArgs();
        if (args != null) {
            for (int ii = 0; ii < args.length; ++ii) {
                if (!args[ii].equals(arg)) continue;
                bRet = true;
                break;
            }
        }
        return bRet;
    }

    protected boolean createFileStructure(String logFile) {
        boolean bRet = false;
        File outputFile = new File(logFile);
        try {
            File parentFile = new File(outputFile.getParent());
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            if (outputFile.canWrite()) {
                bRet = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!bRet) {
            this.getLogger().log(Level.WARNING, "launcher.logWriteFailure", logFile);
        }
        return bRet;
    }

    protected class StreamFlusher
    extends Thread {
        private InputStream _input = null;
        private OutputStream _output = null;
        private String _logFile = null;

        public StreamFlusher(InputStream input, OutputStream output) {
            this(input, output, null);
        }

        public StreamFlusher(InputStream input, OutputStream output, String logFile) {
            this._input = input;
            this._output = output;
            this._logFile = logFile;
        }

        public void run() {
            if (this._input == null) {
                return;
            }
            PrintStream printStream = null;
            if (this._logFile != null) {
                try {
                    if (ProcessLauncher.this.createFileStructure(this._logFile)) {
                        printStream = new PrintStream(new FileOutputStream(this._logFile, true), true);
                    } else {
                        this._logFile = null;
                    }
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                    this._logFile = null;
                }
            }
            try {
                int byteCnt = 0;
                byte[] buffer = new byte[4096];
                while ((byteCnt = this._input.read(buffer)) != -1) {
                    if (this._output != null && byteCnt > 0) {
                        this._output.write(buffer, 0, byteCnt);
                        this._output.flush();
                        if (this._logFile != null) {
                            printStream.write(buffer, 0, byteCnt);
                            printStream.flush();
                        }
                    }
                    StreamFlusher.yield();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static class Classpath {
        protected Classpath() {
        }

        protected static String getLibClasspath(String libDir, String includes, String excludes) {
            ArrayList<String> arIncludes = new ArrayList<String>();
            ArrayList<String> arExcludes = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(includes, ",");
            while (st.hasMoreTokens()) {
                arIncludes.add(st.nextToken().trim());
            }
            st = new StringTokenizer(excludes, ",");
            while (st.hasMoreTokens()) {
                arExcludes.add(st.nextToken().trim());
            }
            String path = "";
            if (libDir != null && !libDir.equals("")) {
                File dir = new File(libDir);
                String[] filenames = dir.list();
                for (int ii = 0; ii < filenames.length; ++ii) {
                    if (!Classpath.matchStringToList(filenames[ii], arIncludes) || Classpath.matchStringToList(filenames[ii], arExcludes)) continue;
                    path = path + libDir + File.separator + filenames[ii] + File.pathSeparator;
                }
                if (path.endsWith(File.pathSeparator)) {
                    path = path.substring(0, path.length() - 1);
                }
            }
            return path;
        }

        protected static boolean matchStringToList(String filename, ArrayList list) {
            boolean bRet = false;
            String criteria = null;
            String endMatch = null;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                criteria = (String)it.next();
                if (criteria.startsWith("*")) {
                    endMatch = criteria.substring(1);
                    if (!filename.endsWith(endMatch)) continue;
                    bRet = true;
                    break;
                }
                if (Classpath.isRegularExpression(criteria)) {
                    if (!Pattern.matches(criteria, filename)) continue;
                    bRet = true;
                    break;
                }
                if (!filename.equals(criteria)) continue;
                bRet = true;
                break;
            }
            return bRet;
        }

        protected static boolean isRegularExpression(String criteria) {
            boolean bRet = false;
            if (criteria.indexOf("^") > -1 || criteria.indexOf("$") > -1 || criteria.indexOf("[") > -1 || criteria.indexOf("]") > -1 || criteria.indexOf("*") > -1) {
                bRet = true;
            }
            return bRet;
        }
    }

    protected class Command {
        private ArrayList _jvmOptions = new ArrayList();
        private ArrayList _systemVariables = new ArrayList();
        private ArrayList _args = new ArrayList();
        private ArrayList _debugOptions = new ArrayList();
        private String _mainClass = null;
        private String _classpath = null;
        private String _javaCommand = null;
        private String _mode = null;
        private String _logFile = null;
        private String _nativeClasspath = null;

        protected Command() {
        }

        protected void addJvmOption(String jvmOptions) {
            this._jvmOptions.add(jvmOptions.trim());
        }

        protected void addSystemVariable(String systemVariable) {
            this._systemVariables.add(systemVariable.trim());
        }

        protected void addArg(String arg) {
            this._args.add(arg);
        }

        protected String[] getArgs() {
            return this._args.toArray(new String[this._args.size()]);
        }

        protected void removeArg(String arg) {
            this._args.remove(arg);
        }

        protected void addDebugOption(String debugOption) {
            this._debugOptions.add(debugOption);
        }

        protected String[] getDebugOptions() {
            return this._debugOptions.toArray(new String[this._debugOptions.size()]);
        }

        protected void setMode(String mode) {
            this._mode = mode;
        }

        protected String getMode() {
            return this._mode;
        }

        protected void setMainClass(String mainClass) {
            this._mainClass = mainClass;
        }

        protected String getMainClass() {
            return this._mainClass;
        }

        protected void setNativeClasspath(String classpath) {
            this._nativeClasspath = classpath;
        }

        protected String getNativeClasspath() {
            return this._nativeClasspath;
        }

        protected void setClasspath(String classpath) {
            this._classpath = classpath;
        }

        protected String getClasspath() {
            return this._classpath;
        }

        protected void setJavaCommand(String javaCommand) {
            this._javaCommand = javaCommand;
        }

        protected String getJavaCommand() {
            return this._javaCommand;
        }

        protected void setLogFile(String logFile) {
            if (bDebug) {
                System.out.println("Logfile set to " + logFile);
            }
            this._logFile = logFile;
        }

        protected String getLogFile() {
            return this._logFile;
        }

        protected String[] getCommandAsArray() {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this._javaCommand);
            if (this._mode != null) {
                cmd.add(this._mode);
            }
            cmd.addAll(this._debugOptions);
            cmd.addAll(this._jvmOptions);
            cmd.addAll(this._systemVariables);
            cmd.add("-cp");
            cmd.add(this._classpath);
            cmd.add(this._mainClass);
            cmd.addAll(this._args);
            return cmd.toArray(new String[cmd.size()]);
        }

        protected String[] getLimitedCommandAsArray() {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this._javaCommand);
            if (this._mode != null) {
                cmd.add(this._mode);
            }
            cmd.addAll(this._debugOptions);
            cmd.addAll(this._jvmOptions);
            cmd.addAll(this._systemVariables);
            cmd.add(this._mainClass);
            cmd.addAll(this._args);
            return cmd.toArray(new String[cmd.size()]);
        }

        protected String[] getCommandInJNIFormatAsArray() {
            String jniMainClassName = this._mainClass;
            int iPos = 0;
            while ((iPos = jniMainClassName.indexOf(".")) >= 0) {
                jniMainClassName = jniMainClassName.substring(0, iPos) + "/" + jniMainClassName.substring(iPos + 1);
            }
            ArrayList<String> cmd = new ArrayList<String>();
            if (this._mode != null) {
                cmd.add(this._mode);
            }
            cmd.addAll(this._debugOptions);
            cmd.addAll(this._jvmOptions);
            cmd.addAll(this._systemVariables);
            cmd.add("-Djava.class.path=" + this._classpath);
            cmd.add(this._mainClass);
            cmd.addAll(this._args);
            return cmd.toArray(new String[cmd.size()]);
        }

        protected String[] getSystemVariablesAsArray() {
            ArrayList cmd = new ArrayList();
            cmd.addAll(this._systemVariables);
            return cmd.toArray(new String[cmd.size()]);
        }

        public String toString() {
            StringBuffer cmd = new StringBuffer();
            String[] ret = this.getCommandAsArray();
            for (int ii = 0; ii < ret.length; ++ii) {
                cmd.append(ret[ii]);
            }
            return cmd.toString();
        }

        public String toStringWithLines() {
            StringBuffer cmd = new StringBuffer();
            String[] ret = this.getCommandAsArray();
            for (int ii = 0; ii < ret.length; ++ii) {
                cmd.append("\n" + ret[ii]);
            }
            return cmd.toString();
        }
    }
}

