/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss;

import com.sun.enterprise.server.PEMain;
import com.sun.enterprise.server.ss.ASServerSocket;
import com.sun.enterprise.server.ss.PortConflictException;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASSocketService {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(ASSocketService.class);
    private static HashMap managedPortsTable = new HashMap();
    private static PEMain peMain = null;
    private static InetAddress localHost = null;
    private ServerSocket ss;
    private ServerSocketChannel sschan;
    private int port = 0;
    private String address = null;
    private static final int TIMEOUT = 30000;
    private static boolean triggered = false;
    private static Object lock = new Object();

    ASSocketService(String address, int port) {
        this.port = port;
        this.address = address;
        if (localHost == null) {
            try {
                localHost = InetAddress.getLocalHost();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws PortConflictException {
        try {
            HashMap hashMap = managedPortsTable;
            synchronized (hashMap) {
                managedPortsTable.put(new Integer(this.port), this);
            }
            this.sschan = ServerSocketChannel.open();
            this.ss = this.sschan.socket();
            InetSocketAddress isa = null;
            isa = this.address == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.address, this.port);
            this.ss.bind(isa);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Successfully started at port " + this.port);
            }
        }
        catch (IOException ie) {
            String i18nMsg = localStrings.getString("socketservice.port_conflict", new Object[]{String.valueOf(this.port)});
            throw new PortConflictException(this.port, i18nMsg, ie);
        }
    }

    static ServerSocket getServerSocket(int port) {
        ASSocketService a = (ASSocketService)managedPortsTable.get(new Integer(port));
        return a.ss;
    }

    static ServerSocketChannel getServerSocketChannel(int port) {
        ASSocketService a = (ASSocketService)managedPortsTable.get(new Integer(port));
        return a.sschan;
    }

    static boolean exists(int port) {
        return managedPortsTable.containsKey(new Integer(port));
    }

    static void initialize() {
        if (peMain == null) {
            peMain = PEMain.getInstance();
        }
    }

    static void waitOnAccept(SocketChannel sc) {
        if (peMain.isStartingUp()) {
            ASSocketService.waitOnAccept(sc.socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitOnAccept(Socket s) {
        if (peMain.isStartingUp()) {
            int localPort = s.getLocalPort();
            if (!ASSocketService.exists(localPort)) {
                return;
            }
            Integer remotePort = new Integer(s.getPort());
            PEMain pEMain = peMain;
            synchronized (pEMain) {
                while (peMain.isStartingUp() && !ASSocketService.hasClientSocketLocalPorts(s)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("In ASSocketService.waitOnAccept for localport " + localPort);
                    }
                    try {
                        peMain.wait();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clientSocketConnected(Socket s) {
        if (peMain.isStartingUp()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("In ASSocketService.clientSocketConnected, adding port " + s.getLocalPort());
            }
            PEMain pEMain = peMain;
            synchronized (pEMain) {
                ASSocketService.putClientSocketLocalPort(s);
                peMain.notifyAll();
            }
        }
    }

    static void putClientSocketLocalPort(Socket s) {
        int serverPort = s.getPort();
        if (ASSocketService.exists(serverPort)) {
            ASServerSocket ss = (ASServerSocket)ASSocketService.getServerSocket(serverPort);
            ss.addClientSocketLocalPort(s.getLocalPort());
        }
    }

    static boolean hasClientSocketLocalPorts(Socket s) {
        ASServerSocket ss = (ASServerSocket)ASSocketService.getServerSocket(s.getLocalPort());
        return ss.hasClientSocketLocalPorts();
    }

    static boolean isLocalClient(Socket s) {
        InetAddress remoteAddr = s.getInetAddress();
        return remoteAddr.equals(localHost) || remoteAddr.isSiteLocalAddress() || remoteAddr.isLinkLocalAddress() || remoteAddr.isLoopbackAddress() || remoteAddr.isAnyLocalAddress();
    }

    static boolean isServerStartingUp() {
        return peMain.isStartingUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerServerExit() {
        Object object = lock;
        synchronized (object) {
            triggered = true;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForClientNotification() {
        Object object = lock;
        synchronized (object) {
            if (!triggered) {
                try {
                    lock.wait(30000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

