/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss;

import com.sun.enterprise.server.ss.ASChannel;
import com.sun.enterprise.server.ss.ASServerSocket;
import com.sun.enterprise.server.ss.ASSocketService;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

class ASServerSocketChannel
extends ServerSocketChannel
implements ASChannel {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private ServerSocketChannel ssc = null;
    private ServerSocket ssocket = null;

    ASServerSocketChannel(ServerSocketChannel ssc, SelectorProvider p) {
        super(p);
        this.ssc = ssc;
    }

    public ServerSocket socket() {
        try {
            if (this.ssocket == null) {
                ServerSocket ss = this.ssc.socket();
                this.ssocket = new ASServerSocket(ss, this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.ssocket;
    }

    public SocketChannel accept() throws IOException {
        SocketChannel sc = this.ssc.accept();
        if (logger.isLoggable(Level.FINE)) {
            Socket s = sc.socket();
            logger.fine("In ASServerSocketChannel.accept got connection, s.port=" + s.getPort() + " s.localPort=" + s.getLocalPort());
        }
        ASSocketService.waitOnAccept(sc);
        return sc;
    }

    public void implConfigureBlocking(boolean b) throws IOException {
        this.ssc.configureBlocking(b);
    }

    public void implCloseSelectableChannel() throws IOException {
        this.ssc.close();
    }

    public SelectableChannel getActualChannel() {
        return this.ssc;
    }

    void setServerSocketChannel(ServerSocketChannel ssc) {
        this.ssc = ssc;
    }

    public String toString() {
        return "ASServerSocketChannel[" + this.ssc.toString() + "]";
    }
}

