/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss;

import com.sun.enterprise.server.ss.ASSelector;
import com.sun.enterprise.server.ss.ASServerSocketChannel;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;

public class ASSelectorProvider
extends SelectorProvider {
    static final int PORT_UNBOUND = 0;
    static final int PORT_BOUND = 1;
    static final int PORT_CONFLICT = 2;
    private SelectorProvider provider = null;
    private HashMap statemap = new HashMap();
    private HashMap socketmap = new HashMap();

    public ASSelectorProvider() {
        this.provider = this.getProvider();
    }

    public DatagramChannel openDatagramChannel() throws IOException {
        return this.provider.openDatagramChannel();
    }

    public Pipe openPipe() throws IOException {
        return this.provider.openPipe();
    }

    public ServerSocketChannel openServerSocketChannel() throws IOException {
        ServerSocketChannel ssc = this.provider.openServerSocketChannel();
        return new ASServerSocketChannel(ssc, this);
    }

    public SocketChannel openSocketChannel() throws IOException {
        return this.provider.openSocketChannel();
    }

    public AbstractSelector openSelector() throws IOException {
        AbstractSelector sel = this.provider.openSelector();
        return new ASSelector(sel, this);
    }

    ServerSocket getServerSocket(SocketAddress s) {
        return (ServerSocket)this.socketmap.get(s);
    }

    int getPortState(SocketAddress s) {
        Integer i = (Integer)this.statemap.get(s);
        if (i == null) {
            return 0;
        }
        return i;
    }

    void setServerSocket(ServerSocket ss, SocketAddress s) {
        int state = this.getPortState(s);
        if (state == 0) {
            this.socketmap.put(s, ss);
            this.statemap.put(s, new Integer(1));
        } else if (state == 1) {
            this.statemap.put(s, new Integer(2));
        }
    }

    private SelectorProvider getProvider() {
        SelectorProvider sp = null;
        try {
            Class<?> clazz = Class.forName("sun.nio.ch.DefaultSelectorProvider");
            Method createMeth = clazz.getMethod("create", new Class[0]);
            sp = (SelectorProvider)createMeth.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create default SelectorProvider.", e);
        }
        return sp;
    }
}

