/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.diagnostics;

import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleLocator {
    private static Hashtable moduleIdToResourceBundleTable;
    private static String[] jdoResourceBundles;

    public static ResourceBundle getResourceBundleForMessageId(String messageId) {
        String moduleId = ResourceBundleLocator.getModuleId(messageId);
        if (moduleId == null) {
            return null;
        }
        ResourceBundle rb = null;
        rb = moduleId.equals("JDO") ? ResourceBundleLocator.getResourceBundleForJDOMessageId(messageId) : ResourceBundleLocator.getResourceBundleForModuleId(moduleId);
        return rb;
    }

    public static ResourceBundle getResourceBundleForModuleId(String moduleId) {
        if (moduleId == null) {
            return null;
        }
        String bundleName = null;
        try {
            bundleName = (String)moduleIdToResourceBundleTable.get(moduleId);
            if (bundleName == null) {
                return null;
            }
            return ResourceBundle.getBundle(bundleName, Locale.getDefault(), ResourceBundleLocator.getClassLoader());
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            return null;
        }
    }

    public static ResourceBundle getResourceBundleForJDOMessageId(String messageId) {
        for (int i = 0; i < jdoResourceBundles.length; ++i) {
            ResourceBundle rb = ResourceBundle.getBundle(jdoResourceBundles[i], Locale.getDefault(), ResourceBundleLocator.getClassLoader());
            if (rb == null) continue;
            try {
                if (rb.getString(messageId + ".diag.cause." + 1) == null) continue;
                return rb;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public static String getModuleId(String messageId) {
        if (messageId == null || messageId.length() == 0) {
            return null;
        }
        int lastIndex = 6;
        if (messageId.length() < lastIndex) {
            lastIndex = messageId.length();
        }
        char[] moduleIdCharacters = messageId.substring(0, lastIndex).toCharArray();
        lastIndex = moduleIdCharacters.length;
        if (Character.isDigit(moduleIdCharacters[moduleIdCharacters.length - 1])) {
            for (int index = moduleIdCharacters.length - 1; index > 0; --index) {
                if (Character.isDigit(moduleIdCharacters[index])) continue;
                lastIndex = index + 1;
                break;
            }
        }
        return messageId.substring(0, lastIndex);
    }

    static {
        jdoResourceBundles = new String[]{"com.sun.jdo.spi.persistence.support.ejb.ejbc.Bundle", "com.sun.jdo.spi.persistence.generator.database.Bundle", "com.sun.jdo.spi.persistence.support.ejb.ejbqlc.Bundle", "com.sun.jdo.spi.persistence.support.sqlstore.Bundle", "com.sun.jdo.spi.persistence.utility.logging.Bundle"};
        moduleIdToResourceBundleTable = new Hashtable();
        moduleIdToResourceBundleTable.put("ADM", "com.sun.logging.enterprise.system.tools.admin.LogStrings");
        moduleIdToResourceBundleTable.put("CONF", "com.sun.logging.enterprise.system.core.config.LogStrings");
        moduleIdToResourceBundleTable.put("DPL", "com.sun.logging.enterprise.system.tools.deployment.LogStrings");
        moduleIdToResourceBundleTable.put("EJB", "com.sun.logging.enterprise.system.container.ejb.LogStrings");
        moduleIdToResourceBundleTable.put("IOP", "com.sun.corba.ee.impl.logging.LogStrings");
        moduleIdToResourceBundleTable.put("JAXR", "com.sun.logging.enterprise.system.webservices.registry.LogDomains");
        moduleIdToResourceBundleTable.put("NAM", "com.sun.logging.enterprise.system.core.naming.LogStrings");
        moduleIdToResourceBundleTable.put("DTX", "com.sun.logging.enterprise.resource.jta.LogStrings");
        moduleIdToResourceBundleTable.put("SYNC", "com.sun.logging.ee.enterprise.system.tools.synchronization.LogStrings");
        moduleIdToResourceBundleTable.put("HADBMG", "com.sun.enterprise.ee.admin.hadbmgmt.LocalStrings");
        moduleIdToResourceBundleTable.put("JAXRPC", "com.sun.logging.enterprise.system.webservices.rpc.LogDomains");
        moduleIdToResourceBundleTable.put("JML", "com.sun.logging.enterprise.resource.javamail.LogStrings");
        moduleIdToResourceBundleTable.put("JMS", "com.sun.logging.enterprise.resource.jms.LogStrings");
        moduleIdToResourceBundleTable.put("JTS", "com.sun.logging.enterprise.system.core.transaction.LogStrings");
        moduleIdToResourceBundleTable.put("LDR", "com.sun.logging.enterprise.system.core.classloading.LogStrings");
        moduleIdToResourceBundleTable.put("MDB", "com.sun.logging.enterprise.system.container.ejb.mdb.LogStrings");
        moduleIdToResourceBundleTable.put("JNDI", "com.sun.logging.enterprise.system.core.naming.LogStrings");
        moduleIdToResourceBundleTable.put("RAR", "com.sun.logging.enterprise.resource.resourceadapter.LogStrings");
        moduleIdToResourceBundleTable.put("SAAJ", "com.sun.logging.enterprise.system.webservices.saaj.LogDomains");
        moduleIdToResourceBundleTable.put("SEC", "com.sun.logging.enterprise.system.core.security.LogStrings");
        moduleIdToResourceBundleTable.put("SERVER", "com.sun.logging.enterprise.system.LogStrings");
        moduleIdToResourceBundleTable.put("TLS", "com.sun.logging.enterprise.system.tools.LogStrings");
        moduleIdToResourceBundleTable.put("UTIL", "com.sun.logging.enterprise.system.util.LogStrings");
        moduleIdToResourceBundleTable.put("VRFY", "com.sun.logging.enterprise.system.tools.verifier.LogStrings");
        moduleIdToResourceBundleTable.put("WEB", "com.sun.logging.enterprise.system.container.web.LogStrings");
        moduleIdToResourceBundleTable.put("TEST", "com.sun.enterprise.server.logging.diagnostics.LogStrings");
    }
}

