/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.lang.reflect.Method;
import javax.naming.InitialContext;

public class ServerContextImpl
implements ServerContext {
    public final String SERVER_XML = "domain.xml";
    public final String DEFAULT_DOMAIN_NAME = "com.sun.appserv";
    public final String CONFIG_DIR = "config";
    private String[] cmdLineArgs;
    private PluggableFeatureFactory featureFactory;
    private String installRoot = System.getProperty("com.sun.aas.installRoot");
    private String instanceName = System.getProperty("com.sun.aas.instanceName");
    private static StringManager localStrings = StringManager.getManager("com.sun.enterprise.server");
    private static ClassLoader commonClassLoader;
    private static ClassLoader sharedClassLoader;
    private ClassLoader lifeCycleClassLoader;
    private ConfigContext configContext;
    private Server server;
    private String serverConfigPath = null;
    private String serverConfigURL = null;
    private InstanceEnvironment instanceEnvironment = null;

    public ServerContextImpl() {
        this.getInstanceEnvironment();
    }

    protected void setCmdLineArgs(String[] cmdLineArgs) {
        this.cmdLineArgs = cmdLineArgs;
    }

    public String[] getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    public void setPluggableFeatureFactory(PluggableFeatureFactory obj) {
        this.featureFactory = obj;
    }

    public PluggableFeatureFactory getPluggableFeatureFactory() {
        return this.featureFactory;
    }

    protected void setInstallRoot(String installRoot) {
        this.installRoot = installRoot;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    protected void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getServerConfigPath() {
        return this.instanceEnvironment.getConfigDirPath();
    }

    public String getConfigURL(String configName) {
        String configURI = this.instanceEnvironment.getConfigFilePath();
        return configURI;
    }

    public String getServerConfigURL() {
        return this.instanceEnvironment.getConfigFilePath();
    }

    public InitialContext getInitialContext() {
        NamingManager mgr = Switch.getSwitch().getNamingManager();
        if (mgr == null) {
            return null;
        }
        return (InitialContext)mgr.getInitialContext();
    }

    private boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public Server getConfigBean() throws ConfigException {
        if (this.server != null) {
            return this.server;
        }
        if (this.configContext == null) {
            String msg = localStrings.getString("serverContext.config_context_is_null");
            throw new ConfigException(msg);
        }
        this.server = ServerBeansFactory.getServerBean(this.configContext);
        return this.server;
    }

    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    public void setConfigContext(ConfigContext config) {
        this.configContext = config;
    }

    public ClassLoader getCommonClassLoader() {
        return commonClassLoader;
    }

    protected void setCommonClassLoader(ClassLoader cl) {
        commonClassLoader = cl;
    }

    public ClassLoader getSharedClassLoader() {
        return sharedClassLoader;
    }

    protected void setSharedClassLoader(ClassLoader cl) {
        sharedClassLoader = cl;
    }

    public ClassLoader getLifecycleParentClassLoader() {
        return this.lifeCycleClassLoader;
    }

    protected void setLifecycleParentClassLoader(ClassLoader cl) {
        this.lifeCycleClassLoader = cl;
    }

    public InstanceEnvironment getInstanceEnvironment() {
        if (this.instanceEnvironment == null) {
            this.instanceEnvironment = new InstanceEnvironment(this.instanceName);
        }
        return this.instanceEnvironment;
    }

    void setInstanceEnvironment(InstanceEnvironment instanceEnv) {
        this.instanceEnvironment = instanceEnv;
    }

    public InvocationManager getInvocationManager() {
        return Switch.getSwitch().getInvocationManager();
    }

    public String getDefaultDomainName() {
        return "com.sun.appserv";
    }

    public MonitoringRegistry getMonitoringRegistry() {
        String REG_IMPL_CLASS = "com.sun.enterprise.admin.monitor.registry.spi.MonitoringRegistrationHelper";
        String METHOD = "getInstance";
        try {
            Class<?> c = Class.forName("com.sun.enterprise.admin.monitor.registry.spi.MonitoringRegistrationHelper");
            Method m = c.getMethod("getInstance", null);
            MonitoringRegistry r = (MonitoringRegistry)m.invoke(c, null);
            return r;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

