/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.InstanceFactory;
import com.sun.enterprise.server.ApplicationManager;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.StandAloneAppClientModulesManager;
import com.sun.enterprise.server.StandAloneConnectorModulesManager;
import com.sun.enterprise.server.StandAloneEJBModulesManager;
import com.sun.enterprise.server.StandaloneWebModulesManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

class ManagerFactory {
    private static ApplicationManager applicationManager;
    private static StandAloneConnectorModulesManager saConnectorManager;
    private static StandaloneWebModulesManager saWebManager;
    private static StandAloneEJBModulesManager saEJBManager;
    private static StandAloneAppClientModulesManager saACManager;
    private static InstanceEnvironment iEnv;
    private static ClassLoader sharedCL;
    static Logger _logger;

    ManagerFactory() {
    }

    public static ApplicationManager getApplicationManager() throws ConfigException {
        if (applicationManager == null) {
            AppsManager appsManager = InstanceFactory.createAppsManager(ManagerFactory.getInstanceEnvironment(), false);
            try {
                if (appsManager.isByteCodePreprocessingEnabled()) {
                    PreprocessorUtil.init(appsManager.getBytecodeProcessorClassNames());
                }
            }
            catch (ConfigException confEx) {
                _logger.log(Level.WARNING, "core.preprocessor_config_ex", confEx);
                _logger.log(Level.WARNING, "core.preprocessor_disabled");
            }
            applicationManager = new ApplicationManager(appsManager, ManagerFactory.getSharedClassLoader());
        }
        return applicationManager;
    }

    public static StandAloneConnectorModulesManager getSAConnectorModulesManager() throws ConfigException {
        if (saConnectorManager == null) {
            ConnectorModulesManager connModuleManager = InstanceFactory.createConnectorModuleManager(ManagerFactory.getInstanceEnvironment(), false);
            saConnectorManager = new StandAloneConnectorModulesManager(connModuleManager, ManagerFactory.getSharedClassLoader());
        }
        return saConnectorManager;
    }

    public static StandaloneWebModulesManager getSAWebModulesManager() throws ConfigException {
        if (saWebManager == null) {
            // empty if block
        }
        return saWebManager;
    }

    public static StandAloneEJBModulesManager getSAEJBModulesManager() throws ConfigException {
        if (saEJBManager == null) {
            EjbModulesManager ejbModuleManager = InstanceFactory.createEjbModuleManager(ManagerFactory.getInstanceEnvironment(), false);
            saEJBManager = new StandAloneEJBModulesManager(ejbModuleManager, ManagerFactory.getSharedClassLoader());
        }
        return saEJBManager;
    }

    public static StandAloneAppClientModulesManager getSAACModulesManager() throws ConfigException {
        if (saACManager == null) {
            AppclientModulesManager acModuleManager = InstanceFactory.createAppclientModulesManager(ManagerFactory.getInstanceEnvironment());
            saACManager = new StandAloneAppClientModulesManager(acModuleManager, ManagerFactory.getSharedClassLoader());
        }
        return saACManager;
    }

    private static InstanceEnvironment getInstanceEnvironment() {
        if (iEnv == null) {
            ServerContext sc = ApplicationServer.getServerContext();
            iEnv = sc.getInstanceEnvironment();
        }
        return iEnv;
    }

    private static ClassLoader getSharedClassLoader() {
        if (sharedCL == null) {
            ServerContext sc = ApplicationServer.getServerContext();
            sharedCL = sc.getSharedClassLoader();
        }
        return sharedCL;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
    }
}

