/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

class EJBModuleLoader
extends AbstractLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");

    EJBModuleLoader(String modID, ClassLoader parentClassLoader, EjbModulesManager ejbModulesManager) {
        super(modID, parentClassLoader, ejbModulesManager);
        String[] classPath = EJBClassPathUtils.getEjbModuleClasspath(modID, ejbModulesManager);
        this.initializeLoader(classPath);
        try {
            this.application = ejbModulesManager.getDescriptor(modID, this.ejbClassLoader);
        }
        catch (ConfigException confEx) {
            _logger.log(Level.SEVERE, "loader.configexception", confEx);
        }
    }

    boolean load(boolean jsr77) {
        this.notifyAppEvent(0);
        boolean status = this.loadEjbs(jsr77);
        if (status) {
            this.notifyAppEvent(1);
        }
        return status;
    }

    boolean unload(boolean jsr77) {
        this.notifyAppEvent(2);
        boolean result = this.unloadEjbs(jsr77);
        this.configManager.unregisterDescriptor(this.id);
        this.notifyAppEvent(3);
        this.done();
        return result;
    }

    void createRootMBean() throws MBeanException {
        Object eddf = null;
        Set ejbBundles = this.application.getEjbBundleDescriptors();
        Iterator it = ejbBundles.iterator();
        while (it.hasNext()) {
            EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)it.next();
            try {
                Switch.getSwitch().getManagementObjectManager().createEJBModuleMBean(bundleDesc, this.configManager.getInstanceEnvironment().getName(), this.configManager.getLocation(this.id));
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
    }

    void deleteRootMBean() throws MBeanException {
        Set ejbBundles = this.application.getEjbBundleDescriptors();
        Iterator it = ejbBundles.iterator();
        while (it.hasNext()) {
            EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)it.next();
            Switch.getSwitch().getManagementObjectManager().deleteEJBModuleMBean(bundleDesc, this.configManager.getInstanceEnvironment().getName());
        }
    }

    void createLeafMBeans() throws MBeanException {
        Set ejbBundles = this.application.getEjbBundleDescriptors();
        Iterator it = ejbBundles.iterator();
        while (it.hasNext()) {
            EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)it.next();
            Switch.getSwitch().getManagementObjectManager().createEJBMBeans(bundleDesc, this.configManager.getInstanceEnvironment().getName());
        }
    }

    void createLeafMBean(Descriptor descriptor) throws MBeanException {
        EjbDescriptor ejbDescriptor = null;
        try {
            ejbDescriptor = (EjbDescriptor)descriptor;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        Switch.getSwitch().getManagementObjectManager().createEJBMBean(ejbDescriptor, this.configManager.getInstanceEnvironment().getName());
    }

    void deleteLeafMBeans() throws MBeanException {
        Set ejbBundles = this.application.getEjbBundleDescriptors();
        Iterator it = ejbBundles.iterator();
        while (it.hasNext()) {
            EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)it.next();
            Switch.getSwitch().getManagementObjectManager().deleteEJBMBeans(bundleDesc, this.configManager.getInstanceEnvironment().getName());
        }
    }

    void deleteLeafMBean(Descriptor descriptor) throws MBeanException {
        EjbDescriptor ejbDescriptor = null;
        try {
            ejbDescriptor = (EjbDescriptor)descriptor;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        Switch.getSwitch().getManagementObjectManager().deleteEJBMBean(ejbDescriptor, this.configManager.getInstanceEnvironment().getName());
    }

    void deleteLeafAndRootMBeans() throws MBeanException {
        this.deleteLeafMBeans();
        this.deleteRootMBean();
    }

    void setState(int state) throws MBeanException {
        Set ejbBundles = this.application.getEjbBundleDescriptors();
        Iterator it = ejbBundles.iterator();
        while (it.hasNext()) {
            EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)it.next();
            Switch.getSwitch().getManagementObjectManager().setEJBModuleState(state, bundleDesc, this.configManager.getInstanceEnvironment().getName());
        }
    }
}

